/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ClassLoaderBase
extends URLClassLoader {
    private final ConcurrentHashMap<String, Object> parallelLockMap = new ConcurrentHashMap();
    protected static final String DEFAULT_LOCAL_DIR = "/tmp/hbase-local-dir";
    protected static final String LOCAL_DIR_KEY = "hbase.local.dir";
    protected final ClassLoader parent;

    public ClassLoaderBase(ClassLoader parent) {
        super(new URL[0], parent);
        Preconditions.checkNotNull(parent, "No parent classloader!");
        this.parent = parent;
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        Object lock = this.parallelLockMap.get(className);
        if (lock != null) {
            return lock;
        }
        Object newLock = new Object();
        lock = this.parallelLockMap.putIfAbsent(className, newLock);
        if (lock == null) {
            lock = newLock;
        }
        return lock;
    }
}

