/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.LabelAlreadyExistsException;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsCache;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class DefaultVisibilityLabelServiceImpl
implements VisibilityLabelService {
    private static final Log LOG = LogFactory.getLog(DefaultVisibilityLabelServiceImpl.class);
    private static final int SYSTEM_LABEL_ORDINAL = 1;
    private static final Tag[] LABELS_TABLE_TAGS = new Tag[1];
    private static final byte[] DUMMY_VALUE = new byte[0];
    private AtomicInteger ordinalCounter = new AtomicInteger(-1);
    private Configuration conf;
    private Region labelsRegion;
    private VisibilityLabelsCache labelsCache;
    private List<ScanLabelGenerator> scanLabelGenerators;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(RegionCoprocessorEnvironment e) throws IOException {
        ZooKeeperWatcher zk = e.getRegionServerServices().getZooKeeper();
        try {
            this.labelsCache = VisibilityLabelsCache.createAndGet(zk, this.conf);
        }
        catch (IOException ioe) {
            LOG.error("Error creating VisibilityLabelsCache", ioe);
            throw ioe;
        }
        this.scanLabelGenerators = VisibilityUtils.getScanLabelGenerators(this.conf);
        if (e.getRegion().getRegionInfo().getTable().equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            byte[] serialized;
            this.labelsRegion = e.getRegion();
            Pair<Map<String, Integer>, Map<String, List<Integer>>> labelsAndUserAuths = this.extractLabelsAndAuths(this.getExistingLabelsWithAuths());
            Map<String, Integer> labels = labelsAndUserAuths.getFirst();
            Map<String, List<Integer>> userAuths = labelsAndUserAuths.getSecond();
            this.addSystemLabel(this.labelsRegion, labels, userAuths);
            int ordinal = 1;
            for (Integer i : labels.values()) {
                if (i <= ordinal) continue;
                ordinal = i;
            }
            this.ordinalCounter.set(ordinal + 1);
            if (labels.size() > 0) {
                serialized = VisibilityUtils.getDataToWriteToZooKeeper(labels);
                this.labelsCache.writeToZookeeper(serialized, true);
                this.labelsCache.refreshLabelsCache(serialized);
            }
            if (userAuths.size() > 0) {
                serialized = VisibilityUtils.getUserAuthsDataToWriteToZooKeeper(userAuths);
                this.labelsCache.writeToZookeeper(serialized, false);
                this.labelsCache.refreshUserAuthsCache(serialized);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<List<Cell>> getExistingLabelsWithAuths() throws IOException {
        Scan scan = new Scan();
        ArrayList<List<Cell>> existingLabels = new ArrayList<List<Cell>>();
        try (RegionScanner scanner = this.labelsRegion.getScanner(scan);){
            while (true) {
                ArrayList<Cell> cells = new ArrayList<Cell>();
                scanner.next(cells);
                if (cells.isEmpty()) {
                    break;
                }
                existingLabels.add(cells);
            }
        }
        return existingLabels;
    }

    protected Pair<Map<String, Integer>, Map<String, List<Integer>>> extractLabelsAndAuths(List<List<Cell>> labelDetails) {
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        HashMap<String, ArrayList<Integer>> userAuths = new HashMap<String, ArrayList<Integer>>();
        for (List<Cell> cells : labelDetails) {
            for (Cell cell : cells) {
                if (Bytes.equals(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), VisibilityConstants.LABEL_QUALIFIER, 0, VisibilityConstants.LABEL_QUALIFIER.length)) {
                    labels.put(Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()), Bytes.toInt(cell.getRowArray(), cell.getRowOffset()));
                    continue;
                }
                String user = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                ArrayList<Integer> auths = (ArrayList<Integer>)userAuths.get(user);
                if (auths == null) {
                    auths = new ArrayList<Integer>();
                    userAuths.put(user, auths);
                }
                auths.add(Bytes.toInt(cell.getRowArray(), cell.getRowOffset()));
            }
        }
        return new Pair<Map<String, Integer>, Map<String, List<Integer>>>(labels, userAuths);
    }

    protected void addSystemLabel(Region region, Map<String, Integer> labels, Map<String, List<Integer>> userAuths) throws IOException {
        if (!labels.containsKey("system")) {
            Put p = new Put(Bytes.toBytes(1));
            p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER, Bytes.toBytes("system"));
            region.put(p);
            labels.put("system", 1);
        }
    }

    @Override
    public OperationStatus[] addLabels(List<byte[]> labels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[labels.size()];
        ArrayList<Mutation> puts = new ArrayList<Mutation>(labels.size());
        int i = 0;
        for (byte[] label : labels) {
            String labelStr = Bytes.toString(label);
            if (this.labelsCache.getLabelOrdinal(labelStr) > 0) {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, new LabelAlreadyExistsException("Label '" + labelStr + "' already exists"));
            } else {
                Put p = new Put(Bytes.toBytes(this.ordinalCounter.get()));
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER, label, LABELS_TABLE_TAGS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding the label " + labelStr);
                }
                puts.add(p);
                this.ordinalCounter.incrementAndGet();
            }
            ++i;
        }
        if (this.mutateLabelsRegion(puts, finalOpStatus)) {
            this.updateZk(true);
        }
        return finalOpStatus;
    }

    @Override
    public OperationStatus[] setAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        ArrayList<Mutation> puts = new ArrayList<Mutation>(authLabels.size());
        int i = 0;
        for (byte[] auth : authLabels) {
            String authStr = Bytes.toString(auth);
            int labelOrdinal = this.labelsCache.getLabelOrdinal(authStr);
            if (labelOrdinal == 0) {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, new InvalidLabelException("Label '" + authStr + "' doesn't exists"));
            } else {
                Put p = new Put(Bytes.toBytes(labelOrdinal));
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, user, DUMMY_VALUE, LABELS_TABLE_TAGS);
                puts.add(p);
            }
            ++i;
        }
        if (this.mutateLabelsRegion(puts, finalOpStatus)) {
            this.updateZk(false);
        }
        return finalOpStatus;
    }

    @Override
    public OperationStatus[] clearAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        List<String> currentAuths;
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        if (AuthUtil.isGroupPrincipal(Bytes.toString(user))) {
            String group = AuthUtil.getGroupName(Bytes.toString(user));
            currentAuths = this.getGroupAuths(new String[]{group}, true);
        } else {
            currentAuths = this.getUserAuths(user, true);
        }
        ArrayList<Mutation> deletes = new ArrayList<Mutation>(authLabels.size());
        int i = 0;
        for (byte[] authLabel : authLabels) {
            String authLabelStr = Bytes.toString(authLabel);
            if (currentAuths.contains(authLabelStr)) {
                int labelOrdinal = this.labelsCache.getLabelOrdinal(authLabelStr);
                assert (labelOrdinal > 0);
                Delete d = new Delete(Bytes.toBytes(labelOrdinal));
                d.deleteColumns(VisibilityConstants.LABELS_TABLE_FAMILY, user);
                deletes.add(d);
            } else {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, new InvalidLabelException("Label '" + authLabelStr + "' is not set for the user " + Bytes.toString(user)));
            }
            ++i;
        }
        if (this.mutateLabelsRegion(deletes, finalOpStatus)) {
            this.updateZk(false);
        }
        return finalOpStatus;
    }

    private boolean mutateLabelsRegion(List<Mutation> mutations, OperationStatus[] finalOpStatus) throws IOException {
        OperationStatus[] opStatus = this.labelsRegion.batchMutate(mutations.toArray(new Mutation[mutations.size()]), 0L, 0L);
        int i = 0;
        boolean updateZk = false;
        block0: for (OperationStatus status : opStatus) {
            boolean bl = updateZk = updateZk || status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS;
            while (i < finalOpStatus.length) {
                if (finalOpStatus[i] == null) {
                    finalOpStatus[i] = status;
                    continue block0;
                }
                ++i;
            }
        }
        return updateZk;
    }

    @Override
    @Deprecated
    public List<String> getAuths(byte[] user, boolean systemCall) throws IOException {
        return this.getUserAuths(user, systemCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUserAuths(byte[] user, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        if (systemCall || this.labelsRegion == null) {
            return this.labelsCache.getUserAuths(Bytes.toString(user));
        }
        Scan s = new Scan();
        if (user != null && user.length > 0) {
            s.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, user);
        }
        Filter filter = VisibilityUtils.createVisibilityLabelFilter(this.labelsRegion, new Authorizations("system"));
        s.setFilter(filter);
        ArrayList<String> auths = new ArrayList<String>();
        try (RegionScanner scanner = this.labelsRegion.getScanner(s);){
            ArrayList<Cell> results = new ArrayList<Cell>(1);
            while (true) {
                scanner.next(results);
                if (results.isEmpty()) {
                    break;
                }
                Cell cell = (Cell)results.get(0);
                int ordinal = Bytes.toInt(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                String label = this.labelsCache.getLabel(ordinal);
                if (label != null) {
                    auths.add(label);
                }
                results.clear();
            }
        }
        return auths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getGroupAuths(String[] groups, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        if (systemCall || this.labelsRegion == null) {
            return this.labelsCache.getGroupAuths(groups);
        }
        Scan s = new Scan();
        if (groups != null && groups.length > 0) {
            for (String group : groups) {
                s.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, Bytes.toBytes(AuthUtil.toGroupEntry(group)));
            }
        }
        Filter filter = VisibilityUtils.createVisibilityLabelFilter(this.labelsRegion, new Authorizations("system"));
        s.setFilter(filter);
        HashSet<String> auths = new HashSet<String>();
        try (RegionScanner scanner = this.labelsRegion.getScanner(s);){
            ArrayList<Cell> results = new ArrayList<Cell>(1);
            while (true) {
                scanner.next(results);
                if (results.isEmpty()) {
                    break;
                }
                Cell cell = (Cell)results.get(0);
                int ordinal = Bytes.toInt(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                String label = this.labelsCache.getLabel(ordinal);
                if (label != null) {
                    auths.add(label);
                }
                results.clear();
            }
        }
        return new ArrayList<String>(auths);
    }

    @Override
    public List<String> listLabels(String regex) throws IOException {
        assert (this.labelsRegion != null);
        Pair<Map<String, Integer>, Map<String, List<Integer>>> labelsAndUserAuths = this.extractLabelsAndAuths(this.getExistingLabelsWithAuths());
        Map<String, Integer> labels = labelsAndUserAuths.getFirst();
        labels.remove("system");
        if (regex != null) {
            Pattern pattern = Pattern.compile(regex);
            ArrayList<String> matchedLabels = new ArrayList<String>();
            for (String label : labels.keySet()) {
                if (!pattern.matcher(label).matches()) continue;
                matchedLabels.add(label);
            }
            return matchedLabels;
        }
        return new ArrayList<String>(labels.keySet());
    }

    @Override
    public List<Tag> createVisibilityExpTags(String visExpression, boolean withSerializationFormat, boolean checkAuths) throws IOException {
        HashSet<Integer> auths = new HashSet<Integer>();
        if (checkAuths) {
            User user = VisibilityUtils.getActiveUser();
            auths.addAll(this.labelsCache.getUserAuthsAsOrdinals(user.getShortName()));
            auths.addAll(this.labelsCache.getGroupAuthsAsOrdinals(user.getGroupNames()));
        }
        return VisibilityUtils.createVisibilityExpTags(visExpression, withSerializationFormat, checkAuths, auths, this.labelsCache);
    }

    protected void updateZk(boolean labelAddition) throws IOException {
        Pair<Map<String, Integer>, Map<String, List<Integer>>> labelsAndUserAuths = this.extractLabelsAndAuths(this.getExistingLabelsWithAuths());
        Map<String, Integer> existingLabels = labelsAndUserAuths.getFirst();
        Map<String, List<Integer>> userAuths = labelsAndUserAuths.getSecond();
        if (labelAddition) {
            byte[] serialized = VisibilityUtils.getDataToWriteToZooKeeper(existingLabels);
            this.labelsCache.writeToZookeeper(serialized, true);
        } else {
            byte[] serialized = VisibilityUtils.getUserAuthsDataToWriteToZooKeeper(userAuths);
            this.labelsCache.writeToZookeeper(serialized, false);
        }
    }

    @Override
    public VisibilityExpEvaluator getVisibilityExpEvaluator(Authorizations authorizations) throws IOException {
        if (this.isReadFromSystemAuthUser()) {
            return new VisibilityExpEvaluator(){

                @Override
                public boolean evaluate(Cell cell) throws IOException {
                    return true;
                }
            };
        }
        ArrayList<String> authLabels = null;
        for (ScanLabelGenerator scanLabelGenerator : this.scanLabelGenerators) {
            try {
                authLabels = scanLabelGenerator.getLabels(VisibilityUtils.getActiveUser(), authorizations);
                authLabels = authLabels == null ? new ArrayList<String>() : authLabels;
                authorizations = new Authorizations(authLabels);
            }
            catch (Throwable t) {
                LOG.error(t);
                throw new IOException(t);
            }
        }
        int labelsCount = this.labelsCache.getLabelsCount();
        final BitSet bs = new BitSet(labelsCount + 1);
        if (authLabels != null) {
            for (String authLabel : authLabels) {
                int labelOrdinal = this.labelsCache.getLabelOrdinal(authLabel);
                if (labelOrdinal == 0) continue;
                bs.set(labelOrdinal);
            }
        }
        return new VisibilityExpEvaluator(){

            @Override
            public boolean evaluate(Cell cell) throws IOException {
                boolean visibilityTagPresent = false;
                if (cell.getTagsLength() > 0) {
                    Iterator<Tag> tagsItr = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
                    while (tagsItr.hasNext()) {
                        Pair<Integer, Integer> result;
                        int offset;
                        boolean includeKV = true;
                        Tag tag = tagsItr.next();
                        if (tag.getType() != 2) continue;
                        visibilityTagPresent = true;
                        int endOffset = offset + tag.getTagLength();
                        for (offset = tag.getTagOffset(); offset < endOffset; offset += result.getSecond().intValue()) {
                            result = StreamUtils.readRawVarint32(tag.getBuffer(), offset);
                            int currLabelOrdinal = result.getFirst();
                            if (currLabelOrdinal < 0) {
                                int temp = -currLabelOrdinal;
                                if (!bs.get(temp)) continue;
                                includeKV = false;
                                break;
                            }
                            if (bs.get(currLabelOrdinal)) continue;
                            includeKV = false;
                            break;
                        }
                        if (!includeKV) continue;
                        return true;
                    }
                }
                return !visibilityTagPresent;
            }
        };
    }

    protected boolean isReadFromSystemAuthUser() throws IOException {
        User user = VisibilityUtils.getActiveUser();
        return this.havingSystemAuth(user);
    }

    @Override
    @Deprecated
    public boolean havingSystemAuth(byte[] user) throws IOException {
        if (Superusers.isSuperUser(Bytes.toString(user))) {
            return true;
        }
        List<String> auths = this.getUserAuths(user, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("The auths for user " + Bytes.toString(user) + " are " + auths);
        }
        return auths.contains("system");
    }

    @Override
    public boolean havingSystemAuth(User user) throws IOException {
        if (Superusers.isSuperUser(user)) {
            return true;
        }
        List<String> auths = this.getUserAuths(Bytes.toBytes(user.getShortName()), true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("The auths for user " + user.getShortName() + " are " + auths);
        }
        if (auths.contains("system")) {
            return true;
        }
        auths = this.getGroupAuths(user.getGroupNames(), true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("The auths for groups of user " + user.getShortName() + " are " + auths);
        }
        return auths.contains("system");
    }

    @Override
    public boolean matchVisibility(List<Tag> putVisTags, Byte putTagsFormat, List<Tag> deleteVisTags, Byte deleteTagsFormat) throws IOException {
        if (deleteTagsFormat != null && deleteTagsFormat == 1 && (putTagsFormat == null || putTagsFormat == 1)) {
            if (putVisTags.size() == 0) {
                return false;
            }
            if (putTagsFormat == null) {
                return DefaultVisibilityLabelServiceImpl.matchUnSortedVisibilityTags(putVisTags, deleteVisTags);
            }
            return DefaultVisibilityLabelServiceImpl.matchOrdinalSortedVisibilityTags(putVisTags, deleteVisTags);
        }
        throw new IOException("Unexpected tag format passed for comparison, deleteTagsFormat : " + deleteTagsFormat + ", putTagsFormat : " + putTagsFormat);
    }

    private static boolean matchUnSortedVisibilityTags(List<Tag> putVisTags, List<Tag> deleteVisTags) throws IOException {
        return DefaultVisibilityLabelServiceImpl.compareTagsOrdinals(DefaultVisibilityLabelServiceImpl.sortTagsBasedOnOrdinal(putVisTags), DefaultVisibilityLabelServiceImpl.sortTagsBasedOnOrdinal(deleteVisTags));
    }

    private static boolean matchOrdinalSortedVisibilityTags(List<Tag> putVisTags, List<Tag> deleteVisTags) {
        boolean matchFound = false;
        if (deleteVisTags.size() == putVisTags.size()) {
            for (Tag tag : deleteVisTags) {
                matchFound = false;
                for (Tag givenTag : putVisTags) {
                    if (!Bytes.equals(tag.getBuffer(), tag.getTagOffset(), tag.getTagLength(), givenTag.getBuffer(), givenTag.getTagOffset(), givenTag.getTagLength())) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
        }
        return matchFound;
    }

    private static List<List<Integer>> sortTagsBasedOnOrdinal(List<Tag> tags) throws IOException {
        ArrayList<List<Integer>> fullTagsList = new ArrayList<List<Integer>>();
        for (Tag tag : tags) {
            if (tag.getType() != 2) continue;
            DefaultVisibilityLabelServiceImpl.getSortedTagOrdinals(fullTagsList, tag);
        }
        return fullTagsList;
    }

    private static void getSortedTagOrdinals(List<List<Integer>> fullTagsList, Tag tag) throws IOException {
        Pair<Integer, Integer> result;
        int offset;
        ArrayList<Integer> tagsOrdinalInSortedOrder = new ArrayList<Integer>();
        int endOffset = offset + tag.getTagLength();
        for (offset = tag.getTagOffset(); offset < endOffset; offset += result.getSecond().intValue()) {
            result = StreamUtils.readRawVarint32(tag.getBuffer(), offset);
            tagsOrdinalInSortedOrder.add(result.getFirst());
        }
        Collections.sort(tagsOrdinalInSortedOrder);
        fullTagsList.add(tagsOrdinalInSortedOrder);
    }

    private static boolean compareTagsOrdinals(List<List<Integer>> putVisTags, List<List<Integer>> deleteVisTags) {
        boolean matchFound = false;
        if (deleteVisTags.size() == putVisTags.size()) {
            for (List<Integer> deleteTagOrdinals : deleteVisTags) {
                matchFound = false;
                for (List<Integer> tagOrdinals : putVisTags) {
                    if (!deleteTagOrdinals.equals(tagOrdinals)) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
        }
        return matchFound;
    }

    @Override
    public byte[] encodeVisibilityForReplication(List<Tag> tags, Byte serializationFormat) throws IOException {
        if (tags.size() > 0 && (serializationFormat == null || serializationFormat == 1)) {
            return this.createModifiedVisExpression(tags);
        }
        return null;
    }

    private byte[] createModifiedVisExpression(List<Tag> tags) throws IOException {
        StringBuilder visibilityString = new StringBuilder();
        for (Tag tag : tags) {
            Pair<Integer, Integer> result;
            int offset;
            if (tag.getType() != 2) continue;
            if (visibilityString.length() != 0) {
                visibilityString.append(")").append("|");
            }
            int endOffset = offset + tag.getTagLength();
            boolean expressionStart = true;
            for (offset = tag.getTagOffset(); offset < endOffset; offset += result.getSecond().intValue()) {
                result = StreamUtils.readRawVarint32(tag.getBuffer(), offset);
                int currLabelOrdinal = result.getFirst();
                if (currLabelOrdinal < 0) {
                    int temp = -currLabelOrdinal;
                    String label = this.labelsCache.getLabel(temp);
                    if (expressionStart) {
                        visibilityString.append("(").append("!").append(CellVisibility.quote(label));
                    } else {
                        visibilityString.append("&").append("!").append(CellVisibility.quote(label));
                    }
                } else {
                    String label = this.labelsCache.getLabel(currLabelOrdinal);
                    if (expressionStart) {
                        visibilityString.append("(").append(CellVisibility.quote(label));
                    } else {
                        visibilityString.append("&").append(CellVisibility.quote(label));
                    }
                }
                expressionStart = false;
            }
        }
        if (visibilityString.length() != 0) {
            visibilityString.append(")");
            return Bytes.toBytes(visibilityString.toString());
        }
        return null;
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            StreamUtils.writeRawVInt32(dos, 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultVisibilityLabelServiceImpl.LABELS_TABLE_TAGS[0] = new Tag(2, baos.toByteArray());
    }
}

