/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
public class ScopeWALEntryFilter
implements WALEntryFilter {
    private static final Log LOG = LogFactory.getLog(ScopeWALEntryFilter.class);

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        NavigableMap<byte[], Integer> scopes = entry.getKey().getScopes();
        if (scopes == null || scopes.isEmpty()) {
            return null;
        }
        ArrayList<Cell> cells = entry.getEdit().getCells();
        int size = cells.size();
        for (int i = size - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            if (CellUtil.matchingColumn(cell, WALEdit.METAFAMILY, WALEdit.BULK_LOAD)) {
                Cell filteredBulkLoadEntryCell = this.filterBulkLoadEntries(scopes, cell);
                if (filteredBulkLoadEntryCell != null) {
                    cells.set(i, filteredBulkLoadEntryCell);
                    continue;
                }
                cells.remove(i);
                continue;
            }
            byte[] fam = CellUtil.cloneFamily(cell);
            if (scopes.containsKey(fam) && (Integer)scopes.get(fam) != 0) continue;
            cells.remove(i);
        }
        if (cells.size() < size / 2) {
            cells.trimToSize();
        }
        return entry;
    }

    private Cell filterBulkLoadEntries(NavigableMap<byte[], Integer> scopes, Cell cell) {
        WALProtos.BulkLoadDescriptor bld = null;
        try {
            bld = WALEdit.getBulkLoadDescriptor(cell);
        }
        catch (IOException e) {
            LOG.warn("Failed to get bulk load events information from the WAL file.", e);
            return cell;
        }
        List<WALProtos.StoreDescriptor> storesList = bld.getStoresList();
        ArrayList<WALProtos.StoreDescriptor> copiedStoresList = new ArrayList<WALProtos.StoreDescriptor>(storesList);
        Iterator copiedStoresListIterator = copiedStoresList.iterator();
        boolean anyStoreRemoved = false;
        while (copiedStoresListIterator.hasNext()) {
            WALProtos.StoreDescriptor sd = (WALProtos.StoreDescriptor)copiedStoresListIterator.next();
            byte[] fam = sd.getFamilyName().toByteArray();
            if (scopes.containsKey(fam) && (Integer)scopes.get(fam) != 0) continue;
            copiedStoresListIterator.remove();
            anyStoreRemoved = true;
        }
        if (!anyStoreRemoved) {
            return cell;
        }
        if (copiedStoresList.isEmpty()) {
            return null;
        }
        WALProtos.BulkLoadDescriptor.Builder newDesc = WALProtos.BulkLoadDescriptor.newBuilder().setTableName(bld.getTableName()).setEncodedRegionName(bld.getEncodedRegionName()).setBulkloadSeqNum(bld.getBulkloadSeqNum());
        newDesc.addAllStores(copiedStoresList);
        WALProtos.BulkLoadDescriptor newBulkLoadDescriptor = newDesc.build();
        return CellUtil.createCell(CellUtil.cloneRow(cell), WALEdit.METAFAMILY, WALEdit.BULK_LOAD, cell.getTimestamp(), cell.getTypeByte(), newBulkLoadDescriptor.toByteArray());
    }
}

