/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReader;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;

public class IndexHalfStoreFileReaderGenerator
extends BaseRegionObserver {
    int storeFilesCount = 0;
    int compactedFilesCount = 0;
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreFile.Reader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        TableName tableName = ctx.getEnvironment().getRegion().getTableDesc().getTableName();
        Region region = ctx.getEnvironment().getRegion();
        HRegionInfo childRegion = region.getRegionInfo();
        byte[] splitKey = null;
        if (reader == null && r != null) {
            Object splitRow;
            if (!p.toString().contains("L#")) {
                return super.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
            }
            Scan scan = MetaTableAccessor.getScanForTableName(tableName);
            SingleColumnValueFilter scvf = null;
            if (Reference.isTopFileRegion(r.getFileRegion())) {
                scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, CompareFilter.CompareOp.EQUAL, region.getRegionInfo().toByteArray());
                scvf.setFilterIfMissing(true);
            } else {
                scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, CompareFilter.CompareOp.EQUAL, region.getRegionInfo().toByteArray());
                scvf.setFilterIfMissing(true);
            }
            if (scvf != null) {
                scan.setFilter(scvf);
            }
            byte[] regionStartKeyInHFile = null;
            PhoenixConnection conn = null;
            try (HTable metaTable = null;){
                metaTable = new HTable(ctx.getEnvironment().getConfiguration(), TableName.META_TABLE_NAME);
                Result result = null;
                try (ResultScanner scanner = null;){
                    scanner = metaTable.getScanner(scan);
                    result = scanner.next();
                }
                if (result == null || result.isEmpty()) {
                    Pair<HRegionInfo, HRegionInfo> mergeRegions = MetaTableAccessor.getRegionsFromMergeQualifier(ctx.getEnvironment().getRegionServerServices().getConnection(), region.getRegionInfo().getRegionName());
                    if (mergeRegions == null || mergeRegions.getFirst() == null) {
                        StoreFile.Reader reader2 = reader;
                        return reader2;
                    }
                    splitRow = CellUtil.cloneRow(KeyValue.createKeyValueFromKey(r.getSplitKey()));
                    if (Bytes.compareTo(mergeRegions.getFirst().getStartKey(), (byte[])splitRow) == 0) {
                        StoreFile.Reader reader3 = reader;
                        return reader3;
                    }
                    childRegion = mergeRegions.getSecond();
                    regionStartKeyInHFile = mergeRegions.getSecond().getStartKey();
                    splitKey = KeyValue.createFirstOnRow(region.getRegionInfo().getStartKey().length == 0 ? new byte[region.getRegionInfo().getEndKey().length] : region.getRegionInfo().getStartKey()).getKey();
                } else {
                    HRegionInfo parentRegion = HRegionInfo.getHRegionInfo(result);
                    regionStartKeyInHFile = parentRegion.getStartKey().length == 0 ? new byte[parentRegion.getEndKey().length] : parentRegion.getStartKey();
                }
            }
            try {
                conn = QueryUtil.getConnection(ctx.getEnvironment().getConfiguration()).unwrap(PhoenixConnection.class);
                PTable dataTable = PhoenixRuntime.getTable(conn, tableName.getNameAsString());
                List<PTable> indexes = dataTable.getIndexes();
                HashMap<ImmutableBytesWritable, IndexMaintainer> indexMaintainers = new HashMap<ImmutableBytesWritable, IndexMaintainer>();
                splitRow = indexes.iterator();
                while (splitRow.hasNext()) {
                    PTable index = (PTable)splitRow.next();
                    if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                    IndexMaintainer indexMaintainer = index.getIndexMaintainer(dataTable, conn);
                    indexMaintainers.put(new ImmutableBytesWritable(MetaDataUtil.getViewIndexIdDataType().toBytes(index.getViewIndexId())), indexMaintainer);
                }
                if (indexMaintainers.isEmpty()) {
                    splitRow = reader;
                    return splitRow;
                }
                byte[][] viewConstants = this.getViewConstants(dataTable);
                IndexHalfStoreFileReader indexHalfStoreFileReader = new IndexHalfStoreFileReader(fs, p, cacheConf, in, size, r, ctx.getEnvironment().getConfiguration(), indexMaintainers, viewConstants, childRegion, regionStartKeyInHFile, splitKey);
                return indexHalfStoreFileReader;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
        return reader;
    }

    private byte[][] getViewConstants(PTable dataTable) {
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        Object viewConstants = null;
        int nViewConstants = 0;
        if (dataTable.getType() == PTableType.VIEW) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            List<PColumn> dataPkColumns = dataTable.getPKColumns();
            for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                PColumn dataPKColumn = dataPkColumns.get(i);
                if (dataPKColumn.getViewConstant() == null) continue;
                ++nViewConstants;
            }
            if (nViewConstants > 0) {
                viewConstants = new byte[nViewConstants][];
                int j = 0;
                for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                    PColumn dataPkColumn = dataPkColumns.get(i);
                    if (dataPkColumn.getViewConstant() == null) continue;
                    if (IndexUtil.getViewConstantValue(dataPkColumn, ptr)) {
                        viewConstants[j++] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return viewConstants;
    }
}

