/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.index.IndexMaintainer;

public class IndexHalfStoreFileReader
extends StoreFile.Reader {
    private static final int ROW_KEY_LENGTH = 2;
    private final boolean top;
    private final byte[] splitkey;
    private final byte[] splitRow;
    private final Map<ImmutableBytesWritable, IndexMaintainer> indexMaintainers;
    private final byte[][] viewConstants;
    private final int offset;
    private final HRegionInfo regionInfo;
    private final byte[] regionStartKeyInHFile;

    public IndexHalfStoreFileReader(FileSystem fs, Path p, CacheConfig cacheConf, Reference r, Configuration conf, Map<ImmutableBytesWritable, IndexMaintainer> indexMaintainers, byte[][] viewConstants, HRegionInfo regionInfo, byte[] regionStartKeyInHFile, byte[] splitKey) throws IOException {
        super(fs, p, cacheConf, conf);
        this.splitkey = splitKey == null ? r.getSplitKey() : splitKey;
        this.top = Reference.isTopFileRegion(r.getFileRegion());
        this.splitRow = CellUtil.cloneRow(KeyValue.createKeyValueFromKey(this.splitkey));
        this.indexMaintainers = indexMaintainers;
        this.viewConstants = viewConstants;
        this.regionInfo = regionInfo;
        this.regionStartKeyInHFile = regionStartKeyInHFile;
        this.offset = regionStartKeyInHFile.length;
    }

    public IndexHalfStoreFileReader(FileSystem fs, Path p, CacheConfig cacheConf, FSDataInputStreamWrapper in, long size, Reference r, Configuration conf, Map<ImmutableBytesWritable, IndexMaintainer> indexMaintainers, byte[][] viewConstants, HRegionInfo regionInfo, byte[] regionStartKeyInHFile, byte[] splitKey) throws IOException {
        super(fs, p, in, size, cacheConf, conf);
        this.splitkey = splitKey == null ? r.getSplitKey() : splitKey;
        this.top = Reference.isTopFileRegion(r.getFileRegion());
        this.splitRow = CellUtil.cloneRow(KeyValue.createKeyValueFromKey(this.splitkey));
        this.indexMaintainers = indexMaintainers;
        this.viewConstants = viewConstants;
        this.regionInfo = regionInfo;
        this.regionStartKeyInHFile = regionStartKeyInHFile;
        this.offset = regionStartKeyInHFile.length;
    }

    protected boolean isTop() {
        return this.top;
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        final HFileScanner s = super.getScanner(cacheBlocks, pread, isCompaction);
        return new HFileScanner(){
            final HFileScanner delegate;
            public boolean atEnd;
            {
                this.delegate = s;
                this.atEnd = false;
            }

            @Override
            public ByteBuffer getKey() {
                boolean changeBottomKeys;
                if (this.atEnd) {
                    return null;
                }
                boolean bl = changeBottomKeys = IndexHalfStoreFileReader.this.regionInfo.getStartKey().length == 0 && IndexHalfStoreFileReader.this.splitRow.length != IndexHalfStoreFileReader.this.offset;
                if (!IndexHalfStoreFileReader.this.top && !changeBottomKeys) {
                    return this.delegate.getKey();
                }
                return this.getChangedKey(this.delegate.getKeyValue(), changeBottomKeys);
            }

            private ByteBuffer getChangedKey(Cell kv, boolean changeBottomKeys) {
                byte[] newRowkey = this.getNewRowkeyByRegionStartKeyReplacedWithSplitKey(kv, changeBottomKeys);
                KeyValue newKv = new KeyValue(newRowkey, 0, newRowkey.length, kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType(kv.getTypeByte()), null, 0, 0);
                ByteBuffer keyBuffer = ByteBuffer.wrap(newKv.getKey());
                return keyBuffer;
            }

            private byte[] getNewRowkeyByRegionStartKeyReplacedWithSplitKey(Cell kv, boolean changeBottomKeys) {
                int lenOfRemainingKey = kv.getRowLength() - IndexHalfStoreFileReader.this.offset;
                byte[] keyReplacedStartKey = new byte[lenOfRemainingKey + IndexHalfStoreFileReader.this.splitRow.length];
                System.arraycopy(changeBottomKeys ? new byte[IndexHalfStoreFileReader.this.splitRow.length] : IndexHalfStoreFileReader.this.splitRow, 0, keyReplacedStartKey, 0, IndexHalfStoreFileReader.this.splitRow.length);
                System.arraycopy(kv.getRowArray(), kv.getRowOffset() + IndexHalfStoreFileReader.this.offset, keyReplacedStartKey, IndexHalfStoreFileReader.this.splitRow.length, lenOfRemainingKey);
                return keyReplacedStartKey;
            }

            @Override
            public String getKeyString() {
                if (this.atEnd) {
                    return null;
                }
                return Bytes.toStringBinary(this.getKey());
            }

            @Override
            public ByteBuffer getValue() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getValue();
            }

            @Override
            public String getValueString() {
                if (this.atEnd) {
                    return null;
                }
                return Bytes.toStringBinary(this.getValue());
            }

            @Override
            public Cell getKeyValue() {
                boolean changeBottomKeys;
                if (this.atEnd) {
                    return null;
                }
                Cell kv = this.delegate.getKeyValue();
                boolean bl = changeBottomKeys = IndexHalfStoreFileReader.this.regionInfo.getStartKey().length == 0 && IndexHalfStoreFileReader.this.splitRow.length != IndexHalfStoreFileReader.this.offset;
                if (!IndexHalfStoreFileReader.this.top && !changeBottomKeys) {
                    return kv;
                }
                byte[] changedKey = this.getNewRowkeyByRegionStartKeyReplacedWithSplitKey(kv, changeBottomKeys);
                KeyValue changedKv = new KeyValue(changedKey, 0, changedKey.length, kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType(kv.getTypeByte()), kv.getValueArray(), kv.getValueOffset(), kv.getValueLength(), kv.getTagsArray(), kv.getTagsOffset(), kv.getTagsLength());
                return changedKv;
            }

            @Override
            public boolean next() throws IOException {
                if (this.atEnd) {
                    return false;
                }
                do {
                    boolean b;
                    if (b = this.delegate.next()) continue;
                    this.atEnd = true;
                    return b;
                } while (!IndexHalfStoreFileReader.this.isSatisfiedMidKeyCondition(this.delegate.getKeyValue()));
                return true;
            }

            @Override
            public boolean seekBefore(byte[] key) throws IOException {
                return this.seekBefore(key, 0, key.length);
            }

            @Override
            public boolean seekBefore(byte[] key, int offset, int length) throws IOException {
                if (IndexHalfStoreFileReader.this.top) {
                    byte[] fk = IndexHalfStoreFileReader.this.getFirstKey();
                    if (fk == null) {
                        return false;
                    }
                    if (IndexHalfStoreFileReader.this.getComparator().compare(key, offset, length, fk, 0, fk.length) <= 0) {
                        return false;
                    }
                    KeyValue replacedKey = IndexHalfStoreFileReader.this.getKeyPresentInHFiles(key);
                    return this.delegate.seekBefore(replacedKey);
                }
                if (IndexHalfStoreFileReader.this.getComparator().compare(key, offset, length, IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length) >= 0) {
                    return this.delegate.seekBefore(IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length);
                }
                return this.delegate.seekBefore(key, offset, length);
            }

            @Override
            public boolean seekBefore(Cell cell) throws IOException {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                return this.seekBefore(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
            }

            @Override
            public boolean seekTo() throws IOException {
                boolean b = this.delegate.seekTo();
                if (!b) {
                    this.atEnd = true;
                    return b;
                }
                do {
                    if (!IndexHalfStoreFileReader.this.isSatisfiedMidKeyCondition(this.delegate.getKeyValue())) continue;
                    return true;
                } while (b = this.delegate.next());
                return b;
            }

            @Override
            public int seekTo(byte[] key) throws IOException {
                return this.seekTo(key, 0, key.length);
            }

            @Override
            public int seekTo(byte[] key, int offset, int length) throws IOException {
                if (IndexHalfStoreFileReader.this.top) {
                    if (IndexHalfStoreFileReader.this.getComparator().compare(key, offset, length, IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length) < 0) {
                        return -1;
                    }
                    KeyValue replacedKey = IndexHalfStoreFileReader.this.getKeyPresentInHFiles(key);
                    int seekTo = this.delegate.seekTo(replacedKey.getBuffer(), replacedKey.getKeyOffset(), replacedKey.getKeyLength());
                    return seekTo;
                }
                if (IndexHalfStoreFileReader.this.getComparator().compare(key, offset, length, IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length) >= 0) {
                    boolean res = this.delegate.seekBefore(IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length);
                    if (!res) {
                        throw new IOException("Seeking for a key in bottom of file, but key exists in top of file, failed on seekBefore(midkey)");
                    }
                    return 1;
                }
                return this.delegate.seekTo(key, offset, length);
            }

            @Override
            public int seekTo(Cell cell) throws IOException {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                return this.seekTo(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
            }

            @Override
            public int reseekTo(byte[] key) throws IOException {
                return this.reseekTo(key, 0, key.length);
            }

            @Override
            public int reseekTo(byte[] key, int offset, int length) throws IOException {
                if (IndexHalfStoreFileReader.this.top) {
                    if (IndexHalfStoreFileReader.this.getComparator().compare(key, offset, length, IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length) < 0) {
                        return -1;
                    }
                    KeyValue replacedKey = IndexHalfStoreFileReader.this.getKeyPresentInHFiles(key);
                    return this.delegate.reseekTo(replacedKey.getBuffer(), replacedKey.getKeyOffset(), replacedKey.getKeyLength());
                }
                if (IndexHalfStoreFileReader.this.getComparator().compare(key, offset, length, IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length) >= 0) {
                    boolean res = this.delegate.seekBefore(IndexHalfStoreFileReader.this.splitkey, 0, IndexHalfStoreFileReader.this.splitkey.length);
                    if (!res) {
                        throw new IOException("Seeking for a key in bottom of file, but key exists in top of file, failed on seekBefore(midkey)");
                    }
                    return 1;
                }
                KeyValue replacedKey = IndexHalfStoreFileReader.this.getKeyPresentInHFiles(key);
                return this.delegate.reseekTo(replacedKey.getBuffer(), replacedKey.getKeyOffset(), replacedKey.getKeyLength());
            }

            @Override
            public int reseekTo(Cell cell) throws IOException {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                return this.reseekTo(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
            }

            @Override
            public HFile.Reader getReader() {
                return this.delegate.getReader();
            }

            @Override
            public boolean isSeeked() {
                return this.delegate.isSeeked();
            }

            @Override
            public Cell getNextIndexedKey() {
                return null;
            }
        };
    }

    private boolean isSatisfiedMidKeyCondition(Cell kv) {
        if (CellUtil.isDelete(kv) && kv.getValueLength() == 0) {
            return true;
        }
        ImmutableBytesWritable rowKey = new ImmutableBytesWritable(kv.getRowArray(), kv.getRowOffset() + this.offset, kv.getRowLength() - this.offset);
        Map.Entry<ImmutableBytesWritable, IndexMaintainer> entry = this.indexMaintainers.entrySet().iterator().next();
        IndexMaintainer indexMaintainer = entry.getValue();
        byte[] viewIndexId = indexMaintainer.getViewIndexIdFromIndexRowKey(rowKey);
        IndexMaintainer actualIndexMaintainer = this.indexMaintainers.get(new ImmutableBytesWritable(viewIndexId));
        byte[] dataRowKey = actualIndexMaintainer.buildDataRowKey(rowKey, this.viewConstants);
        int compareResult = Bytes.compareTo(dataRowKey, this.splitRow);
        return this.top ? compareResult >= 0 : compareResult < 0;
    }

    private KeyValue getKeyPresentInHFiles(byte[] key) {
        int daughterStartKeyLength;
        KeyValue keyValue = new KeyValue(key);
        short rowLength = keyValue.getRowLength();
        int rowOffset = keyValue.getRowOffset();
        int n = daughterStartKeyLength = this.regionInfo.getStartKey().length == 0 ? this.regionInfo.getEndKey().length : this.regionInfo.getStartKey().length;
        if (this.top && 0 == keyValue.getValueLength() && keyValue.getTimestamp() == Long.MAX_VALUE && Bytes.compareTo(keyValue.getRowArray(), keyValue.getRowOffset(), keyValue.getRowLength(), this.splitRow, 0, this.splitRow.length) == 0 && CellUtil.isDeleteFamily(keyValue)) {
            KeyValue createFirstDeleteFamilyOnRow = KeyValueUtil.createFirstDeleteFamilyOnRow(this.regionStartKeyInHFile, keyValue.getFamily());
            return createFirstDeleteFamilyOnRow;
        }
        short length = (short)(keyValue.getRowLength() - daughterStartKeyLength + this.offset);
        byte[] replacedKey = new byte[length + key.length - (rowOffset + rowLength) + 2];
        System.arraycopy(Bytes.toBytes(length), 0, replacedKey, 0, 2);
        System.arraycopy(this.regionStartKeyInHFile, 0, replacedKey, 2, this.offset);
        System.arraycopy(keyValue.getRowArray(), keyValue.getRowOffset() + daughterStartKeyLength, replacedKey, this.offset + 2, keyValue.getRowLength() - daughterStartKeyLength);
        System.arraycopy(key, rowOffset + rowLength, replacedKey, this.offset + keyValue.getRowLength() - daughterStartKeyLength + 2, key.length - (rowOffset + rowLength));
        return KeyValue.createKeyValueFromKey(replacedKey);
    }

    @Override
    public byte[] getLastKey() {
        throw new UnsupportedOperationException("Method is not implemented!");
    }

    @Override
    public byte[] midkey() throws IOException {
        return null;
    }

    @Override
    public byte[] getFirstKey() {
        return super.getFirstKey();
    }

    @Override
    public boolean passesKeyRangeFilter(Scan scan) {
        return true;
    }
}

