/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;

@InterfaceAudience.Private
public class IncreasingToUpperBoundRegionSplitPolicy
extends ConstantSizeRegionSplitPolicy {
    static final Log LOG = LogFactory.getLog(IncreasingToUpperBoundRegionSplitPolicy.class);
    private long initialSize;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        Configuration conf = this.getConf();
        this.initialSize = conf.getLong("hbase.increasing.policy.initial.size", -1L);
        if (this.initialSize > 0L) {
            return;
        }
        HTableDescriptor desc = region.getTableDesc();
        if (desc != null) {
            this.initialSize = 2L * desc.getMemStoreFlushSize();
        }
        if (this.initialSize <= 0L) {
            this.initialSize = 2L * conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
    }

    @Override
    protected boolean shouldSplit() {
        boolean force = this.region.shouldForceSplit();
        boolean foundABigStore = false;
        int tableRegionsCount = this.getCountOfCommonTableRegions();
        long sizeToCheck = this.getSizeToCheck(tableRegionsCount);
        for (Store store : this.region.getStores()) {
            if (!store.canSplit()) {
                return false;
            }
            long size = store.getSize();
            if (size <= sizeToCheck) continue;
            LOG.debug("ShouldSplit because " + store.getColumnFamilyName() + " size=" + size + ", sizeToCheck=" + sizeToCheck + ", regionsWithCommonTable=" + tableRegionsCount);
            foundABigStore = true;
        }
        return foundABigStore | force;
    }

    protected long getSizeToCheck(int tableRegionsCount) {
        return tableRegionsCount == 0 || tableRegionsCount > 100 ? this.getDesiredMaxFileSize() : Math.min(this.getDesiredMaxFileSize(), this.initialSize * (long)tableRegionsCount * (long)tableRegionsCount * (long)tableRegionsCount);
    }

    private int getCountOfCommonTableRegions() {
        RegionServerServices rss = this.region.getRegionServerServices();
        if (rss == null) {
            return 0;
        }
        TableName tablename = this.region.getTableDesc().getTableName();
        int tableRegionsCount = 0;
        try {
            List<Region> hri = rss.getOnlineRegions(tablename);
            tableRegionsCount = hri == null || hri.isEmpty() ? 0 : hri.size();
        }
        catch (IOException e) {
            LOG.debug("Failed getOnlineRegions " + tablename, e);
        }
        return tableRegionsCount;
    }
}

