/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ExplicitColumnTracker
implements ColumnTracker {
    private final int maxVersions;
    private final int minVersions;
    private final ColumnCount[] columns;
    private int index;
    private ColumnCount column;
    private long latestTSOfCurrentColumn;
    private long oldestStamp;

    public ExplicitColumnTracker(NavigableSet<byte[]> columns, int minVersions, int maxVersions, long oldestUnexpiredTS) {
        this.maxVersions = maxVersions;
        this.minVersions = minVersions;
        this.oldestStamp = oldestUnexpiredTS;
        this.columns = new ColumnCount[columns.size()];
        int i = 0;
        for (byte[] column : columns) {
            this.columns[i++] = new ColumnCount(column);
        }
        this.reset();
    }

    @Override
    public boolean done() {
        return this.index >= this.columns.length;
    }

    @Override
    public ColumnCount getColumnHint() {
        return this.column;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length, byte type) {
        assert (!CellUtil.isDelete(type));
        while (!this.done()) {
            if (this.column == null) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
            }
            int ret = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), bytes, offset, length);
            if (ret == 0) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            this.resetTS();
            if (ret > 0) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
            if (ret > -1) continue;
            ++this.index;
            if (this.done()) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
            }
            this.column = this.columns[this.index];
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkVersions(byte[] bytes, int offset, int length, long timestamp, byte type, boolean ignoreCount) throws IOException {
        assert (!CellUtil.isDelete(type));
        if (ignoreCount) {
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        if (this.sameAsPreviousTS(timestamp)) {
            return ScanQueryMatcher.MatchCode.SKIP;
        }
        int count = this.column.increment();
        if (count >= this.maxVersions || count >= this.minVersions && this.isExpired(timestamp)) {
            ++this.index;
            this.resetTS();
            if (this.done()) {
                this.column = null;
                return ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW;
            }
            this.column = this.columns[this.index];
            return ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL;
        }
        this.setTS(timestamp);
        return ScanQueryMatcher.MatchCode.INCLUDE;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.column = this.columns[this.index];
        for (ColumnCount col : this.columns) {
            col.setCount(0);
        }
        this.resetTS();
    }

    private void resetTS() {
        this.latestTSOfCurrentColumn = Long.MAX_VALUE;
    }

    private void setTS(long timestamp) {
        this.latestTSOfCurrentColumn = timestamp;
    }

    private boolean sameAsPreviousTS(long timestamp) {
        return timestamp == this.latestTSOfCurrentColumn;
    }

    private boolean isExpired(long timestamp) {
        return timestamp < this.oldestStamp;
    }

    public void doneWithColumn(byte[] bytes, int offset, int length) {
        while (this.column != null) {
            int compare = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), bytes, offset, length);
            this.resetTS();
            if (compare <= 0) {
                ++this.index;
                this.column = this.done() ? null : this.columns[this.index];
                if (compare <= -1) continue;
            }
            return;
        }
    }

    @Override
    public ScanQueryMatcher.MatchCode getNextRowOrNextColumn(byte[] bytes, int offset, int qualLength) {
        this.doneWithColumn(bytes, offset, qualLength);
        if (this.getColumnHint() == null) {
            return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public boolean isDone(long timestamp) {
        return this.minVersions <= 0 && this.isExpired(timestamp);
    }
}

