/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.HeapMemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.HeapMemoryTuner;

@InterfaceAudience.Private
class DefaultHeapMemoryTuner
implements HeapMemoryTuner {
    public static final String STEP_KEY = "hbase.regionserver.heapmemory.autotuner.step";
    public static final float DEFAULT_STEP_VALUE = 0.02f;
    private static final HeapMemoryManager.TunerResult TUNER_RESULT = new HeapMemoryManager.TunerResult(true);
    private static final HeapMemoryManager.TunerResult NO_OP_TUNER_RESULT = new HeapMemoryManager.TunerResult(false);
    private Configuration conf;
    private float step = 0.02f;
    private float globalMemStorePercentMinRange;
    private float globalMemStorePercentMaxRange;
    private float blockCachePercentMinRange;
    private float blockCachePercentMaxRange;

    DefaultHeapMemoryTuner() {
    }

    @Override
    public HeapMemoryManager.TunerResult tune(HeapMemoryManager.TunerContext context) {
        float newMemstoreSize;
        float newBlockCacheSize;
        boolean blockCacheSufficient;
        long blockedFlushCount = context.getBlockedFlushCount();
        long unblockedFlushCount = context.getUnblockedFlushCount();
        long evictCount = context.getEvictCount();
        boolean memstoreSufficient = blockedFlushCount == 0L && unblockedFlushCount == 0L;
        boolean bl = blockCacheSufficient = evictCount == 0L;
        if (memstoreSufficient && blockCacheSufficient) {
            return NO_OP_TUNER_RESULT;
        }
        if (memstoreSufficient) {
            newBlockCacheSize = context.getCurBlockCacheSize() + this.step;
            newMemstoreSize = context.getCurMemStoreSize() - this.step;
        } else if (blockCacheSufficient) {
            newBlockCacheSize = context.getCurBlockCacheSize() - this.step;
            newMemstoreSize = context.getCurMemStoreSize() + this.step;
        } else {
            return NO_OP_TUNER_RESULT;
        }
        if (newMemstoreSize > this.globalMemStorePercentMaxRange) {
            newMemstoreSize = this.globalMemStorePercentMaxRange;
        } else if (newMemstoreSize < this.globalMemStorePercentMinRange) {
            newMemstoreSize = this.globalMemStorePercentMinRange;
        }
        if (newBlockCacheSize > this.blockCachePercentMaxRange) {
            newBlockCacheSize = this.blockCachePercentMaxRange;
        } else if (newBlockCacheSize < this.blockCachePercentMinRange) {
            newBlockCacheSize = this.blockCachePercentMinRange;
        }
        TUNER_RESULT.setBlockCacheSize(newBlockCacheSize);
        TUNER_RESULT.setMemstoreSize(newMemstoreSize);
        return TUNER_RESULT;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.step = conf.getFloat(STEP_KEY, 0.02f);
        this.blockCachePercentMinRange = conf.getFloat("hfile.block.cache.size.min.range", conf.getFloat("hfile.block.cache.size", 0.4f));
        this.blockCachePercentMaxRange = conf.getFloat("hfile.block.cache.size.max.range", conf.getFloat("hfile.block.cache.size", 0.4f));
        this.globalMemStorePercentMinRange = conf.getFloat("hbase.regionserver.global.memstore.size.min.range", HeapMemorySizeUtil.getGlobalMemStorePercent(conf, false));
        this.globalMemStorePercentMaxRange = conf.getFloat("hbase.regionserver.global.memstore.size.max.range", HeapMemorySizeUtil.getGlobalMemStorePercent(conf, false));
    }
}

