/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.ProcedureException;
import org.apache.hadoop.hbase.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RemoteProcedureException
extends ProcedureException {
    private final String source;

    public RemoteProcedureException(String source, Throwable cause) {
        super(cause);
        assert (source != null);
        assert (cause != null);
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public IOException unwrapRemoteException() {
        if (this.getCause() instanceof RemoteException) {
            return ((RemoteException)this.getCause()).unwrapRemoteException();
        }
        if (this.getCause() instanceof IOException) {
            return (IOException)this.getCause();
        }
        return new IOException(this.getCause());
    }

    @Override
    public String toString() {
        String className = this.getCause().getClass().getName();
        return className + " via " + this.getSource() + ":" + this.getLocalizedMessage();
    }

    public static byte[] serialize(String source, Throwable t) {
        return RemoteProcedureException.toProto(source, t).toByteArray();
    }

    public static RemoteProcedureException deserialize(byte[] bytes) throws InvalidProtocolBufferException {
        return RemoteProcedureException.fromProto(ErrorHandlingProtos.ForeignExceptionMessage.parseFrom(bytes));
    }

    public ErrorHandlingProtos.ForeignExceptionMessage convert() {
        return ForeignExceptionUtil.toProtoForeignException(this.getSource(), this.getCause());
    }

    public static ErrorHandlingProtos.ForeignExceptionMessage toProto(String source, Throwable t) {
        return ForeignExceptionUtil.toProtoForeignException(source, t);
    }

    public static RemoteProcedureException fromProto(ErrorHandlingProtos.ForeignExceptionMessage eem) {
        return new RemoteProcedureException(eem.getSource(), ForeignExceptionUtil.toIOException(eem));
    }
}

