/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.HMaster;

@InterfaceAudience.Private
public class RegionNormalizerChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(RegionNormalizerChore.class);
    private final HMaster master;

    public RegionNormalizerChore(HMaster master) {
        super(master.getServerName() + "-RegionNormalizerChore", master, master.getConfiguration().getInt("hbase.normalizer.period", 1800000));
        this.master = master;
    }

    @Override
    protected void chore() {
        try {
            this.master.normalizeRegions();
        }
        catch (IOException | CoordinatedStateException e) {
            LOG.error("Failed to normalize regions.", e);
        }
    }
}

