/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class StochasticLoadBalancer
extends BaseLoadBalancer {
    protected static final String STEPS_PER_REGION_KEY = "hbase.master.balancer.stochastic.stepsPerRegion";
    protected static final String MAX_STEPS_KEY = "hbase.master.balancer.stochastic.maxSteps";
    protected static final String MAX_RUNNING_TIME_KEY = "hbase.master.balancer.stochastic.maxRunningTime";
    protected static final String KEEP_REGION_LOADS = "hbase.master.balancer.stochastic.numRegionLoadsToRemember";
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final Log LOG = LogFactory.getLog(StochasticLoadBalancer.class);
    Map<String, Deque<RegionLoad>> loads = new HashMap<String, Deque<RegionLoad>>();
    private int maxSteps = 1000000;
    private int stepsPerRegion = 800;
    private long maxRunningTime = 30000L;
    private int numRegionLoadsToRemember = 15;
    private CandidateGenerator[] candidateGenerators;
    private CostFromRegionLoadFunction[] regionLoadFunctions;
    private CostFunction[] costFunctions;
    private LocalityBasedCandidateGenerator localityCandidateGenerator;
    private LocalityCostFunction localityCost;
    private RegionReplicaHostCostFunction regionReplicaHostCostFunction;
    private RegionReplicaRackCostFunction regionReplicaRackCostFunction;

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.setConf(conf);
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        super.setConf(conf);
        LOG.info("loading config");
        this.maxSteps = conf.getInt(MAX_STEPS_KEY, this.maxSteps);
        this.stepsPerRegion = conf.getInt(STEPS_PER_REGION_KEY, this.stepsPerRegion);
        this.maxRunningTime = conf.getLong(MAX_RUNNING_TIME_KEY, this.maxRunningTime);
        this.numRegionLoadsToRemember = conf.getInt(KEEP_REGION_LOADS, this.numRegionLoadsToRemember);
        if (this.localityCandidateGenerator == null) {
            this.localityCandidateGenerator = new LocalityBasedCandidateGenerator(this.services);
        }
        this.localityCost = new LocalityCostFunction(conf, this.services);
        if (this.candidateGenerators == null) {
            this.candidateGenerators = new CandidateGenerator[]{new RandomCandidateGenerator(), new LoadCandidateGenerator(), this.localityCandidateGenerator, new RegionReplicaRackCandidateGenerator()};
        }
        this.regionLoadFunctions = new CostFromRegionLoadFunction[]{new ReadRequestCostFunction(conf), new WriteRequestCostFunction(conf), new MemstoreSizeCostFunction(conf), new StoreFileCostFunction(conf)};
        this.regionReplicaHostCostFunction = new RegionReplicaHostCostFunction(conf);
        this.regionReplicaRackCostFunction = new RegionReplicaRackCostFunction(conf);
        this.costFunctions = new CostFunction[]{new RegionCountSkewCostFunction(conf), new MoveCostFunction(conf), this.localityCost, new TableSkewCostFunction(conf), this.regionReplicaHostCostFunction, this.regionReplicaRackCostFunction, this.regionLoadFunctions[0], this.regionLoadFunctions[1], this.regionLoadFunctions[2], this.regionLoadFunctions[3]};
    }

    @Override
    protected void setSlop(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", 0.001f);
    }

    @Override
    public synchronized void setClusterStatus(ClusterStatus st) {
        super.setClusterStatus(st);
        this.updateRegionLoad();
        for (CostFromRegionLoadFunction cost : this.regionLoadFunctions) {
            cost.setClusterStatus(st);
        }
    }

    @Override
    public synchronized void setMasterServices(MasterServices masterServices) {
        super.setMasterServices(masterServices);
        this.localityCost.setServices(masterServices);
        this.localityCandidateGenerator.setServices(masterServices);
    }

    @Override
    protected synchronized boolean areSomeRegionReplicasColocated(BaseLoadBalancer.Cluster c) {
        this.regionReplicaHostCostFunction.init(c);
        if (this.regionReplicaHostCostFunction.cost() > 0.0) {
            return true;
        }
        this.regionReplicaRackCostFunction.init(c);
        return this.regionReplicaRackCostFunction.cost() > 0.0;
    }

    @Override
    public synchronized List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
        long step;
        double currentCost;
        BaseLoadBalancer.Cluster cluster;
        List<RegionPlan> plans = this.balanceMasterRegions(clusterState);
        if (plans != null || clusterState == null || clusterState.size() <= 1) {
            return plans;
        }
        if (this.masterServerName != null && clusterState.containsKey(this.masterServerName)) {
            if (clusterState.size() <= 2) {
                return null;
            }
            clusterState = new HashMap<ServerName, List<HRegionInfo>>(clusterState);
            clusterState.remove(this.masterServerName);
        }
        RegionLocationFinder finder = null;
        if (this.localityCost != null && this.localityCost.getMultiplier() > 0.0f) {
            finder = this.regionFinder;
        }
        if (!this.needsBalance(cluster = new BaseLoadBalancer.Cluster(clusterState, this.loads, finder, this.rackManager))) {
            return null;
        }
        long startTime = EnvironmentEdgeManager.currentTime();
        this.initCosts(cluster);
        double initCost = currentCost = this.computeCost(cluster, Double.MAX_VALUE);
        double newCost = currentCost;
        long computedMaxSteps = Math.min((long)this.maxSteps, (long)cluster.numRegions * (long)this.stepsPerRegion * (long)cluster.numServers);
        for (step = 0L; step < computedMaxSteps; ++step) {
            int generatorIdx = RANDOM.nextInt(this.candidateGenerators.length);
            CandidateGenerator p = this.candidateGenerators[generatorIdx];
            BaseLoadBalancer.Cluster.Action action = p.generate(cluster);
            if (action.type == BaseLoadBalancer.Cluster.Action.Type.NULL) continue;
            cluster.doAction(action);
            this.updateCostsWithAction(cluster, action);
            newCost = this.computeCost(cluster, currentCost);
            if (newCost < currentCost) {
                currentCost = newCost;
            } else {
                BaseLoadBalancer.Cluster.Action undoAction = action.undoAction();
                cluster.doAction(undoAction);
                this.updateCostsWithAction(cluster, undoAction);
            }
            if (EnvironmentEdgeManager.currentTime() - startTime > this.maxRunningTime) break;
        }
        long endTime = EnvironmentEdgeManager.currentTime();
        this.metricsBalancer.balanceCluster(endTime - startTime);
        if (initCost > currentCost) {
            plans = this.createRegionPlans(cluster);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished computing new load balance plan.  Computation took " + (endTime - startTime) + "ms to try " + step + " different iterations.  Found a solution that moves " + plans.size() + " regions; Going from a computed cost of " + initCost + " to a new cost of " + currentCost);
            }
            return plans;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not find a better load balance plan.  Tried " + step + " different configurations in " + (endTime - startTime) + "ms, and did not find anything with a computed cost less than " + initCost);
        }
        return null;
    }

    private List<RegionPlan> createRegionPlans(BaseLoadBalancer.Cluster cluster) {
        LinkedList<RegionPlan> plans = new LinkedList<RegionPlan>();
        for (int regionIndex = 0; regionIndex < cluster.regionIndexToServerIndex.length; ++regionIndex) {
            int initialServerIndex = cluster.initialRegionIndexToServerIndex[regionIndex];
            int newServerIndex = cluster.regionIndexToServerIndex[regionIndex];
            if (initialServerIndex == newServerIndex) continue;
            HRegionInfo region = cluster.regions[regionIndex];
            ServerName initialServer = cluster.servers[initialServerIndex];
            ServerName newServer = cluster.servers[newServerIndex];
            if (LOG.isTraceEnabled()) {
                LOG.trace("Moving Region " + region.getEncodedName() + " from server " + initialServer.getHostname() + " to " + newServer.getHostname());
            }
            RegionPlan rp = new RegionPlan(region, initialServer, newServer);
            plans.add(rp);
        }
        return plans;
    }

    private synchronized void updateRegionLoad() {
        Map<String, Deque<RegionLoad>> oldLoads = this.loads;
        this.loads = new HashMap<String, Deque<RegionLoad>>();
        for (ServerName sn : this.clusterStatus.getServers()) {
            ServerLoad sl = this.clusterStatus.getLoad(sn);
            if (sl == null) continue;
            for (Map.Entry<byte[], RegionLoad> entry : sl.getRegionsLoad().entrySet()) {
                Deque<RegionLoad> rLoads = oldLoads.get(Bytes.toString(entry.getKey()));
                if (rLoads == null) {
                    rLoads = new ArrayDeque<RegionLoad>();
                } else if (rLoads.size() >= this.numRegionLoadsToRemember) {
                    rLoads.remove();
                }
                rLoads.add(entry.getValue());
                this.loads.put(Bytes.toString(entry.getKey()), rLoads);
            }
        }
        for (CostFromRegionLoadFunction cost : this.regionLoadFunctions) {
            cost.setLoads(this.loads);
        }
    }

    protected void initCosts(BaseLoadBalancer.Cluster cluster) {
        for (CostFunction c : this.costFunctions) {
            c.init(cluster);
        }
    }

    protected void updateCostsWithAction(BaseLoadBalancer.Cluster cluster, BaseLoadBalancer.Cluster.Action action) {
        for (CostFunction c : this.costFunctions) {
            c.postAction(action);
        }
    }

    protected double computeCost(BaseLoadBalancer.Cluster cluster, double previousCost) {
        double total = 0.0;
        for (CostFunction c : this.costFunctions) {
            if (c.getMultiplier() <= 0.0f || !((total += (double)c.getMultiplier() * c.cost()) > previousCost)) continue;
            return total;
        }
        return total;
    }

    static class StoreFileCostFunction
    extends CostFromRegionLoadFunction {
        private static final String STOREFILE_SIZE_COST_KEY = "hbase.master.balancer.stochastic.storefileSizeCost";
        private static final float DEFAULT_STOREFILE_SIZE_COST = 5.0f;

        StoreFileCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(STOREFILE_SIZE_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getStorefileSizeMB();
        }
    }

    static class MemstoreSizeCostFunction
    extends CostFromRegionLoadFunction {
        private static final String MEMSTORE_SIZE_COST_KEY = "hbase.master.balancer.stochastic.memstoreSizeCost";
        private static final float DEFAULT_MEMSTORE_SIZE_COST = 5.0f;

        MemstoreSizeCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(MEMSTORE_SIZE_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getMemStoreSizeMB();
        }
    }

    static class RegionReplicaRackCostFunction
    extends RegionReplicaHostCostFunction {
        private static final String REGION_REPLICA_RACK_COST_KEY = "hbase.master.balancer.stochastic.regionReplicaRackCostKey";
        private static final float DEFAULT_REGION_REPLICA_RACK_COST_KEY = 10000.0f;

        public RegionReplicaRackCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(REGION_REPLICA_RACK_COST_KEY, 10000.0f));
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            this.cluster = cluster;
            if (cluster.numRacks <= 1) {
                this.maxCost = 0L;
                return;
            }
            this.maxCost = this.getMaxCost(cluster);
            this.costsPerGroup = new long[cluster.numRacks];
            for (int i = 0; i < cluster.primariesOfRegionsPerRack.length; ++i) {
                this.costsPerGroup[i] = this.costPerGroup(cluster.primariesOfRegionsPerRack[i]);
            }
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            if (this.maxCost <= 0L) {
                return;
            }
            int newRack = this.cluster.serverIndexToRackIndex[newServer];
            int oldRack = this.cluster.serverIndexToRackIndex[oldServer];
            if (newRack != oldRack) {
                this.costsPerGroup[oldRack] = this.costPerGroup(this.cluster.primariesOfRegionsPerRack[oldRack]);
                this.costsPerGroup[newRack] = this.costPerGroup(this.cluster.primariesOfRegionsPerRack[newRack]);
            }
        }
    }

    static class RegionReplicaHostCostFunction
    extends CostFunction {
        private static final String REGION_REPLICA_HOST_COST_KEY = "hbase.master.balancer.stochastic.regionReplicaHostCostKey";
        private static final float DEFAULT_REGION_REPLICA_HOST_COST_KEY = 100000.0f;
        long maxCost = 0L;
        long[] costsPerGroup;
        int[][] primariesOfRegionsPerGroup;

        public RegionReplicaHostCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(REGION_REPLICA_HOST_COST_KEY, 100000.0f));
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            this.maxCost = cluster.numHosts > 1 ? this.getMaxCost(cluster) : 0L;
            this.costsPerGroup = new long[cluster.numHosts];
            this.primariesOfRegionsPerGroup = cluster.multiServersPerHost ? cluster.primariesOfRegionsPerHost : cluster.primariesOfRegionsPerServer;
            for (int i = 0; i < this.primariesOfRegionsPerGroup.length; ++i) {
                this.costsPerGroup[i] = this.costPerGroup(this.primariesOfRegionsPerGroup[i]);
            }
        }

        long getMaxCost(BaseLoadBalancer.Cluster cluster) {
            if (!cluster.hasRegionReplicas) {
                return 0L;
            }
            int[] primariesOfRegions = new int[cluster.numRegions];
            System.arraycopy(cluster.regionIndexToPrimaryIndex, 0, primariesOfRegions, 0, cluster.regions.length);
            Arrays.sort(primariesOfRegions);
            return this.costPerGroup(primariesOfRegions);
        }

        @Override
        double cost() {
            if (this.maxCost <= 0L) {
                return 0.0;
            }
            long totalCost = 0L;
            for (int i = 0; i < this.costsPerGroup.length; ++i) {
                totalCost += this.costsPerGroup[i];
            }
            return this.scale(0.0, this.maxCost, totalCost);
        }

        protected long costPerGroup(int[] primariesOfRegions) {
            long cost = 0L;
            int currentPrimary = -1;
            int currentPrimaryIndex = -1;
            for (int j = 0; j <= primariesOfRegions.length; ++j) {
                int primary;
                int n = primary = j < primariesOfRegions.length ? primariesOfRegions[j] : -1;
                if (primary == currentPrimary) continue;
                int numReplicas = j - currentPrimaryIndex;
                if (numReplicas > 1) {
                    cost += (long)((numReplicas - 1) * (numReplicas - 1));
                }
                currentPrimary = primary;
                currentPrimaryIndex = j;
            }
            return cost;
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            if (this.maxCost <= 0L) {
                return;
            }
            if (this.cluster.multiServersPerHost) {
                int newHost = this.cluster.serverIndexToHostIndex[newServer];
                int oldHost = this.cluster.serverIndexToHostIndex[oldServer];
                if (newHost != oldHost) {
                    this.costsPerGroup[oldHost] = this.costPerGroup(this.cluster.primariesOfRegionsPerHost[oldHost]);
                    this.costsPerGroup[newHost] = this.costPerGroup(this.cluster.primariesOfRegionsPerHost[newHost]);
                }
            } else {
                this.costsPerGroup[oldServer] = this.costPerGroup(this.cluster.primariesOfRegionsPerServer[oldServer]);
                this.costsPerGroup[newServer] = this.costPerGroup(this.cluster.primariesOfRegionsPerServer[newServer]);
            }
        }
    }

    static class WriteRequestCostFunction
    extends CostFromRegionLoadFunction {
        private static final String WRITE_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.writeRequestCost";
        private static final float DEFAULT_WRITE_REQUEST_COST = 5.0f;

        WriteRequestCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(WRITE_REQUEST_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getWriteRequestsCount();
        }
    }

    static class ReadRequestCostFunction
    extends CostFromRegionLoadFunction {
        private static final String READ_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.readRequestCost";
        private static final float DEFAULT_READ_REQUEST_COST = 5.0f;

        ReadRequestCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(READ_REQUEST_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getReadRequestsCount();
        }
    }

    static abstract class CostFromRegionLoadFunction
    extends CostFunction {
        private ClusterStatus clusterStatus = null;
        private Map<String, Deque<RegionLoad>> loads = null;
        private double[] stats = null;

        CostFromRegionLoadFunction(Configuration conf) {
            super(conf);
        }

        void setClusterStatus(ClusterStatus status) {
            this.clusterStatus = status;
        }

        void setLoads(Map<String, Deque<RegionLoad>> l) {
            this.loads = l;
        }

        @Override
        double cost() {
            if (this.clusterStatus == null || this.loads == null) {
                return 0.0;
            }
            if (this.stats == null || this.stats.length != this.cluster.numServers) {
                this.stats = new double[this.cluster.numServers];
            }
            for (int i = 0; i < this.stats.length; ++i) {
                long cost = 0L;
                for (int regionIndex : this.cluster.regionsPerServer[i]) {
                    Deque<RegionLoad> regionLoadList = this.cluster.regionLoads[regionIndex];
                    if (regionLoadList == null) continue;
                    cost = (long)((double)cost + this.getRegionLoadCost(regionLoadList));
                }
                this.stats[i] = cost;
            }
            return this.costFromArray(this.stats);
        }

        protected double getRegionLoadCost(Collection<RegionLoad> regionLoadList) {
            double cost = 0.0;
            for (RegionLoad rl : regionLoadList) {
                double toAdd = this.getCostFromRl(rl);
                if (cost == 0.0) {
                    cost = toAdd;
                    continue;
                }
                cost = 0.5 * cost + 0.5 * toAdd;
            }
            return cost;
        }

        protected abstract double getCostFromRl(RegionLoad var1);
    }

    static class LocalityCostFunction
    extends CostFunction {
        private static final String LOCALITY_COST_KEY = "hbase.master.balancer.stochastic.localityCost";
        private static final float DEFAULT_LOCALITY_COST = 25.0f;
        private MasterServices services;

        LocalityCostFunction(Configuration conf, MasterServices srv) {
            super(conf);
            this.setMultiplier(conf.getFloat(LOCALITY_COST_KEY, 25.0f));
            this.services = srv;
        }

        void setServices(MasterServices srvc) {
            this.services = srvc;
        }

        @Override
        double cost() {
            double max = 0.0;
            double cost = 0.0;
            if (this.services == null) {
                return cost;
            }
            for (int i = 0; i < this.cluster.regionLocations.length; ++i) {
                max += 1.0;
                int serverIndex = this.cluster.regionIndexToServerIndex[i];
                int[] regionLocations = this.cluster.regionLocations[i];
                if (regionLocations == null) continue;
                int index = -1;
                for (int j = 0; j < regionLocations.length; ++j) {
                    if (regionLocations[j] < 0 || regionLocations[j] != serverIndex) continue;
                    index = j;
                    break;
                }
                if (index < 0) {
                    if (regionLocations.length <= 0) continue;
                    cost += 1.0;
                    continue;
                }
                cost += (double)index / (double)regionLocations.length;
            }
            return this.scale(0.0, max, cost);
        }
    }

    static class TableSkewCostFunction
    extends CostFunction {
        private static final String TABLE_SKEW_COST_KEY = "hbase.master.balancer.stochastic.tableSkewCost";
        private static final float DEFAULT_TABLE_SKEW_COST = 35.0f;

        TableSkewCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(TABLE_SKEW_COST_KEY, 35.0f));
        }

        @Override
        double cost() {
            double max = this.cluster.numRegions;
            double min = (double)this.cluster.numRegions / (double)this.cluster.numServers;
            double value = 0.0;
            for (int i = 0; i < this.cluster.numMaxRegionsPerTable.length; ++i) {
                value += (double)this.cluster.numMaxRegionsPerTable[i];
            }
            return this.scale(min, max, value);
        }
    }

    static class RegionCountSkewCostFunction
    extends CostFunction {
        private static final String REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.regionCountCost";
        private static final float DEFAULT_REGION_COUNT_SKEW_COST = 500.0f;
        private double[] stats = null;

        RegionCountSkewCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(REGION_COUNT_SKEW_COST_KEY, 500.0f));
        }

        @Override
        double cost() {
            if (this.stats == null || this.stats.length != this.cluster.numServers) {
                this.stats = new double[this.cluster.numServers];
            }
            for (int i = 0; i < this.cluster.numServers; ++i) {
                this.stats[i] = this.cluster.regionsPerServer[i].length;
            }
            return this.costFromArray(this.stats);
        }
    }

    static class MoveCostFunction
    extends CostFunction {
        private static final String MOVE_COST_KEY = "hbase.master.balancer.stochastic.moveCost";
        private static final String MAX_MOVES_PERCENT_KEY = "hbase.master.balancer.stochastic.maxMovePercent";
        private static final float DEFAULT_MOVE_COST = 100.0f;
        private static final int DEFAULT_MAX_MOVES = 600;
        private static final float DEFAULT_MAX_MOVE_PERCENT = 0.25f;
        private final float maxMovesPercent;

        MoveCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(MOVE_COST_KEY, 100.0f));
            this.maxMovesPercent = conf.getFloat(MAX_MOVES_PERCENT_KEY, 0.25f);
        }

        @Override
        double cost() {
            double moveCost = this.cluster.numMovedRegions;
            int maxMoves = Math.max((int)((float)this.cluster.numRegions * this.maxMovesPercent), 600);
            if (moveCost > (double)maxMoves) {
                return 1000000.0;
            }
            return this.scale(0.0, Math.min(this.cluster.numRegions, maxMoves), moveCost);
        }
    }

    static abstract class CostFunction {
        private float multiplier = 0.0f;
        protected BaseLoadBalancer.Cluster cluster;

        CostFunction(Configuration c) {
        }

        float getMultiplier() {
            return this.multiplier;
        }

        void setMultiplier(float m) {
            this.multiplier = m;
        }

        void init(BaseLoadBalancer.Cluster cluster) {
            this.cluster = cluster;
        }

        void postAction(BaseLoadBalancer.Cluster.Action action) {
            switch (action.type) {
                case NULL: {
                    break;
                }
                case ASSIGN_REGION: {
                    BaseLoadBalancer.Cluster.AssignRegionAction ar = (BaseLoadBalancer.Cluster.AssignRegionAction)action;
                    this.regionMoved(ar.region, -1, ar.server);
                    break;
                }
                case MOVE_REGION: {
                    BaseLoadBalancer.Cluster.MoveRegionAction mra = (BaseLoadBalancer.Cluster.MoveRegionAction)action;
                    this.regionMoved(mra.region, mra.fromServer, mra.toServer);
                    break;
                }
                case SWAP_REGIONS: {
                    BaseLoadBalancer.Cluster.SwapRegionsAction a = (BaseLoadBalancer.Cluster.SwapRegionsAction)action;
                    this.regionMoved(a.fromRegion, a.fromServer, a.toServer);
                    this.regionMoved(a.toRegion, a.toServer, a.fromServer);
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown action:" + (Object)((Object)action.type));
                }
            }
        }

        protected void regionMoved(int region, int oldServer, int newServer) {
        }

        abstract double cost();

        protected double costFromArray(double[] stats) {
            double min;
            double totalCost = 0.0;
            double total = this.getSum(stats);
            double count = stats.length;
            double mean = total / count;
            double max = (count - 1.0) * mean + (total - mean);
            if (count > total) {
                min = (count - total) * mean + (1.0 - mean) * total;
            } else {
                int numHigh = (int)(total - Math.floor(mean) * count);
                int numLow = (int)(count - (double)numHigh);
                min = (double)numHigh * (Math.ceil(mean) - mean) + (double)numLow * (mean - Math.floor(mean));
            }
            min = Math.max(0.0, min);
            for (int i = 0; i < stats.length; ++i) {
                double n = stats[i];
                double diff = Math.abs(mean - n);
                totalCost += diff;
            }
            double scaled = this.scale(min, max, totalCost);
            return scaled;
        }

        private double getSum(double[] stats) {
            double total = 0.0;
            for (double s : stats) {
                total += s;
            }
            return total;
        }

        protected double scale(double min, double max, double value) {
            if (max <= min || value <= min) {
                return 0.0;
            }
            if (max - min == 0.0) {
                return 0.0;
            }
            return Math.max(0.0, Math.min(1.0, (value - min) / (max - min)));
        }
    }

    static class RegionReplicaRackCandidateGenerator
    extends RegionReplicaCandidateGenerator {
        RegionReplicaRackCandidateGenerator() {
        }

        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int rackIndex = this.pickRandomRack(cluster);
            if (cluster.numRacks <= 1 || rackIndex == -1) {
                return super.generate(cluster);
            }
            int regionIndex = this.selectCoHostedRegionPerGroup(cluster.primariesOfRegionsPerRack[rackIndex], cluster.regionsPerRack[rackIndex], cluster.regionIndexToPrimaryIndex);
            if (regionIndex == -1) {
                return this.randomGenerator.generate(cluster);
            }
            int serverIndex = cluster.regionIndexToServerIndex[regionIndex];
            int toRackIndex = this.pickOtherRandomRack(cluster, rackIndex);
            int rand = RANDOM.nextInt(cluster.serversPerRack[toRackIndex].length);
            int toServerIndex = cluster.serversPerRack[toRackIndex][rand];
            int toRegionIndex = this.pickRandomRegion(cluster, toServerIndex, 0.9f);
            return this.getAction(serverIndex, regionIndex, toServerIndex, toRegionIndex);
        }
    }

    static class RegionReplicaCandidateGenerator
    extends CandidateGenerator {
        RandomCandidateGenerator randomGenerator = new RandomCandidateGenerator();

        RegionReplicaCandidateGenerator() {
        }

        int selectCoHostedRegionPerGroup(int[] primariesOfRegionsPerGroup, int[] regionsPerGroup, int[] regionIndexToPrimaryIndex) {
            int j;
            int currentPrimary = -1;
            int currentPrimaryIndex = -1;
            int selectedPrimaryIndex = -1;
            double currentLargestRandom = -1.0;
            for (j = 0; j <= primariesOfRegionsPerGroup.length; ++j) {
                double currentRandom;
                int primary;
                int n = primary = j < primariesOfRegionsPerGroup.length ? primariesOfRegionsPerGroup[j] : -1;
                if (primary == currentPrimary) continue;
                int numReplicas = j - currentPrimaryIndex;
                if (numReplicas > 1 && (currentRandom = RANDOM.nextDouble()) > currentLargestRandom) {
                    selectedPrimaryIndex = currentPrimary;
                    currentLargestRandom = currentRandom;
                }
                currentPrimary = primary;
                currentPrimaryIndex = j;
            }
            for (j = 0; j < regionsPerGroup.length; ++j) {
                int regionIndex = regionsPerGroup[j];
                if (selectedPrimaryIndex != regionIndexToPrimaryIndex[regionIndex] || selectedPrimaryIndex == regionIndex) continue;
                return regionIndex;
            }
            return -1;
        }

        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int serverIndex = this.pickRandomServer(cluster);
            if (cluster.numServers <= 1 || serverIndex == -1) {
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int regionIndex = this.selectCoHostedRegionPerGroup(cluster.primariesOfRegionsPerServer[serverIndex], cluster.regionsPerServer[serverIndex], cluster.regionIndexToPrimaryIndex);
            if (regionIndex == -1) {
                return this.randomGenerator.generate(cluster);
            }
            int toServerIndex = this.pickOtherRandomServer(cluster, serverIndex);
            int toRegionIndex = this.pickRandomRegion(cluster, toServerIndex, 0.9f);
            return this.getAction(serverIndex, regionIndex, toServerIndex, toRegionIndex);
        }
    }

    static class LocalityBasedCandidateGenerator
    extends CandidateGenerator {
        private MasterServices masterServices;

        LocalityBasedCandidateGenerator(MasterServices masterServices) {
            this.masterServices = masterServices;
        }

        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            if (this.masterServices == null) {
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int thisServer = this.pickRandomServer(cluster);
            int thisRegion = this.pickRandomRegion(cluster, thisServer, 0.0);
            if (thisRegion == -1) {
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int otherServer = this.pickHighestLocalityServer(cluster, thisServer, thisRegion);
            if (otherServer == -1) {
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int otherRegion = this.pickRandomRegion(cluster, otherServer, 0.5);
            return this.getAction(thisServer, thisRegion, otherServer, otherRegion);
        }

        private int pickHighestLocalityServer(BaseLoadBalancer.Cluster cluster, int thisServer, int thisRegion) {
            int[] regionLocations = cluster.regionLocations[thisRegion];
            if (regionLocations == null || regionLocations.length <= 1) {
                return this.pickOtherRandomServer(cluster, thisServer);
            }
            for (int loc : regionLocations) {
                if (loc < 0 || loc == thisServer) continue;
                return loc;
            }
            return this.pickOtherRandomServer(cluster, thisServer);
        }

        void setServices(MasterServices services) {
            this.masterServices = services;
        }
    }

    static class LoadCandidateGenerator
    extends CandidateGenerator {
        LoadCandidateGenerator() {
        }

        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            cluster.sortServersByRegionCount();
            int thisServer = this.pickMostLoadedServer(cluster, -1);
            int otherServer = this.pickLeastLoadedServer(cluster, thisServer);
            return this.pickRandomRegions(cluster, thisServer, otherServer);
        }

        private int pickLeastLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            int index = 0;
            while (servers[index] == null || servers[index] == thisServer) {
                if (++index != servers.length) continue;
                return -1;
            }
            return servers[index];
        }

        private int pickMostLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            int index = servers.length - 1;
            while (servers[index] == null || servers[index] == thisServer) {
                if (--index >= 0) continue;
                return -1;
            }
            return servers[index];
        }
    }

    static class RandomCandidateGenerator
    extends CandidateGenerator {
        RandomCandidateGenerator() {
        }

        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int thisServer = this.pickRandomServer(cluster);
            int otherServer = this.pickOtherRandomServer(cluster, thisServer);
            return this.pickRandomRegions(cluster, thisServer, otherServer);
        }
    }

    static abstract class CandidateGenerator {
        CandidateGenerator() {
        }

        abstract BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster var1);

        protected int pickRandomRegion(BaseLoadBalancer.Cluster cluster, int server, double chanceOfNoSwap) {
            if (cluster.regionsPerServer[server].length == 0 || (double)RANDOM.nextFloat() < chanceOfNoSwap) {
                return -1;
            }
            int rand = RANDOM.nextInt(cluster.regionsPerServer[server].length);
            return cluster.regionsPerServer[server][rand];
        }

        protected int pickRandomServer(BaseLoadBalancer.Cluster cluster) {
            if (cluster.numServers < 1) {
                return -1;
            }
            return RANDOM.nextInt(cluster.numServers);
        }

        protected int pickRandomRack(BaseLoadBalancer.Cluster cluster) {
            if (cluster.numRacks < 1) {
                return -1;
            }
            return RANDOM.nextInt(cluster.numRacks);
        }

        protected int pickOtherRandomServer(BaseLoadBalancer.Cluster cluster, int serverIndex) {
            int otherServerIndex;
            if (cluster.numServers < 2) {
                return -1;
            }
            while ((otherServerIndex = this.pickRandomServer(cluster)) == serverIndex) {
            }
            return otherServerIndex;
        }

        protected int pickOtherRandomRack(BaseLoadBalancer.Cluster cluster, int rackIndex) {
            int otherRackIndex;
            if (cluster.numRacks < 2) {
                return -1;
            }
            while ((otherRackIndex = this.pickRandomRack(cluster)) == rackIndex) {
            }
            return otherRackIndex;
        }

        protected BaseLoadBalancer.Cluster.Action pickRandomRegions(BaseLoadBalancer.Cluster cluster, int thisServer, int otherServer) {
            int otherRegionCount;
            if (thisServer < 0 || otherServer < 0) {
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int thisRegionCount = cluster.getNumRegions(thisServer);
            double thisChance = thisRegionCount > (otherRegionCount = cluster.getNumRegions(otherServer)) ? 0.0 : 0.5;
            double otherChance = thisRegionCount <= otherRegionCount ? 0.0 : 0.5;
            int thisRegion = this.pickRandomRegion(cluster, thisServer, thisChance);
            int otherRegion = this.pickRandomRegion(cluster, otherServer, otherChance);
            return this.getAction(thisServer, thisRegion, otherServer, otherRegion);
        }

        protected BaseLoadBalancer.Cluster.Action getAction(int fromServer, int fromRegion, int toServer, int toRegion) {
            if (fromServer < 0 || toServer < 0) {
                return BaseLoadBalancer.Cluster.NullAction;
            }
            if (fromRegion > 0 && toRegion > 0) {
                return new BaseLoadBalancer.Cluster.SwapRegionsAction(fromServer, fromRegion, toServer, toRegion);
            }
            if (fromRegion > 0) {
                return new BaseLoadBalancer.Cluster.MoveRegionAction(fromRegion, fromServer, toServer);
            }
            if (toRegion > 0) {
                return new BaseLoadBalancer.Cluster.MoveRegionAction(toRegion, toServer, fromServer);
            }
            return BaseLoadBalancer.Cluster.NullAction;
        }
    }
}

