/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.compress.ReusableStreamGzipCodec;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public final class Compression {
    static final Log LOG = LogFactory.getLog(Compression.class);

    private Compression() {
    }

    private static ClassLoader getClassLoaderForCodec() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Compression.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            throw new RuntimeException("A ClassLoader to load the Codec could not be determined");
        }
        return cl;
    }

    public static Algorithm getCompressionAlgorithmByName(String compressName) {
        Algorithm[] algos;
        for (Algorithm a : algos = (Algorithm[])Algorithm.class.getEnumConstants()) {
            if (!a.getName().equals(compressName)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unsupported compression algorithm name: " + compressName);
    }

    public static String[] getSupportedAlgorithms() {
        Algorithm[] algos = (Algorithm[])Algorithm.class.getEnumConstants();
        String[] ret = new String[algos.length];
        int i = 0;
        for (Algorithm a : algos) {
            ret[i++] = a.getName();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(byte[] dest, int destOffset, InputStream bufferedBoundedStream, int compressedSize, int uncompressedSize, Algorithm compressAlgo) throws IOException {
        if (dest.length - destOffset < uncompressedSize) {
            throw new IllegalArgumentException("Output buffer does not have enough space to hold " + uncompressedSize + " decompressed bytes, available: " + (dest.length - destOffset));
        }
        Decompressor decompressor = null;
        try {
            decompressor = compressAlgo.getDecompressor();
            InputStream is = compressAlgo.createDecompressionStream(bufferedBoundedStream, decompressor, 0);
            IOUtils.readFully(is, dest, destOffset, uncompressedSize);
            is.close();
        }
        finally {
            if (decompressor != null) {
                compressAlgo.returnDecompressor(decompressor);
            }
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="We are not serializing so doesn't apply (not sure why transient though)")
    public static enum Algorithm {
        LZO("lzo"){
            private volatile transient CompressionCodec lzoCodec;
            private transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.lzoCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.lzoCodec == null) {
                            this.lzoCodec = this.buildCodec(conf);
                        }
                    }
                }
                return this.lzoCodec;
            }

            private CompressionCodec buildCodec(Configuration conf) {
                try {
                    Class<?> externalCodec = Compression.getClassLoaderForCodec().loadClass("com.hadoop.compression.lzo.LzoCodec");
                    return (CompressionCodec)ReflectionUtils.newInstance(externalCodec, new Configuration(conf));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        GZ("gz"){
            private volatile transient GzipCodec codec;
            private transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            DefaultCodec getCodec(Configuration conf) {
                if (this.codec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.codec == null) {
                            this.codec = this.buildCodec(conf);
                        }
                    }
                }
                return this.codec;
            }

            private GzipCodec buildCodec(Configuration conf) {
                ReusableStreamGzipCodec gzcodec = new ReusableStreamGzipCodec();
                gzcodec.setConf(new Configuration(conf));
                return gzcodec;
            }
        }
        ,
        NONE("none"){

            @Override
            DefaultCodec getCodec(Configuration conf) {
                return null;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedInputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedOutputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }
        }
        ,
        SNAPPY("snappy"){
            private volatile transient CompressionCodec snappyCodec;
            private transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.snappyCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.snappyCodec == null) {
                            this.snappyCodec = this.buildCodec(conf);
                        }
                    }
                }
                return this.snappyCodec;
            }

            private CompressionCodec buildCodec(Configuration conf) {
                try {
                    Class<?> externalCodec = Compression.getClassLoaderForCodec().loadClass("org.apache.hadoop.io.compress.SnappyCodec");
                    return (CompressionCodec)ReflectionUtils.newInstance(externalCodec, conf);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        LZ4("lz4"){
            private volatile transient CompressionCodec lz4Codec;
            private transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.lz4Codec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.lz4Codec == null) {
                            this.lz4Codec = this.buildCodec(conf);
                        }
                    }
                }
                return this.lz4Codec;
            }

            private CompressionCodec buildCodec(Configuration conf) {
                try {
                    Class<?> externalCodec = Compression.getClassLoaderForCodec().loadClass("org.apache.hadoop.io.compress.Lz4Codec");
                    return (CompressionCodec)ReflectionUtils.newInstance(externalCodec, conf);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private final Configuration conf = new Configuration();
        private final String compressName;
        private static final int DATA_IBUF_SIZE = 1024;
        private static final int DATA_OBUF_SIZE = 4096;

        private Algorithm(String name) {
            this.conf.setBoolean("io.native.lib.available", true);
            this.compressName = name;
        }

        abstract CompressionCodec getCodec(Configuration var1);

        public InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
            CompressionCodec codec = this.getCodec(this.conf);
            if (downStreamBufferSize > 0) {
                ((Configurable)((Object)codec)).getConf().setInt("io.file.buffer.size", downStreamBufferSize);
            }
            CompressionInputStream cis = codec.createInputStream(downStream, decompressor);
            BufferedInputStream bis2 = new BufferedInputStream(cis, 1024);
            return bis2;
        }

        public OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
            OutputStream bos1 = null;
            bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
            CompressionOutputStream cos = this.createPlainCompressionStream(bos1, compressor);
            BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
            return bos2;
        }

        public CompressionOutputStream createPlainCompressionStream(OutputStream downStream, Compressor compressor) throws IOException {
            CompressionCodec codec = this.getCodec(this.conf);
            ((Configurable)((Object)codec)).getConf().setInt("io.file.buffer.size", 32768);
            return codec.createOutputStream(downStream, compressor);
        }

        public Compressor getCompressor() {
            CompressionCodec codec = this.getCodec(this.conf);
            if (codec != null) {
                Compressor compressor = CodecPool.getCompressor(codec);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Retrieved compressor " + compressor + " from pool.");
                }
                if (compressor != null) {
                    if (compressor.finished()) {
                        LOG.warn("Compressor obtained from CodecPool is already finished()");
                    }
                    compressor.reset();
                }
                return compressor;
            }
            return null;
        }

        public void returnCompressor(Compressor compressor) {
            if (compressor != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Returning compressor " + compressor + " to pool.");
                }
                CodecPool.returnCompressor(compressor);
            }
        }

        public Decompressor getDecompressor() {
            CompressionCodec codec = this.getCodec(this.conf);
            if (codec != null) {
                Decompressor decompressor = CodecPool.getDecompressor(codec);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Retrieved decompressor " + decompressor + " from pool.");
                }
                if (decompressor != null) {
                    if (decompressor.finished()) {
                        LOG.warn("Deompressor obtained from CodecPool is already finished()");
                    }
                    decompressor.reset();
                }
                return decompressor;
            }
            return null;
        }

        public void returnDecompressor(Decompressor decompressor) {
            if (decompressor != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Returning decompressor " + decompressor + " to pool.");
                }
                CodecPool.returnDecompressor(decompressor);
                if (decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Ending decompressor " + decompressor);
                    }
                    decompressor.end();
                }
            }
        }

        public String getName() {
            return this.compressName;
        }
    }

    static class FinishOnFlushCompressionStream
    extends FilterOutputStream {
        public FinishOnFlushCompressionStream(CompressionOutputStream cout) {
            super(cout);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            CompressionOutputStream cout = (CompressionOutputStream)this.out;
            cout.finish();
            cout.flush();
            cout.resetState();
        }
    }
}

