/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.conf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.http.HttpServer;

@InterfaceAudience.LimitedPrivate(value={"HBase"})
@InterfaceStability.Unstable
public class ConfServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT_JSON = "json";
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_PARAM = "format";

    private Configuration getConfFromContext() {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("hbase.conf");
        assert (conf != null);
        return conf;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
            return;
        }
        String format = request.getParameter(FORMAT_PARAM);
        if (null == format) {
            format = FORMAT_XML;
        }
        if (FORMAT_XML.equals(format)) {
            response.setContentType("text/xml; charset=utf-8");
        } else if (FORMAT_JSON.equals(format)) {
            response.setContentType("application/json; charset=utf-8");
        }
        PrintWriter out = response.getWriter();
        try {
            ConfServlet.writeResponse(this.getConfFromContext(), out, format);
        }
        catch (BadFormatException bfe) {
            response.sendError(400, bfe.getMessage());
        }
        ((Writer)out).close();
    }

    static void writeResponse(Configuration conf, Writer out, String format) throws IOException, BadFormatException {
        if (FORMAT_JSON.equals(format)) {
            Configuration.dumpConfiguration(conf, out);
        } else if (FORMAT_XML.equals(format)) {
            conf.writeXml(out);
        } else {
            throw new BadFormatException("Bad format: " + format);
        }
    }

    public static class BadFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadFormatException(String msg) {
            super(msg);
        }
    }
}

