/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SingleColumnValueFilter
extends FilterBase {
    static final Log LOG = LogFactory.getLog(SingleColumnValueFilter.class);
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    protected CompareFilter.CompareOp compareOp;
    protected ByteArrayComparable comparator;
    protected boolean foundColumn = false;
    protected boolean matchedColumn = false;
    protected boolean filterIfMissing = false;
    protected boolean latestVersionOnly = true;

    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value) {
        this(family, qualifier, compareOp, new BinaryComparator(value));
    }

    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.compareOp = compareOp;
        this.comparator = comparator;
    }

    protected SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, boolean filterIfMissing, boolean latestVersionOnly) {
        this(family, qualifier, compareOp, comparator);
        this.filterIfMissing = filterIfMissing;
        this.latestVersionOnly = latestVersionOnly;
    }

    public CompareFilter.CompareOp getOperator() {
        return this.compareOp;
    }

    public ByteArrayComparable getComparator() {
        return this.comparator;
    }

    public byte[] getFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.columnQualifier;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell c) {
        if (this.matchedColumn) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.latestVersionOnly && this.foundColumn) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        if (!CellUtil.matchingColumn(c, this.columnFamily, this.columnQualifier)) {
            return Filter.ReturnCode.INCLUDE;
        }
        this.foundColumn = true;
        if (this.filterColumnValue(c.getValueArray(), c.getValueOffset(), c.getValueLength())) {
            return this.latestVersionOnly ? Filter.ReturnCode.NEXT_ROW : Filter.ReturnCode.INCLUDE;
        }
        this.matchedColumn = true;
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    private boolean filterColumnValue(byte[] data, int offset, int length) {
        int compareResult = this.comparator.compareTo(data, offset, length);
        switch (this.compareOp) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + this.compareOp.name());
    }

    @Override
    public boolean filterRow() {
        return this.foundColumn ? !this.matchedColumn : this.filterIfMissing;
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public void reset() {
        this.foundColumn = false;
        this.matchedColumn = false;
    }

    public boolean getFilterIfMissing() {
        return this.filterIfMissing;
    }

    public void setFilterIfMissing(boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
    }

    public boolean getLatestVersionOnly() {
        return this.latestVersionOnly;
    }

    public void setLatestVersionOnly(boolean latestVersionOnly) {
        this.latestVersionOnly = latestVersionOnly;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 4 || filterArguments.size() == 6, "Expected 4 or 6 but got: %s", filterArguments.size());
        byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
        CompareFilter.CompareOp compareOp = ParseFilter.createCompareOp(filterArguments.get(2));
        ByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(3)));
        if ((comparator instanceof RegexStringComparator || comparator instanceof SubstringComparator) && compareOp != CompareFilter.CompareOp.EQUAL && compareOp != CompareFilter.CompareOp.NOT_EQUAL) {
            throw new IllegalArgumentException("A regexstring comparator and substring comparator can only be used with EQUAL and NOT_EQUAL");
        }
        SingleColumnValueFilter filter = new SingleColumnValueFilter(family, qualifier, compareOp, comparator);
        if (filterArguments.size() == 6) {
            boolean filterIfMissing = ParseFilter.convertByteArrayToBoolean(filterArguments.get(4));
            boolean latestVersionOnly = ParseFilter.convertByteArrayToBoolean(filterArguments.get(5));
            filter.setFilterIfMissing(filterIfMissing);
            filter.setLatestVersionOnly(latestVersionOnly);
        }
        return filter;
    }

    FilterProtos.SingleColumnValueFilter convert() {
        FilterProtos.SingleColumnValueFilter.Builder builder = FilterProtos.SingleColumnValueFilter.newBuilder();
        if (this.columnFamily != null) {
            builder.setColumnFamily(ByteStringer.wrap(this.columnFamily));
        }
        if (this.columnQualifier != null) {
            builder.setColumnQualifier(ByteStringer.wrap(this.columnQualifier));
        }
        HBaseProtos.CompareType compareOp = HBaseProtos.CompareType.valueOf(this.compareOp.name());
        builder.setCompareOp(compareOp);
        builder.setComparator(ProtobufUtil.toComparator(this.comparator));
        builder.setFilterIfMissing(this.filterIfMissing);
        builder.setLatestVersionOnly(this.latestVersionOnly);
        return builder.build();
    }

    @Override
    public byte[] toByteArray() {
        return this.convert().toByteArray();
    }

    public static SingleColumnValueFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        ByteArrayComparable comparator;
        FilterProtos.SingleColumnValueFilter proto;
        try {
            proto = FilterProtos.SingleColumnValueFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf(proto.getCompareOp().name());
        try {
            comparator = ProtobufUtil.toComparator(proto.getComparator());
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new SingleColumnValueFilter(proto.hasColumnFamily() ? proto.getColumnFamily().toByteArray() : null, proto.hasColumnQualifier() ? proto.getColumnQualifier().toByteArray() : null, compareOp, comparator, proto.getFilterIfMissing(), proto.getLatestVersionOnly());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleColumnValueFilter)) {
            return false;
        }
        SingleColumnValueFilter other = (SingleColumnValueFilter)o;
        return Bytes.equals(this.getFamily(), other.getFamily()) && Bytes.equals(this.getQualifier(), other.getQualifier()) && this.compareOp.equals((Object)other.compareOp) && this.getComparator().areSerializedFieldsEqual(other.getComparator()) && this.getFilterIfMissing() == other.getFilterIfMissing() && this.getLatestVersionOnly() == other.getLatestVersionOnly();
    }

    @Override
    public boolean isFamilyEssential(byte[] name) {
        return !this.filterIfMissing || Bytes.equals(name, this.columnFamily);
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s, %s, %s)", this.getClass().getSimpleName(), Bytes.toStringBinary(this.columnFamily), Bytes.toStringBinary(this.columnQualifier), this.compareOp.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }
}

