/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZkOpenRegionCoordination
implements OpenRegionCoordination {
    private static final Log LOG = LogFactory.getLog(ZkOpenRegionCoordination.class);
    private CoordinatedStateManager coordination;
    private final ZooKeeperWatcher watcher;

    public ZkOpenRegionCoordination(CoordinatedStateManager coordination, ZooKeeperWatcher watcher) {
        this.coordination = coordination;
        this.watcher = watcher;
    }

    @Override
    public boolean transitionToOpened(HRegion r, OpenRegionCoordination.OpenRegionDetails ord) throws IOException {
        boolean result;
        block6: {
            ZkOpenRegionDetails zkOrd = (ZkOpenRegionDetails)ord;
            result = false;
            HRegionInfo hri = r.getRegionInfo();
            String name = hri.getRegionNameAsString();
            try {
                if (ZKAssign.transitionNodeOpened(this.watcher, hri, zkOrd.getServerName(), zkOrd.getVersion()) == -1) {
                    String warnMsg = "Completed the OPEN of region " + name + " but when transitioning from " + " OPENING to OPENED ";
                    try {
                        String node = ZKAssign.getNodeName(this.watcher, hri.getEncodedName());
                        if (ZKUtil.checkExists(this.watcher, node) < 0) {
                            this.coordination.getServer().abort(warnMsg + "the znode disappeared", null);
                            break block6;
                        }
                        LOG.warn(warnMsg + "got a version mismatch, someone else clashed; " + "so now unassigning -- closing region on server: " + zkOrd.getServerName());
                    }
                    catch (KeeperException ke) {
                        this.coordination.getServer().abort(warnMsg, ke);
                    }
                    break block6;
                }
                LOG.debug("Transitioned " + r.getRegionInfo().getEncodedName() + " to OPENED in zk on " + zkOrd.getServerName());
                result = true;
            }
            catch (KeeperException e) {
                LOG.error("Failed transitioning node " + name + " from OPENING to OPENED -- closing region", e);
            }
        }
        return result;
    }

    @Override
    public boolean transitionFromOfflineToOpening(HRegionInfo regionInfo, OpenRegionCoordination.OpenRegionDetails ord) {
        ZkOpenRegionDetails zkOrd = (ZkOpenRegionDetails)ord;
        String encodedName = regionInfo.getEncodedName();
        try {
            zkOrd.setVersion(ZKAssign.transitionNode(this.watcher, regionInfo, zkOrd.getServerName(), EventType.M_ZK_REGION_OFFLINE, EventType.RS_ZK_REGION_OPENING, zkOrd.getVersionOfOfflineNode()));
        }
        catch (KeeperException e) {
            LOG.error("Error transition from OFFLINE to OPENING for region=" + encodedName, e);
            zkOrd.setVersion(-1);
            return false;
        }
        boolean b = this.isGoodVersion(zkOrd);
        if (!b) {
            LOG.warn("Failed transition from OFFLINE to OPENING for region=" + encodedName);
        }
        return b;
    }

    @Override
    public boolean tickleOpening(OpenRegionCoordination.OpenRegionDetails ord, HRegionInfo regionInfo, RegionServerServices rsServices, String context) {
        ZkOpenRegionDetails zkOrd = (ZkOpenRegionDetails)ord;
        if (!this.isRegionStillOpening(regionInfo, rsServices)) {
            LOG.warn("Open region aborted since it isn't opening any more");
            return false;
        }
        if (!this.isGoodVersion(zkOrd)) {
            return false;
        }
        String encodedName = regionInfo.getEncodedName();
        try {
            zkOrd.setVersion(ZKAssign.confirmNodeOpening(this.watcher, regionInfo, zkOrd.getServerName(), zkOrd.getVersion()));
        }
        catch (KeeperException e) {
            this.coordination.getServer().abort("Exception refreshing OPENING; region=" + encodedName + ", context=" + context, e);
            zkOrd.setVersion(-1);
            return false;
        }
        boolean b = this.isGoodVersion(zkOrd);
        if (!b) {
            LOG.warn("Failed refreshing OPENING; region=" + encodedName + ", context=" + context);
        }
        return b;
    }

    @Override
    public boolean tryTransitionFromOfflineToFailedOpen(RegionServerServices rsServices, HRegionInfo hri, OpenRegionCoordination.OpenRegionDetails ord) {
        ZkOpenRegionDetails zkOrd = (ZkOpenRegionDetails)ord;
        boolean result = false;
        String name = hri.getRegionNameAsString();
        try {
            LOG.info("Opening of region " + hri + " failed, transitioning" + " from OFFLINE to FAILED_OPEN in ZK, expecting version " + zkOrd.getVersionOfOfflineNode());
            if (ZKAssign.transitionNode(rsServices.getZooKeeper(), hri, rsServices.getServerName(), EventType.M_ZK_REGION_OFFLINE, EventType.RS_ZK_REGION_FAILED_OPEN, zkOrd.getVersionOfOfflineNode()) == -1) {
                LOG.warn("Unable to mark region " + hri + " as FAILED_OPEN. " + "It's likely that the master already timed out this open " + "attempt, and thus another RS already has the region.");
            } else {
                result = true;
            }
        }
        catch (KeeperException e) {
            LOG.error("Failed transitioning node " + name + " from OFFLINE to FAILED_OPEN", e);
        }
        return result;
    }

    private boolean isGoodVersion(ZkOpenRegionDetails zkOrd) {
        return zkOrd.getVersion() != -1;
    }

    @Override
    public boolean tryTransitionFromOpeningToFailedOpen(HRegionInfo hri, OpenRegionCoordination.OpenRegionDetails ord) {
        ZkOpenRegionDetails zkOrd = (ZkOpenRegionDetails)ord;
        boolean result = false;
        String name = hri.getRegionNameAsString();
        try {
            LOG.info("Opening of region " + hri + " failed, transitioning" + " from OPENING to FAILED_OPEN in ZK, expecting version " + zkOrd.getVersion());
            if (ZKAssign.transitionNode(this.watcher, hri, zkOrd.getServerName(), EventType.RS_ZK_REGION_OPENING, EventType.RS_ZK_REGION_FAILED_OPEN, zkOrd.getVersion()) == -1) {
                LOG.warn("Unable to mark region " + hri + " as FAILED_OPEN. " + "It's likely that the master already timed out this open " + "attempt, and thus another RS already has the region.");
            } else {
                result = true;
            }
        }
        catch (KeeperException e) {
            LOG.error("Failed transitioning node " + name + " from OPENING to FAILED_OPEN", e);
        }
        return result;
    }

    @Override
    public OpenRegionCoordination.OpenRegionDetails parseFromProtoRequest(AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo) {
        ZkOpenRegionDetails zkCrd = new ZkOpenRegionDetails();
        int versionOfOfflineNode = -1;
        if (regionOpenInfo.hasVersionOfOfflineNode()) {
            versionOfOfflineNode = regionOpenInfo.getVersionOfOfflineNode();
        }
        zkCrd.setVersionOfOfflineNode(versionOfOfflineNode);
        zkCrd.setServerName(this.coordination.getServer().getServerName());
        return zkCrd;
    }

    @Override
    public OpenRegionCoordination.OpenRegionDetails getDetailsForNonCoordinatedOpening() {
        ZkOpenRegionDetails zkCrd = new ZkOpenRegionDetails();
        zkCrd.setVersionOfOfflineNode(-1);
        zkCrd.setServerName(this.coordination.getServer().getServerName());
        return zkCrd;
    }

    @Override
    public boolean commitOpenOnMasterSide(AssignmentManager assignmentManager, HRegionInfo regionInfo, OpenRegionCoordination.OpenRegionDetails ord) {
        boolean committedSuccessfully = true;
        RegionState regionState = assignmentManager.getRegionStates().getRegionTransitionState(regionInfo.getEncodedName());
        boolean openedNodeDeleted = false;
        if (regionState != null && regionState.isOpened()) {
            openedNodeDeleted = this.deleteOpenedNode(regionInfo, ord);
            if (!openedNodeDeleted) {
                LOG.error("Znode of region " + regionInfo.getShortNameToLog() + " could not be deleted.");
            }
        } else {
            LOG.warn("Skipping the onlining of " + regionInfo.getShortNameToLog() + " because regions is NOT in RIT -- presuming this is because it SPLIT");
        }
        if (!openedNodeDeleted && assignmentManager.getTableStateManager().isTableState(regionInfo.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
            this.debugLog(regionInfo, "Opened region " + regionInfo.getShortNameToLog() + " but " + "this table is disabled, triggering close of region");
            committedSuccessfully = false;
        }
        return committedSuccessfully;
    }

    private boolean deleteOpenedNode(HRegionInfo regionInfo, OpenRegionCoordination.OpenRegionDetails ord) {
        ZkOpenRegionDetails zkOrd = (ZkOpenRegionDetails)ord;
        int expectedVersion = zkOrd.getVersion();
        this.debugLog(regionInfo, "Handling OPENED of " + regionInfo.getShortNameToLog() + " from " + zkOrd.getServerName().toString() + "; deleting unassigned node");
        try {
            return ZKAssign.deleteNode(this.coordination.getServer().getZooKeeper(), regionInfo.getEncodedName(), EventType.RS_ZK_REGION_OPENED, expectedVersion);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn("The znode of the region " + regionInfo.getShortNameToLog() + " would have already been deleted");
            return false;
        }
        catch (KeeperException e) {
            this.coordination.getServer().abort("Error deleting OPENED node in ZK (" + regionInfo.getRegionNameAsString() + ")", e);
            return false;
        }
    }

    private void debugLog(HRegionInfo region, String string) {
        if (region.isMetaTable()) {
            LOG.info(string);
        } else {
            LOG.debug(string);
        }
    }

    private boolean isRegionStillOpening(HRegionInfo regionInfo, RegionServerServices rsServices) {
        byte[] encodedName = regionInfo.getEncodedNameAsBytes();
        Boolean action = (Boolean)rsServices.getRegionsInTransitionInRS().get(encodedName);
        return Boolean.TRUE.equals(action);
    }

    public static class ZkOpenRegionDetails
    implements OpenRegionCoordination.OpenRegionDetails {
        private volatile int version = -1;
        private volatile int versionOfOfflineNode = -1;
        private ServerName serverName;

        public ZkOpenRegionDetails() {
        }

        public ZkOpenRegionDetails(int versionOfOfflineNode) {
            this.versionOfOfflineNode = versionOfOfflineNode;
        }

        public int getVersionOfOfflineNode() {
            return this.versionOfOfflineNode;
        }

        public void setVersionOfOfflineNode(int versionOfOfflineNode) {
            this.versionOfOfflineNode = versionOfOfflineNode;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        @Override
        public ServerName getServerName() {
            return this.serverName;
        }

        @Override
        public void setServerName(ServerName serverName) {
            this.serverName = serverName;
        }
    }
}

