/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Append
extends Mutation {
    public Append setReturnResults(boolean returnResults) {
        this.setAttribute("_rr_", Bytes.toBytes(returnResults));
        return this;
    }

    public boolean isReturnResults() {
        byte[] v = this.getAttribute("_rr_");
        return v == null ? true : Bytes.toBoolean(v);
    }

    public Append(byte[] row) {
        this(row, 0, row.length);
    }

    public Append(Append a) {
        this.row = a.getRow();
        this.ts = a.getTimeStamp();
        this.familyMap.putAll(a.getFamilyCellMap());
        for (Map.Entry<String, byte[]> entry : a.getAttributesMap().entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public Append(byte[] rowArray, int rowOffset, int rowLength) {
        Append.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy(rowArray, rowOffset, rowLength);
    }

    public Append add(byte[] family, byte[] qualifier, byte[] value) {
        KeyValue kv = new KeyValue(this.row, family, qualifier, this.ts, KeyValue.Type.Put, value);
        return this.add(kv);
    }

    public Append add(Cell cell) {
        byte[] family = CellUtil.cloneFamily(cell);
        ArrayList<Cell> list = (ArrayList<Cell>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<Cell>();
        }
        list.add(cell);
        this.familyMap.put(family, list);
        return this;
    }

    @Override
    public Append setAttribute(String name, byte[] value) {
        return (Append)super.setAttribute(name, value);
    }

    @Override
    public Append setId(String id) {
        return (Append)super.setId(id);
    }

    @Override
    @Deprecated
    public Append setWriteToWAL(boolean write2) {
        return (Append)super.setWriteToWAL(write2);
    }

    @Override
    public Append setDurability(Durability d) {
        return (Append)super.setDurability(d);
    }

    @Override
    public Append setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        return (Append)super.setFamilyCellMap(map);
    }

    @Override
    @Deprecated
    public Append setFamilyMap(NavigableMap<byte[], List<KeyValue>> map) {
        return (Append)super.setFamilyMap(map);
    }

    @Override
    public Append setClusterIds(List<UUID> clusterIds) {
        return (Append)super.setClusterIds(clusterIds);
    }

    @Override
    public Append setCellVisibility(CellVisibility expression) {
        return (Append)super.setCellVisibility(expression);
    }

    @Override
    public Append setACL(String user, Permission perms) {
        return (Append)super.setACL(user, perms);
    }

    @Override
    public Append setACL(Map<String, Permission> perms) {
        return (Append)super.setACL(perms);
    }

    @Override
    public Append setTTL(long ttl) {
        return (Append)super.setTTL(ttl);
    }
}

