/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.application;

import java.util.Map;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.rest.application.resources.AggregateModelRefresher;
import org.apache.slider.server.appmaster.web.rest.application.resources.AppconfRefresher;
import org.apache.slider.server.appmaster.web.rest.application.resources.CachedContent;
import org.apache.slider.server.appmaster.web.rest.application.resources.ContentCache;
import org.apache.slider.server.appmaster.web.rest.application.resources.LiveComponentsRefresher;
import org.apache.slider.server.appmaster.web.rest.application.resources.LiveContainersRefresher;
import org.apache.slider.server.appmaster.web.rest.application.resources.LiveNodesRefresher;
import org.apache.slider.server.appmaster.web.rest.application.resources.LiveResourcesRefresher;
import org.apache.slider.server.appmaster.web.rest.application.resources.LiveStatisticsRefresher;

public class ApplicationResouceContentCacheFactory {
    public static final int LIFESPAN = 500;

    public static ContentCache createContentCache(StateAccessForProviders state) {
        ContentCache cache = new ContentCache();
        cache.put("/live/resources", new CachedContent<ConfTree>(500L, new LiveResourcesRefresher(state)));
        cache.put("/live/containers", new CachedContent<Map<String, ContainerInformation>>(500L, new LiveContainersRefresher(state)));
        cache.put("/live/components", new CachedContent<Map<String, ComponentInformation>>(500L, new LiveComponentsRefresher(state)));
        cache.put("/live/nodes", new CachedContent<NodeInformationList>(500L, new LiveNodesRefresher(state)));
        cache.put("/model/desired", new CachedContent<AggregateConf>(500L, new AggregateModelRefresher(state, false)));
        cache.put("/model/resolved", new CachedContent<AggregateConf>(500L, new AggregateModelRefresher(state, true)));
        cache.put("/model/resolved/appconf", new CachedContent<ConfTree>(500L, new AppconfRefresher(state, false, false)));
        cache.put("/model/resolved/resources", new CachedContent<ConfTree>(500L, new AppconfRefresher(state, false, true)));
        cache.put("/model/desired/appconf", new CachedContent<ConfTree>(500L, new AppconfRefresher(state, true, false)));
        cache.put("/model/desired/resources", new CachedContent<ConfTree>(500L, new AppconfRefresher(state, true, true)));
        cache.put("/live/statistics", new CachedContent<Map<String, Integer>>(500L, new LiveStatisticsRefresher(state)));
        return cache;
    }
}

