/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.slider.server.appmaster.actions.ActionStopQueue;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.actions.RenewingAction;
import org.apache.slider.server.services.workflow.ServiceThreadFactory;
import org.apache.slider.server.services.workflow.WorkflowExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueService
extends WorkflowExecutorService<ExecutorService>
implements Runnable,
QueueAccess {
    private static final Logger log = LoggerFactory.getLogger(QueueService.class);
    public static final String NAME = "Action Queue";
    private final AtomicBoolean completed = new AtomicBoolean(false);
    public final BlockingDeque<AsyncAction> actionQueue = new LinkedBlockingDeque<AsyncAction>();
    public final DelayQueue<AsyncAction> scheduledActions = new DelayQueue();
    private final Map<String, RenewingAction<? extends AsyncAction>> renewingActions = new ConcurrentHashMap<String, RenewingAction<? extends AsyncAction>>();

    public QueueService() {
        super(NAME, ServiceThreadFactory.singleThreadExecutor(NAME, true));
    }

    @Override
    public void put(AsyncAction action) {
        log.debug("Queueing {}", (Object)action);
        this.actionQueue.add(action);
    }

    @Override
    public void schedule(AsyncAction action) {
        log.debug("Scheduling {}", (Object)action);
        this.scheduledActions.add(action);
    }

    @Override
    public boolean remove(AsyncAction action) {
        boolean removedFromDelayQueue = this.scheduledActions.remove(action);
        boolean removedFromActions = this.actionQueue.remove(action);
        return removedFromActions || removedFromDelayQueue;
    }

    @Override
    public void renewing(String name, RenewingAction<? extends AsyncAction> renewingAction) {
        log.debug("Adding renewing Action \"{}\": {}", (Object)name, (Object)renewingAction.getAction());
        if (this.removeRenewingAction(name)) {
            log.debug("Removed predecessor action");
        }
        this.renewingActions.put(name, renewingAction);
        this.schedule(renewingAction);
    }

    @Override
    public RenewingAction<? extends AsyncAction> lookupRenewingAction(String name) {
        return this.renewingActions.get(name);
    }

    @Override
    public boolean removeRenewingAction(String name) {
        RenewingAction<? extends AsyncAction> action = this.renewingActions.remove(name);
        return action != null && this.remove(action);
    }

    @Override
    protected void serviceStop() throws Exception {
        ActionStopQueue stopQueue = new ActionStopQueue("serviceStop: " + this, 0L, TimeUnit.MILLISECONDS);
        this.schedule(stopQueue);
        super.serviceStop();
    }

    protected void flushActionQueue(Class<? extends AsyncAction> clazz) {
        Iterator iterator = this.actionQueue.descendingIterator();
        while (iterator.hasNext()) {
            AsyncAction next = (AsyncAction)iterator.next();
            if (!next.getClass().equals(clazz)) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean hasQueuedActionWithAttribute(int attr) {
        for (AsyncAction action : this.actionQueue) {
            if (!action.hasAttr(attr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            AsyncAction take;
            log.info("QueueService processor started");
            do {
                take = (AsyncAction)this.scheduledActions.take();
                log.debug("Propagating {}", (Object)take);
                this.actionQueue.put(take);
            } while (!(take instanceof ActionStopQueue));
            log.info("QueueService processor terminated");
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    void complete() {
        this.completed.set(true);
    }
}

