/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.api;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.slider.api.proto.Messages;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class ClusterNode
implements Cloneable {
    protected static final Logger LOG = LoggerFactory.getLogger(ClusterNode.class);
    @JsonIgnore
    public ContainerId containerId;
    public String name;
    public String id;
    public String role;
    public int roleId;
    public long createTime;
    public long startTime;
    public boolean released;
    public String host;
    public String hostUrl;
    public int state;
    public int exitCode;
    public String command;
    public String diagnostics;
    public String[] output;
    public String[] environment;

    public ClusterNode(ContainerId containerId) {
        if (containerId != null) {
            this.containerId = containerId;
            this.name = containerId.toString();
        }
    }

    public ClusterNode() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(": ");
        builder.append(this.state).append("\n");
        builder.append("state: ").append(this.state).append("\n");
        builder.append("role: ").append(this.role).append("\n");
        this.append(builder, "host", this.host);
        this.append(builder, "hostURL", this.hostUrl);
        this.append(builder, "command", this.command);
        if (this.output != null) {
            String[] stringArray = this.output;
            int n = this.output.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                builder.append(line).append("\n");
                ++n2;
            }
        }
        this.append(builder, "diagnostics", this.diagnostics);
        return builder.toString();
    }

    private void append(StringBuilder builder, String name, Object val) {
        if (val != null) {
            builder.append(name).append(val.toString()).append("\n");
        }
    }

    public String toJsonString() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static ClusterNode fromJson(String json) throws IOException, JsonParseException, JsonMappingException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ClusterNode)mapper.readValue(json, ClusterNode.class);
        }
        catch (IOException e) {
            LOG.error("Exception while parsing json : {}\n{}", e, json, e);
            throw e;
        }
    }

    public static ClusterNode fromProtobuf(Messages.RoleInstanceState message) {
        String[] arr;
        ClusterNode node = new ClusterNode();
        node.name = message.getName();
        node.command = message.getCommand();
        node.diagnostics = message.getDiagnostics();
        int environmentCount = message.getEnvironmentCount();
        if (environmentCount > 0) {
            arr = new String[environmentCount];
            node.environment = message.getEnvironmentList().toArray(arr);
        }
        node.exitCode = message.getExitCode();
        int outputCount = message.getOutputCount();
        if (outputCount > 0) {
            arr = new String[outputCount];
            node.output = message.getOutputList().toArray(arr);
        }
        node.role = message.getRole();
        node.roleId = message.getRoleId();
        node.state = message.getState();
        node.host = message.getHost();
        node.hostUrl = message.getHostURL();
        node.createTime = message.getCreateTime();
        node.startTime = message.getStartTime();
        node.released = message.getReleased();
        return node;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ClusterNode doClone() {
        try {
            return (ClusterNode)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

