/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.LlapStatusOptionsProcessor;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.registry.ServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.client.SliderClient;
import org.apache.slider.core.exceptions.SliderException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapStatusServiceDriver {
    private static final Logger LOG = LoggerFactory.getLogger(LlapStatusServiceDriver.class);
    private static final String CONF_PREFIX = "hive.llapcli.";
    @InterfaceAudience.Private
    private static final String CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS = "hive.llapcli.yarn.rm.connect.max-wait-ms";
    private static final long CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS_DEFAULT = 10000L;
    @InterfaceAudience.Private
    private static final String CONFIG_YARN_RM_RETRY_INTERVAL_MS = "hive.llapcli.yarn.rm.connect.retry-interval.ms";
    private static final long CONFIG_YARN_RM_RETRY_INTERVAL_MS_DEFAULT = 5000L;
    @InterfaceAudience.Private
    private static final String CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES = "hive.llapcli.ipc.client.max-retries";
    private static final int CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES_DEFAULT = 2;
    @InterfaceAudience.Private
    private static final String CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS = "hive.llapcli.ipc.client.connect.retry-interval-ms";
    private static final long CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS_DEFAULT = 1500L;
    @InterfaceAudience.Private
    private static final String CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC = "hive.llapcli.timeline.service.fs-store.retry.policy.spec";
    private static final String CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC_DEFAULT = "2000, 1";
    private static final String CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS = "hive.llapcli.zk-registry.timeout-ms";
    private static final long CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS_DEFAULT = 10000L;
    private static final String AM_KEY = "slider-appmaster";
    private static final String LLAP_KEY = "LLAP";
    private final Configuration conf;
    private final Clock clock = new SystemClock();
    @VisibleForTesting
    final AppStatusBuilder appStatusBuilder = new AppStatusBuilder();

    public LlapStatusServiceDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new HiveConf(SessionState.class);
    }

    public LlapStatusOptionsProcessor.LlapStatusOptions parseOptions(String[] args) throws LlapStatusCliException {
        LlapStatusOptionsProcessor optionsProcessor = new LlapStatusOptionsProcessor();
        try {
            LlapStatusOptionsProcessor.LlapStatusOptions options = optionsProcessor.processOptions(args);
            return options;
        }
        catch (Exception e) {
            LOG.info("Failed to parse arguments", e);
            throw new LlapStatusCliException(ExitCode.INCORRECT_USAGE, "Incorrect usage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(LlapStatusOptionsProcessor.LlapStatusOptions options) {
        SliderClient sliderClient = null;
        try {
            ExitCode ret;
            ApplicationReport applicationReport;
            int n;
            for (String f : LlapDaemonConfiguration.DAEMON_CONFIGS) {
                this.conf.addResource(f);
            }
            this.conf.reloadConfiguration();
            for (Map.Entry entry : options.getConf().entrySet()) {
                this.conf.set((String)entry.getKey(), (String)entry.getValue());
            }
            this.conf.set("yarn.timeline-service.entity-group-fs-store.retry-policy-spec", this.conf.get(CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC, CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC_DEFAULT));
            this.conf.setLong("yarn.resourcemanager.connect.max-wait.ms", this.conf.getLong(CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS, 10000L));
            this.conf.setLong("yarn.resourcemanager.connect.retry-interval.ms", this.conf.getLong(CONFIG_YARN_RM_RETRY_INTERVAL_MS, 5000L));
            this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt(CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES, 2));
            this.conf.setLong("ipc.client.connect.retry.interval", this.conf.getLong(CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS, 1500L));
            HiveConf.setVar(this.conf, HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, this.conf.getLong(CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS, 10000L) + "ms");
            String appName = options.getName();
            if (StringUtils.isEmpty(appName)) {
                appName = HiveConf.getVar(this.conf, HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
                appName = appName.startsWith("@") && appName.length() > 1 ? appName.substring(1) : null;
            }
            if (StringUtils.isEmpty(appName)) {
                String string = "Invalid app name. This must be setup via config or passed in as a parameter. This tool works with clusters deployed by Slider/YARN";
                LOG.info(string);
                n = ExitCode.INCORRECT_USAGE.getInt();
                return n;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using appName: {}", (Object)appName);
            }
            try {
                sliderClient = this.createSliderClient();
            }
            catch (LlapStatusCliException llapStatusCliException) {
                LlapStatusServiceDriver.logError(llapStatusCliException);
                n = llapStatusCliException.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                if (sliderClient != null) {
                    sliderClient.stop();
                }
                return n;
            }
            Object var4_8 = null;
            try {
                applicationReport = this.getAppReport(appName, sliderClient, options.getFindAppTimeoutMs());
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int f = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                if (sliderClient != null) {
                    sliderClient.stop();
                }
                return f;
            }
            try {
                ret = this.processAppReport(applicationReport, this.appStatusBuilder);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n3 = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                if (sliderClient != null) {
                    sliderClient.stop();
                }
                return n3;
            }
            if (ret != ExitCode.SUCCESS) {
                int e = ret.getInt();
                return e;
            }
            if (EnumSet.of(State.APP_NOT_FOUND, State.COMPLETE, State.LAUNCHING).contains((Object)this.appStatusBuilder.getState())) {
                int e = ExitCode.SUCCESS.getInt();
                return e;
            }
            try {
                ret = this.populateAppStatusFromSlider(appName, sliderClient, this.appStatusBuilder);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n4 = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                if (sliderClient != null) {
                    sliderClient.stop();
                }
                return n4;
            }
            if (ret != ExitCode.SUCCESS) {
                int e = ret.getInt();
                return e;
            }
            try {
                ret = this.populateAppStatusFromLlapRegistry(appName, this.appStatusBuilder);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n2 = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                if (sliderClient != null) {
                    sliderClient.stop();
                }
                return n2;
            }
            int n3 = ret.getInt();
            return n3;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
            }
            if (sliderClient != null) {
                sliderClient.stop();
            }
        }
    }

    public void outputJson(PrintWriter writer) throws LlapStatusCliException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        try {
            writer.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.appStatusBuilder));
        }
        catch (IOException e) {
            LOG.warn("Failed to create JSON", e);
            throw new LlapStatusCliException(ExitCode.LLAP_JSON_GENERATION_ERROR, "Failed to create JSON", e);
        }
    }

    private SliderClient createSliderClient() throws LlapStatusCliException {
        try {
            SliderClient sliderClient = new SliderClient(){

                @Override
                public void serviceInit(Configuration conf) throws Exception {
                    super.serviceInit(conf);
                    this.initHadoopBinding();
                }
            };
            Configuration sliderClientConf = new Configuration(this.conf);
            sliderClientConf = sliderClient.bindArgs(sliderClientConf, "help");
            sliderClient.init(sliderClientConf);
            sliderClient.start();
            return sliderClient;
        }
        catch (Exception e) {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_CREATE_FAILED, "Failed to create slider client", e);
        }
    }

    private ApplicationReport getAppReport(String appName, SliderClient sliderClient, long timeoutMs) throws LlapStatusCliException {
        long startTime = this.clock.getTime();
        long timeoutTime = timeoutMs < 0L ? Long.MAX_VALUE : startTime + timeoutMs;
        ApplicationReport appReport = null;
        while (appReport == null) {
            try {
                appReport = sliderClient.getYarnAppListClient().findInstance(appName);
                if (timeoutMs == 0L) break;
                if (appReport != null) continue;
                long remainingTime = Math.min(timeoutTime - this.clock.getTime(), 500L);
                if (remainingTime <= 0L) break;
                Thread.sleep(remainingTime);
            }
            catch (Exception e) {
                throw new LlapStatusCliException(ExitCode.YARN_ERROR, "Failed to get Yarn AppReport", e);
            }
        }
        return appReport;
    }

    private ExitCode processAppReport(ApplicationReport appReport, AppStatusBuilder appStatusBuilder) throws LlapStatusCliException {
        if (appReport == null) {
            appStatusBuilder.setState(State.APP_NOT_FOUND);
            LOG.info("No Application Found");
            return ExitCode.SUCCESS;
        }
        appStatusBuilder.setAmInfo(new AmInfo().setAppName(appReport.getName()).setAppType(appReport.getApplicationType()));
        appStatusBuilder.setAppStartTime(appReport.getStartTime());
        switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: {
                appStatusBuilder.setState(State.LAUNCHING);
                return ExitCode.SUCCESS;
            }
            case ACCEPTED: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                appStatusBuilder.setState(State.LAUNCHING);
                return ExitCode.SUCCESS;
            }
            case RUNNING: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                return ExitCode.SUCCESS;
            }
            case FINISHED: 
            case FAILED: 
            case KILLED: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                appStatusBuilder.setAppFinishTime(appReport.getFinishTime());
                appStatusBuilder.setState(State.COMPLETE);
                return ExitCode.SUCCESS;
            }
        }
        throw new LlapStatusCliException(ExitCode.INTERNAL_ERROR, "Unknown Yarn Application State: " + appReport.getYarnApplicationState());
    }

    private ExitCode populateAppStatusFromSlider(String appName, SliderClient sliderClient, AppStatusBuilder appStatusBuilder) throws LlapStatusCliException {
        Map liveEntity;
        Map llapEntity;
        Object liveObject;
        Map<String, Integer> llapStats;
        ClusterDescription clusterDescription;
        try {
            clusterDescription = sliderClient.getClusterDescription(appName);
        }
        catch (SliderException e) {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get cluster description from slider. SliderErrorCode=" + e.getExitCode(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get cluster description from slider", e);
        }
        if (clusterDescription == null) {
            LOG.info("Slider ClusterDescription not available");
            return ExitCode.SLIDER_CLIENT_ERROR_OTHER;
        }
        appStatusBuilder.setOriginalConfigurationPath(clusterDescription.originConfigurationPath);
        appStatusBuilder.setGeneratedConfigurationPath(clusterDescription.generatedConfigurationPath);
        appStatusBuilder.setAppStartTime(clusterDescription.createTime);
        appStatusBuilder.maybeCreateAndGetAmInfo().setAmWebUrl(clusterDescription.getInfo("info.am.web.url"));
        appStatusBuilder.maybeCreateAndGetAmInfo().setHostname(clusterDescription.getInfo("info.am.hostname"));
        appStatusBuilder.maybeCreateAndGetAmInfo().setContainerId(clusterDescription.getInfo("info.am.container.id"));
        if (clusterDescription.statistics != null) {
            llapStats = clusterDescription.statistics.get(LLAP_KEY);
            if (llapStats == null) {
                throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get statistics for LLAP");
            }
        } else {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get statistics");
        }
        int desiredContainers = llapStats.get("containers.desired");
        int liveContainers = llapStats.get("containers.live");
        appStatusBuilder.setDesiredInstances(desiredContainers);
        appStatusBuilder.setLiveInstances(liveContainers);
        if (clusterDescription.status != null && (liveObject = clusterDescription.status.get("live")) != null && (llapEntity = (Map)(liveEntity = (Map)liveObject).get(LLAP_KEY)) != null) {
            for (Map.Entry containerEntry : llapEntity.entrySet()) {
                String containerIdString = (String)containerEntry.getKey();
                Map containerParams = (Map)containerEntry.getValue();
                String host = (String)containerParams.get("host");
                LlapInstance llapInstance = new LlapInstance(host, containerIdString);
                appStatusBuilder.addNewLlapInstance(llapInstance);
            }
        }
        return ExitCode.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExitCode populateAppStatusFromLlapRegistry(String appName, AppStatusBuilder appStatusBuilder) throws LlapStatusCliException {
        LlapRegistryService llapRegistry;
        Configuration llapRegistryConf = new Configuration(this.conf);
        llapRegistryConf.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + appName);
        try {
            llapRegistry = LlapRegistryService.getClient(llapRegistryConf);
        }
        catch (Exception e) {
            throw new LlapStatusCliException(ExitCode.LLAP_REGISTRY_ERROR, "Failed to create llap registry client", e);
        }
        try {
            Map<String, ServiceInstance> serviceInstanceMap;
            try {
                serviceInstanceMap = llapRegistry.getInstances().getAll();
            }
            catch (IOException e) {
                throw new LlapStatusCliException(ExitCode.LLAP_REGISTRY_ERROR, "Failed to get instances from llap registry", e);
            }
            if (serviceInstanceMap == null || serviceInstanceMap.isEmpty()) {
                LOG.info("No information found in the LLAP registry");
                appStatusBuilder.setLiveInstances(0);
                appStatusBuilder.setState(State.LAUNCHING);
                appStatusBuilder.clearLlapInstances();
                ExitCode e = ExitCode.SUCCESS;
                return e;
            }
            LinkedList<LlapInstance> validatedInstances = new LinkedList<LlapInstance>();
            LinkedList<String> llapExtraInstances = new LinkedList<String>();
            for (Map.Entry<String, ServiceInstance> serviceInstanceEntry : serviceInstanceMap.entrySet()) {
                ServiceInstance serviceInstance = serviceInstanceEntry.getValue();
                String containerIdString = serviceInstance.getProperties().get(HiveConf.ConfVars.LLAP_DAEMON_CONTAINER_ID.varname);
                LlapInstance llapInstance = appStatusBuilder.removeAndgetLlapInstanceForContainer(containerIdString);
                if (llapInstance != null) {
                    llapInstance.setMgmtPort(serviceInstance.getManagementPort());
                    llapInstance.setRpcPort(serviceInstance.getRpcPort());
                    llapInstance.setShufflePort(serviceInstance.getShufflePort());
                    llapInstance.setWebUrl(serviceInstance.getServicesAddress());
                    llapInstance.setStatusUrl(serviceInstance.getServicesAddress() + "/status");
                    validatedInstances.add(llapInstance);
                    continue;
                }
                llapExtraInstances.add(containerIdString);
            }
            appStatusBuilder.setLiveInstances(validatedInstances.size());
            if (validatedInstances.size() >= appStatusBuilder.getDesiredInstances()) {
                appStatusBuilder.setState(State.RUNNING_ALL);
                if (validatedInstances.size() > appStatusBuilder.getDesiredInstances()) {
                    LOG.warn("Found more entries in LLAP registry, as compared to desired entries");
                }
            } else {
                appStatusBuilder.setState(State.RUNNING_PARTIAL);
            }
            if (appStatusBuilder.allInstances().size() > 0) {
                LOG.debug("Potential instances starting up: {}", (Object)appStatusBuilder.allInstances());
            }
            if (llapExtraInstances.size() > 0) {
                LOG.debug("Instances likely to shutdown soon: {}", (Object)llapExtraInstances);
            }
            appStatusBuilder.clearAndAddPreviouslyKnownInstances(validatedInstances);
            ExitCode exitCode = ExitCode.SUCCESS;
            return exitCode;
        }
        finally {
            llapRegistry.stop();
        }
    }

    private static void logError(Throwable t) {
        LOG.error("FAILED: " + t.getMessage(), t);
        System.err.println("FAILED: " + t.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int ret;
        block36: {
            Throwable ce;
            LOG.info("LLAP status invoked with arguments = {}", args);
            ret = ExitCode.SUCCESS.getInt();
            LlapStatusServiceDriver statusServiceDriver = null;
            LlapStatusOptionsProcessor.LlapStatusOptions options = null;
            try {
                statusServiceDriver = new LlapStatusServiceDriver();
                options = statusServiceDriver.parseOptions(args);
            }
            catch (Throwable t) {
                LlapStatusServiceDriver.logError(t);
                if (t instanceof LlapStatusCliException) {
                    ce = (LlapStatusCliException)t;
                    ret = ((LlapStatusCliException)ce).getExitCode().getInt();
                }
                ret = ExitCode.INTERNAL_ERROR.getInt();
            }
            if (ret != 0 || options == null) {
                System.exit(ret);
            }
            try {
                ret = statusServiceDriver.run(options);
                if (ret != ExitCode.SUCCESS.getInt()) break block36;
                ce = null;
                try (FilterOutputStream os = options.getOutputFile() == null ? System.out : new BufferedOutputStream(new FileOutputStream(options.getOutputFile()));
                     PrintWriter pw = new PrintWriter(os);){
                    statusServiceDriver.outputJson(pw);
                }
                catch (Throwable throwable) {
                    ce = throwable;
                    throw throwable;
                }
            }
            catch (Throwable t) {
                LlapStatusServiceDriver.logError(t);
                if (t instanceof LlapStatusCliException) {
                    ce = (LlapStatusCliException)t;
                    ret = ((LlapStatusCliException)ce).getExitCode().getInt();
                } else {
                    ret = ExitCode.INTERNAL_ERROR.getInt();
                }
            }
            finally {
                LOG.info("LLAP status finished");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed processing - exiting with " + ret);
        }
        System.exit(ret);
    }

    public static enum ExitCode {
        SUCCESS(0),
        INCORRECT_USAGE(10),
        YARN_ERROR(20),
        SLIDER_CLIENT_ERROR_CREATE_FAILED(30),
        SLIDER_CLIENT_ERROR_OTHER(31),
        LLAP_REGISTRY_ERROR(40),
        LLAP_JSON_GENERATION_ERROR(50),
        INTERNAL_ERROR(100);

        private final int exitCode;

        private ExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getInt() {
            return this.exitCode;
        }
    }

    static enum State {
        APP_NOT_FOUND,
        LAUNCHING,
        RUNNING_PARTIAL,
        RUNNING_ALL,
        COMPLETE,
        UNKNOWN;

    }

    static class LlapStatusCliException
    extends Exception {
        final ExitCode exitCode;

        public LlapStatusCliException(ExitCode exitCode, String message) {
            super(exitCode.getInt() + ": " + message);
            this.exitCode = exitCode;
        }

        public LlapStatusCliException(ExitCode exitCode, String message, Throwable cause) {
            super(message, cause);
            this.exitCode = exitCode;
        }

        public ExitCode getExitCode() {
            return this.exitCode;
        }
    }

    static class LlapInstance {
        private final String hostname;
        private final String containerId;
        private String statusUrl;
        private String webUrl;
        private Integer rpcPort;
        private Integer mgmtPort;
        private Integer shufflePort;

        public LlapInstance(String hostname, String containerId) {
            this.hostname = hostname;
            this.containerId = containerId;
        }

        public LlapInstance setWebUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public LlapInstance setStatusUrl(String statusUrl) {
            this.statusUrl = statusUrl;
            return this;
        }

        public LlapInstance setRpcPort(int rpcPort) {
            this.rpcPort = rpcPort;
            return this;
        }

        public LlapInstance setMgmtPort(int mgmtPort) {
            this.mgmtPort = mgmtPort;
            return this;
        }

        public LlapInstance setShufflePort(int shufflePort) {
            this.shufflePort = shufflePort;
            return this;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getStatusUrl() {
            return this.statusUrl;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public Integer getRpcPort() {
            return this.rpcPort;
        }

        public Integer getMgmtPort() {
            return this.mgmtPort;
        }

        public Integer getShufflePort() {
            return this.shufflePort;
        }

        public String toString() {
            return "LlapInstance{hostname='" + this.hostname + '\'' + ", containerId='" + this.containerId + '\'' + ", statusUrl='" + this.statusUrl + '\'' + ", webUrl='" + this.webUrl + '\'' + ", rpcPort=" + this.rpcPort + ", mgmtPort=" + this.mgmtPort + ", shufflePort=" + this.shufflePort + '}';
        }
    }

    static class AmInfo {
        private String appName;
        private String appType;
        private String appId;
        private String containerId;
        private String hostname;
        private String amWebUrl;

        AmInfo() {
        }

        public AmInfo setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public AmInfo setAppType(String appType) {
            this.appType = appType;
            return this;
        }

        public AmInfo setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public AmInfo setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public AmInfo setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public AmInfo setAmWebUrl(String amWebUrl) {
            this.amWebUrl = amWebUrl;
            return this;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppType() {
            return this.appType;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getAmWebUrl() {
            return this.amWebUrl;
        }

        public String toString() {
            return "AmInfo{appName='" + this.appName + '\'' + ", appType='" + this.appType + '\'' + ", appId='" + this.appId + '\'' + ", containerId='" + this.containerId + '\'' + ", hostname='" + this.hostname + '\'' + ", amWebUrl='" + this.amWebUrl + '\'' + '}';
        }
    }

    static final class AppStatusBuilder {
        private AmInfo amInfo;
        private State state = State.UNKNOWN;
        private String originalConfigurationPath;
        private String generatedConfigurationPath;
        private Integer desiredInstances;
        private Integer liveInstances;
        private Long appStartTime;
        private Long appFinishTime;
        private final List<LlapInstance> llapInstances = new LinkedList<LlapInstance>();
        private transient Map<String, LlapInstance> containerToInstanceMap = new HashMap<String, LlapInstance>();

        AppStatusBuilder() {
        }

        public void setAmInfo(AmInfo amInfo) {
            this.amInfo = amInfo;
        }

        public AppStatusBuilder setState(State state) {
            this.state = state;
            return this;
        }

        public AppStatusBuilder setOriginalConfigurationPath(String originalConfigurationPath) {
            this.originalConfigurationPath = originalConfigurationPath;
            return this;
        }

        public AppStatusBuilder setGeneratedConfigurationPath(String generatedConfigurationPath) {
            this.generatedConfigurationPath = generatedConfigurationPath;
            return this;
        }

        public AppStatusBuilder setAppStartTime(long appStartTime) {
            this.appStartTime = appStartTime;
            return this;
        }

        public AppStatusBuilder setAppFinishTime(long finishTime) {
            this.appFinishTime = finishTime;
            return this;
        }

        public AppStatusBuilder setDesiredInstances(int desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public AppStatusBuilder setLiveInstances(int liveInstances) {
            this.liveInstances = liveInstances;
            return this;
        }

        public AppStatusBuilder addNewLlapInstance(LlapInstance llapInstance) {
            this.llapInstances.add(llapInstance);
            this.containerToInstanceMap.put(llapInstance.getContainerId(), llapInstance);
            return this;
        }

        public LlapInstance removeAndgetLlapInstanceForContainer(String containerIdString) {
            return this.containerToInstanceMap.remove(containerIdString);
        }

        public void clearLlapInstances() {
            this.llapInstances.clear();
            this.containerToInstanceMap.clear();
        }

        public AppStatusBuilder clearAndAddPreviouslyKnownInstances(List<LlapInstance> llapInstances) {
            this.clearLlapInstances();
            for (LlapInstance llapInstance : llapInstances) {
                this.addNewLlapInstance(llapInstance);
            }
            return this;
        }

        @JsonIgnore
        public List<LlapInstance> allInstances() {
            return this.llapInstances;
        }

        public AmInfo getAmInfo() {
            return this.amInfo;
        }

        public State getState() {
            return this.state;
        }

        public String getOriginalConfigurationPath() {
            return this.originalConfigurationPath;
        }

        public String getGeneratedConfigurationPath() {
            return this.generatedConfigurationPath;
        }

        public Integer getDesiredInstances() {
            return this.desiredInstances;
        }

        public Integer getLiveInstances() {
            return this.liveInstances;
        }

        public Long getAppStartTime() {
            return this.appStartTime;
        }

        public Long getAppFinishTime() {
            return this.appFinishTime;
        }

        public List<LlapInstance> getLlapInstances() {
            return this.llapInstances;
        }

        @JsonIgnore
        public AmInfo maybeCreateAndGetAmInfo() {
            if (this.amInfo == null) {
                this.amInfo = new AmInfo();
            }
            return this.amInfo;
        }

        public String toString() {
            return "AppStatusBuilder{amInfo=" + this.amInfo + ", state=" + (Object)((Object)this.state) + ", originalConfigurationPath='" + this.originalConfigurationPath + '\'' + ", generatedConfigurationPath='" + this.generatedConfigurationPath + '\'' + ", desiredInstances=" + this.desiredInstances + ", liveInstances=" + this.liveInstances + ", appStartTime=" + this.appStartTime + ", appFinishTime=" + this.appFinishTime + ", llapInstances=" + this.llapInstances + ", containerToInstanceMap=" + this.containerToInstanceMap + '}';
        }
    }
}

