/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.datanucleus.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;

public class NucleusException
extends RuntimeException {
    Throwable[] nested;
    Object failed;
    boolean fatal;

    public NucleusException() {
    }

    public NucleusException(String msg) {
        super(msg);
    }

    public NucleusException(String msg, Throwable[] nested) {
        super(msg);
        this.nested = nested;
    }

    public NucleusException(String msg, Throwable nested) {
        super(msg);
        this.nested = new Throwable[]{nested};
    }

    public NucleusException(String msg, Object failed) {
        super(msg);
        this.failed = failed;
    }

    public NucleusException(String msg, Throwable[] nested, Object failed) {
        super(msg);
        this.nested = nested;
        this.failed = failed;
    }

    public NucleusException(String msg, Throwable nested, Object failed) {
        super(msg);
        this.nested = new Throwable[]{nested};
        this.failed = failed;
    }

    public NucleusException setFatal() {
        this.fatal = true;
        return this;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public Object getFailedObject() {
        return this.failed;
    }

    public void setNestedException(Throwable nested) {
        this.nested = new Throwable[]{nested};
    }

    public Throwable[] getNestedExceptions() {
        return this.nested;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.nested == null || this.nested.length == 0 ? null : this.nested[0];
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void printStackTrace(PrintStream s) {
        int len = this.nested == null ? 0 : this.nested.length;
        PrintStream printStream = s;
        synchronized (printStream) {
            if (this.getMessage() != null) {
                s.println(this.getMessage());
            }
            super.printStackTrace(s);
            if (len > 0) {
                s.println("Nested Throwables StackTrace:");
                for (int i = 0; i < len; ++i) {
                    Throwable exception = this.nested[i];
                    if (exception == null) continue;
                    exception.printStackTrace(s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void printStackTrace(PrintWriter s) {
        int len = this.nested == null ? 0 : this.nested.length;
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            if (this.getMessage() != null) {
                s.println(this.getMessage());
            }
            super.printStackTrace(s);
            if (len > 0) {
                s.println("Nested Throwables StackTrace:");
                for (int i = 0; i < len; ++i) {
                    Throwable exception = this.nested[i];
                    if (exception == null) continue;
                    exception.printStackTrace(s);
                }
            }
        }
    }
}

