/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hive.service.cli.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark-project.org.apache.hive.service.cli.HiveSQLException;
import org.apache.spark-project.org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark-project.org.apache.hive.service.cli.session.HiveSessionBase;

public class HiveSessionProxy
implements InvocationHandler {
    private final HiveSession base;
    private final UserGroupInformation ugi;

    public HiveSessionProxy(HiveSession hiveSession, UserGroupInformation ugi) {
        this.base = hiveSession;
        this.ugi = ugi;
    }

    public static HiveSession getProxy(HiveSession hiveSession, UserGroupInformation ugi) throws IllegalArgumentException, HiveSQLException {
        return (HiveSession)Proxy.newProxyInstance(HiveSession.class.getClassLoader(), new Class[]{HiveSession.class}, (InvocationHandler)new HiveSessionProxy(hiveSession, ugi));
    }

    @Override
    public Object invoke(Object arg0, final Method method, final Object[] args) throws Throwable {
        try {
            if (method.getDeclaringClass() == HiveSessionBase.class) {
                return this.invoke(method, args);
            }
            return this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws HiveSQLException {
                    return HiveSessionProxy.this.invoke(method, args);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            Throwable innerException = e.getCause();
            if (innerException instanceof PrivilegedActionException) {
                throw innerException.getCause();
            }
            throw e.getCause();
        }
    }

    private Object invoke(Method method, Object[] args) throws HiveSQLException {
        try {
            return method.invoke((Object)this.base, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof HiveSQLException) {
                throw (HiveSQLException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

