/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.ColumnarStructObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.ProtocolBuffersStructObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.ReflectionStructObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.ThriftStructObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.ThriftUnionObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.spark-project.org.apache.thrift.TUnion;

public final class ObjectInspectorFactory {
    private static ConcurrentHashMap<Type, ObjectInspector> objectInspectorCache = new ConcurrentHashMap();
    static ConcurrentHashMap<ObjectInspector, StandardListObjectInspector> cachedStandardListObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<ObjectInspector>, StandardMapObjectInspector> cachedStandardMapObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<ObjectInspector>, StandardUnionObjectInspector> cachedStandardUnionObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<List<?>>, StandardStructObjectInspector> cachedStandardStructObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<StructObjectInspector>, UnionStructObjectInspector> cachedUnionStructObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<Object>, ColumnarStructObjectInspector> cachedColumnarStructObjectInspector = new ConcurrentHashMap();

    public static ObjectInspector getReflectionObjectInspector(Type t, ObjectInspectorOptions options) {
        ObjectInspector oi = objectInspectorCache.get(t);
        if (oi == null) {
            oi = ObjectInspectorFactory.getReflectionObjectInspectorNoCache(t, options);
            objectInspectorCache.put(t, oi);
        }
        ObjectInspectorFactory.verifyObjectInspector(options, oi, ObjectInspectorOptions.JAVA, new Class[]{ThriftStructObjectInspector.class, ProtocolBuffersStructObjectInspector.class});
        ObjectInspectorFactory.verifyObjectInspector(options, oi, ObjectInspectorOptions.THRIFT, new Class[]{ReflectionStructObjectInspector.class, ProtocolBuffersStructObjectInspector.class});
        ObjectInspectorFactory.verifyObjectInspector(options, oi, ObjectInspectorOptions.PROTOCOL_BUFFERS, new Class[]{ThriftStructObjectInspector.class, ReflectionStructObjectInspector.class});
        return oi;
    }

    private static void verifyObjectInspector(ObjectInspectorOptions option, ObjectInspector oi, ObjectInspectorOptions checkOption, Class[] classes) {
        if (option.equals((Object)checkOption)) {
            for (Class checkClass : classes) {
                if (!oi.getClass().equals(checkClass)) continue;
                throw new RuntimeException("Cannot call getObjectInspectorByReflection with more then one of " + Arrays.toString((Object[])ObjectInspectorOptions.values()) + "!");
            }
        }
    }

    private static ObjectInspector getReflectionObjectInspectorNoCache(Type t, ObjectInspectorOptions options) {
        ReflectionStructObjectInspector oi;
        if (t instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)t;
            return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(at.getGenericComponentType(), options));
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (List.class.isAssignableFrom((Class)pt.getRawType()) || Set.class.isAssignableFrom((Class)pt.getRawType())) {
                return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[0], options));
            }
            if (Map.class.isAssignableFrom((Class)pt.getRawType())) {
                return ObjectInspectorFactory.getStandardMapObjectInspector(ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[0], options), ObjectInspectorFactory.getReflectionObjectInspector(pt.getActualTypeArguments()[1], options));
            }
            t = pt.getRawType();
        }
        if (!(t instanceof Class)) {
            throw new RuntimeException(ObjectInspectorFactory.class.getName() + " internal error:" + t);
        }
        Class c = (Class)t;
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaType(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaType(c).primitiveCategory);
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaClass(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaClass(c).primitiveCategory);
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveWritableClass(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveWritableClass(c).primitiveCategory);
        }
        if (Enum.class.isAssignableFrom(c)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
        assert (!List.class.isAssignableFrom(c));
        assert (!Map.class.isAssignableFrom(c));
        switch (options) {
            case JAVA: {
                oi = new ReflectionStructObjectInspector();
                break;
            }
            case THRIFT: {
                oi = TUnion.class.isAssignableFrom(c) ? new ThriftUnionObjectInspector() : new ThriftStructObjectInspector();
                break;
            }
            case PROTOCOL_BUFFERS: {
                oi = new ProtocolBuffersStructObjectInspector();
                break;
            }
            default: {
                throw new RuntimeException(ObjectInspectorFactory.class.getName() + ": internal error.");
            }
        }
        objectInspectorCache.put(t, oi);
        oi.init(c, options);
        return oi;
    }

    public static StandardListObjectInspector getStandardListObjectInspector(ObjectInspector listElementObjectInspector) {
        StandardListObjectInspector prev;
        StandardListObjectInspector result = cachedStandardListObjectInspector.get(listElementObjectInspector);
        if (result == null && (prev = cachedStandardListObjectInspector.putIfAbsent(listElementObjectInspector, result = new StandardListObjectInspector(listElementObjectInspector))) != null) {
            result = prev;
        }
        return result;
    }

    public static StandardConstantListObjectInspector getStandardConstantListObjectInspector(ObjectInspector listElementObjectInspector, List<?> constantValue) {
        return new StandardConstantListObjectInspector(listElementObjectInspector, constantValue);
    }

    public static StandardMapObjectInspector getStandardMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        StandardMapObjectInspector prev;
        ArrayList<ObjectInspector> signature = new ArrayList<ObjectInspector>(2);
        signature.add(mapKeyObjectInspector);
        signature.add(mapValueObjectInspector);
        StandardMapObjectInspector result = cachedStandardMapObjectInspector.get(signature);
        if (result == null && (prev = cachedStandardMapObjectInspector.putIfAbsent(signature, result = new StandardMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector))) != null) {
            result = prev;
        }
        return result;
    }

    public static StandardConstantMapObjectInspector getStandardConstantMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, Map<?, ?> constantValue) {
        return new StandardConstantMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector, constantValue);
    }

    public static StandardUnionObjectInspector getStandardUnionObjectInspector(List<ObjectInspector> unionObjectInspectors) {
        StandardUnionObjectInspector prev;
        StandardUnionObjectInspector result = cachedStandardUnionObjectInspector.get(unionObjectInspectors);
        if (result == null && (prev = cachedStandardUnionObjectInspector.putIfAbsent(unionObjectInspectors, result = new StandardUnionObjectInspector(unionObjectInspectors))) != null) {
            result = prev;
        }
        return result;
    }

    public static StandardStructObjectInspector getStandardStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        return ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, structFieldObjectInspectors, null);
    }

    public static StandardStructObjectInspector getStandardStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structComments) {
        StandardStructObjectInspector prev;
        StandardStructObjectInspector result;
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(3);
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        if (structComments != null) {
            signature.add(structComments);
        }
        if ((result = cachedStandardStructObjectInspector.get(signature)) == null && (prev = cachedStandardStructObjectInspector.putIfAbsent(signature, result = new StandardStructObjectInspector(structFieldNames, structFieldObjectInspectors, structComments))) != null) {
            result = prev;
        }
        return result;
    }

    public static UnionStructObjectInspector getUnionStructObjectInspector(List<StructObjectInspector> structObjectInspectors) {
        UnionStructObjectInspector prev;
        UnionStructObjectInspector result = cachedUnionStructObjectInspector.get(structObjectInspectors);
        if (result == null && (prev = cachedUnionStructObjectInspector.putIfAbsent(structObjectInspectors, result = new UnionStructObjectInspector(structObjectInspectors))) != null) {
            result = prev;
        }
        return result;
    }

    public static ColumnarStructObjectInspector getColumnarStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        return ObjectInspectorFactory.getColumnarStructObjectInspector(structFieldNames, structFieldObjectInspectors, null);
    }

    public static ColumnarStructObjectInspector getColumnarStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments) {
        ColumnarStructObjectInspector prev;
        ColumnarStructObjectInspector result;
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(3);
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        if (structFieldComments != null) {
            signature.add(structFieldComments);
        }
        if ((result = cachedColumnarStructObjectInspector.get(signature)) == null && (prev = cachedColumnarStructObjectInspector.putIfAbsent(signature, result = new ColumnarStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments))) != null) {
            result = prev;
        }
        return result;
    }

    private ObjectInspectorFactory() {
    }

    public static enum ObjectInspectorOptions {
        JAVA,
        THRIFT,
        PROTOCOL_BUFFERS,
        AVRO;

    }
}

