/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.security;

import java.io.IOException;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.server.services.security.AbstractSecurityStoreGenerator;
import org.apache.slider.server.services.security.CertificateManager;
import org.apache.slider.server.services.security.SecurityStore;

public class TruststoreGenerator
extends AbstractSecurityStoreGenerator {
    public TruststoreGenerator(CertificateManager certificateMgr) {
        super(certificateMgr);
    }

    @Override
    public SecurityStore generate(String hostname, String containerId, AggregateConf instanceDefinition, MapOperations compOps, String role) throws SliderException, IOException {
        SecurityStore truststore = null;
        String password = this.getStorePassword(instanceDefinition.getAppConf().credentials, compOps, role);
        if (password != null) {
            truststore = this.certificateMgr.generateContainerTruststore(containerId, role, password);
        }
        return truststore;
    }

    @Override
    String getPassword(MapOperations compOps) {
        return compOps.get(compOps.get("slider.component.truststore.password.property"));
    }

    @Override
    String getAlias(MapOperations compOps) {
        return compOps.getOption("slider.component.truststore.credential.alias.property", "component.truststore.credential.alias");
    }
}

