/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.application.resources;

import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.persist.ConfTreeSerDeser;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.rest.application.resources.ResourceRefresher;

public class AppconfRefresher
implements ResourceRefresher<ConfTree> {
    private final StateAccessForProviders state;
    private final boolean unresolved;
    private final boolean resources;

    public AppconfRefresher(StateAccessForProviders state, boolean unresolved, boolean resources) {
        this.state = state;
        this.unresolved = unresolved;
        this.resources = resources;
    }

    @Override
    public ConfTree refresh() throws Exception {
        AggregateConf aggregateConf = this.unresolved ? this.state.getUnresolvedInstanceDefinition() : this.state.getInstanceDefinitionSnapshot();
        ConfTree ct = this.resources ? aggregateConf.getResources() : aggregateConf.getAppConf();
        return new ConfTreeSerDeser().fromInstance(ct);
    }
}

