/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.RoleStatistics;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.server.appmaster.management.BoolMetricPredicate;
import org.apache.slider.server.appmaster.management.LongGauge;
import org.apache.slider.server.appmaster.state.ContainerOutcome;
import org.apache.slider.server.appmaster.state.OutstandingRequest;

public final class RoleStatus
implements Cloneable,
MetricSet {
    private final String name;
    private final int key;
    private final ProviderRole providerRole;
    private final LongGauge actual = new LongGauge();
    private final LongGauge completed = new LongGauge();
    private final LongGauge desired = new LongGauge();
    private final LongGauge failed = new LongGauge();
    private final LongGauge failedRecently = new LongGauge(0L);
    private final LongGauge limitsExceeded = new LongGauge(0L);
    private final LongGauge nodeFailed = new LongGauge(0L);
    private final LongGauge pendingAntiAffineRequests = new LongGauge(0L);
    private final LongGauge preempted = new LongGauge(0L);
    private final LongGauge releasing = new LongGauge();
    private final LongGauge requested = new LongGauge();
    private final LongGauge started = new LongGauge();
    private final LongGauge startFailed = new LongGauge();
    private final LongGauge totalRequested = new LongGauge();
    private Resource resourceRequirements;
    private volatile OutstandingRequest outstandingAArequest = null;
    private String failureMessage = "";

    public RoleStatus(ProviderRole providerRole) {
        this.providerRole = providerRole;
        this.name = providerRole.name;
        this.key = providerRole.id;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>(15);
        metrics.put("actual", this.actual);
        metrics.put("completed", this.completed);
        metrics.put("desired", this.desired);
        metrics.put("failed", this.failed);
        metrics.put("limitsExceeded", this.limitsExceeded);
        metrics.put("nodeFailed", this.nodeFailed);
        metrics.put("preempted", this.preempted);
        metrics.put("pendingAntiAffineRequests", this.pendingAntiAffineRequests);
        metrics.put("releasing", this.releasing);
        metrics.put("requested", this.requested);
        metrics.put("preempted", this.preempted);
        metrics.put("releasing", this.releasing);
        metrics.put("requested", this.requested);
        metrics.put("started", this.started);
        metrics.put("startFailed", this.startFailed);
        metrics.put("totalRequested", this.totalRequested);
        metrics.put("outstandingAArequest", new BoolMetricPredicate(new BoolMetricPredicate.Eval(){

            @Override
            public boolean eval() {
                return RoleStatus.this.isAARequestOutstanding();
            }
        }));
        return metrics;
    }

    public String getName() {
        return this.name;
    }

    public int getKey() {
        return this.key;
    }

    public int getPriority() {
        return this.getKey();
    }

    public int getPlacementPolicy() {
        return this.providerRole.placementPolicy;
    }

    public long getPlacementTimeoutSeconds() {
        return this.providerRole.placementTimeoutSeconds;
    }

    public int getNodeFailureThreshold() {
        return this.providerRole.nodeFailureThreshold;
    }

    public boolean isExcludeFromFlexing() {
        return this.hasPlacementPolicy(16);
    }

    public boolean isStrictPlacement() {
        return this.hasPlacementPolicy(1);
    }

    public boolean isAntiAffinePlacement() {
        return this.hasPlacementPolicy(4);
    }

    public boolean hasPlacementPolicy(int policy) {
        return (this.getPlacementPolicy() & policy) != 0;
    }

    public boolean isPlacementDesired() {
        return !this.hasPlacementPolicy(2);
    }

    public long getDesired() {
        return this.desired.get();
    }

    public void setDesired(long desired) {
        this.desired.set(desired);
    }

    public long getActual() {
        return this.actual.get();
    }

    public long incActual() {
        return this.actual.incrementAndGet();
    }

    public long decActual() {
        return this.actual.decToFloor(1L);
    }

    public long getRequested() {
        return this.requested.get();
    }

    public long incRequested() {
        this.totalRequested.incrementAndGet();
        return this.requested.incrementAndGet();
    }

    public void cancel(long count) {
        this.requested.decToFloor(count);
    }

    public void decRequested() {
        this.cancel(1L);
    }

    public long getReleasing() {
        return this.releasing.get();
    }

    public long incReleasing() {
        return this.releasing.incrementAndGet();
    }

    public long decReleasing() {
        return this.releasing.decToFloor(1L);
    }

    public long getFailed() {
        return this.failed.get();
    }

    public long getFailedRecently() {
        return this.failedRecently.get();
    }

    public long resetFailedRecently() {
        return this.failedRecently.getAndSet(0L);
    }

    public long getLimitsExceeded() {
        return this.limitsExceeded.get();
    }

    public long incPendingAntiAffineRequests(long v) {
        return this.pendingAntiAffineRequests.addAndGet(v);
    }

    public boolean isAARequestOutstanding() {
        return this.outstandingAArequest != null;
    }

    public int getOutstandingAARequestCount() {
        return this.isAARequestOutstanding() ? 1 : 0;
    }

    public synchronized void noteFailed(boolean startupFailure, String text, ContainerOutcome outcome) {
        if (text != null) {
            this.failureMessage = text;
        }
        switch (outcome) {
            case Preempted: {
                this.preempted.incrementAndGet();
                break;
            }
            case Node_failure: {
                this.nodeFailed.incrementAndGet();
                this.failed.incrementAndGet();
                break;
            }
            case Failed_limits_exceeded: {
                this.limitsExceeded.incrementAndGet();
            }
            default: {
                this.failed.incrementAndGet();
                this.failedRecently.incrementAndGet();
                if (!startupFailure) break;
                this.incStartFailed();
            }
        }
    }

    public long getStartFailed() {
        return this.startFailed.get();
    }

    public synchronized void incStartFailed() {
        this.startFailed.getAndIncrement();
    }

    public synchronized String getFailureMessage() {
        return this.failureMessage;
    }

    public long getCompleted() {
        return this.completed.get();
    }

    public synchronized void setCompleted(int completed) {
        this.completed.set(completed);
    }

    public long incCompleted() {
        return this.completed.incrementAndGet();
    }

    public long getStarted() {
        return this.started.get();
    }

    public synchronized void incStarted() {
        this.started.incrementAndGet();
    }

    public long getTotalRequested() {
        return this.totalRequested.get();
    }

    public long getPreempted() {
        return this.preempted.get();
    }

    public long getNodeFailed() {
        return this.nodeFailed.get();
    }

    public long getPendingAntiAffineRequests() {
        return this.pendingAntiAffineRequests.get();
    }

    public void setPendingAntiAffineRequests(long pendingAntiAffineRequests) {
        this.pendingAntiAffineRequests.set(pendingAntiAffineRequests);
    }

    public long decPendingAntiAffineRequests() {
        return this.pendingAntiAffineRequests.decToFloor(1L);
    }

    public OutstandingRequest getOutstandingAArequest() {
        return this.outstandingAArequest;
    }

    public void setOutstandingAArequest(OutstandingRequest outstandingAArequest) {
        this.outstandingAArequest = outstandingAArequest;
    }

    public void completeOutstandingAARequest() {
        this.setOutstandingAArequest(null);
    }

    public void cancelOutstandingAARequest() {
        if (this.outstandingAArequest != null) {
            this.setOutstandingAArequest(null);
            this.setPendingAntiAffineRequests(0L);
            this.decRequested();
        }
    }

    public long getDelta() {
        long inuse = this.getActualAndRequested();
        long delta = this.desired.get() - inuse;
        if (delta < 0L) {
            delta += this.releasing.get();
            delta = Math.min(delta, 0L);
        }
        return delta;
    }

    public long getActualAndRequested() {
        return this.actual.get() + this.requested.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RoleStatus{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", key=").append(this.key);
        sb.append(", desired=").append(this.desired);
        sb.append(", actual=").append(this.actual);
        sb.append(", requested=").append(this.requested);
        sb.append(", releasing=").append(this.releasing);
        sb.append(", failed=").append(this.failed);
        sb.append(", startFailed=").append(this.startFailed);
        sb.append(", started=").append(this.started);
        sb.append(", completed=").append(this.completed);
        sb.append(", totalRequested=").append(this.totalRequested);
        sb.append(", preempted=").append(this.preempted);
        sb.append(", nodeFailed=").append(this.nodeFailed);
        sb.append(", failedRecently=").append(this.failedRecently);
        sb.append(", limitsExceeded=").append(this.limitsExceeded);
        sb.append(", resourceRequirements=").append(this.resourceRequirements);
        sb.append(", isAntiAffinePlacement=").append(this.isAntiAffinePlacement());
        if (this.isAntiAffinePlacement()) {
            sb.append(", pendingAntiAffineRequests=").append(this.pendingAntiAffineRequests);
            sb.append(", outstandingAArequest=").append(this.outstandingAArequest);
        }
        sb.append(", failureMessage='").append(this.failureMessage).append('\'');
        sb.append(", providerRole=").append(this.providerRole);
        sb.append('}');
        return sb.toString();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ProviderRole getProviderRole() {
        return this.providerRole;
    }

    public Map<String, Integer> buildStatistics() {
        ComponentInformation componentInformation = this.serialize();
        return componentInformation.buildStatistics();
    }

    public synchronized ComponentInformation serialize() {
        ComponentInformation info = new ComponentInformation();
        info.name = this.name;
        info.priority = this.getPriority();
        info.desired = this.desired.intValue();
        info.actual = this.actual.intValue();
        info.requested = this.requested.intValue();
        info.releasing = this.releasing.intValue();
        info.failed = this.failed.intValue();
        info.startFailed = this.startFailed.intValue();
        info.placementPolicy = this.getPlacementPolicy();
        info.failureMessage = this.failureMessage;
        info.totalRequested = this.totalRequested.intValue();
        info.failedRecently = this.failedRecently.intValue();
        info.nodeFailed = this.nodeFailed.intValue();
        info.preempted = this.preempted.intValue();
        info.pendingAntiAffineRequestCount = this.pendingAntiAffineRequests.intValue();
        info.isAARequestOutstanding = this.isAARequestOutstanding();
        return info;
    }

    public String getLabelExpression() {
        return this.providerRole.labelExpression;
    }

    public Resource getResourceRequirements() {
        return this.resourceRequirements;
    }

    public void setResourceRequirements(Resource resourceRequirements) {
        this.resourceRequirements = resourceRequirements;
    }

    public Resource copyResourceRequirements(Resource resource) {
        Preconditions.checkNotNull(this.resourceRequirements, "Role resource requirements have not been set");
        resource.setMemory(this.resourceRequirements.getMemory());
        resource.setVirtualCores(this.resourceRequirements.getVirtualCores());
        return resource;
    }

    public synchronized RoleStatistics getStatistics() {
        RoleStatistics stats = new RoleStatistics();
        stats.activeAA = this.getOutstandingAARequestCount();
        stats.actual = this.actual.get();
        stats.desired = this.desired.get();
        stats.failed = this.failed.get();
        stats.limitsExceeded = this.limitsExceeded.get();
        stats.nodeFailed = this.nodeFailed.get();
        stats.preempted = this.preempted.get();
        stats.releasing = this.releasing.get();
        stats.requested = this.requested.get();
        stats.started = this.started.get();
        stats.startFailed = this.startFailed.get();
        stats.totalRequested = this.totalRequested.get();
        return stats;
    }

    public static class CompareByKey
    implements Comparator<RoleStatus>,
    Serializable {
        @Override
        public int compare(RoleStatus o1, RoleStatus o2) {
            return o1.getKey() < o2.getKey() ? -1 : (o1.getKey() == o2.getKey() ? 0 : 1);
        }
    }

    public static class CompareByName
    implements Comparator<RoleStatus>,
    Serializable {
        @Override
        public int compare(RoleStatus o1, RoleStatus o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

