/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.ContainerLauncher;
import org.apache.slider.core.main.ExitCodeProvider;
import org.apache.slider.providers.ProviderCompleted;
import org.apache.slider.providers.ProviderCore;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.operations.RMOperationHandlerActions;
import org.apache.slider.server.appmaster.state.ContainerReleaseSelector;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.rest.agent.AgentRestOperations;
import org.apache.slider.server.services.yarnregistry.YarnRegistryViewForProviders;

public interface ProviderService
extends ProviderCore,
Service,
RMOperationHandlerActions,
ExitCodeProvider {
    public void buildContainerLaunchContext(ContainerLauncher var1, AggregateConf var2, Container var3, String var4, SliderFileSystem var5, Path var6, MapOperations var7, MapOperations var8, Path var9) throws IOException, SliderException;

    public void notifyContainerCompleted(ContainerId var1);

    public boolean exec(AggregateConf var1, File var2, Map<String, String> var3, ProviderCompleted var4) throws IOException, SliderException;

    public boolean isSupportedRole(String var1);

    public Configuration loadProviderConfigurationInformation(File var1) throws BadCommandArgumentsException, IOException;

    public void initializeApplicationConfiguration(AggregateConf var1, SliderFileSystem var2) throws IOException, SliderException;

    public void validateApplicationConfiguration(AggregateConf var1, File var2, boolean var3) throws IOException, SliderException;

    public Map<String, String> buildProviderStatus();

    public Map<String, String> buildMonitorDetails(ClusterDescription var1);

    public String getHumanName();

    public void bind(StateAccessForProviders var1, QueueAccess var2, List<Container> var3);

    public void bindToYarnRegistry(YarnRegistryViewForProviders var1);

    public AgentRestOperations getAgentRestOperations();

    public void buildEndpointDetails(Map<String, String> var1);

    public void applyInitialRegistryDefinitions(URL var1, URL var2, URL var3, ServiceRecord var4) throws IOException;

    public ContainerReleaseSelector createContainerReleaseSelector();

    public void rebuildContainerDetails(List<Container> var1, String var2, Map<Integer, ProviderRole> var3);
}

