/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.main;

import java.lang.ref.WeakReference;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceShutdownHook
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceShutdownHook.class);
    private final WeakReference<Service> serviceRef;
    private Runnable hook;

    public ServiceShutdownHook(Service service) {
        this.serviceRef = new WeakReference<Service>(service);
    }

    public void register(int priority) {
        this.unregister();
        this.hook = this;
        ShutdownHookManager.get().addShutdownHook(this.hook, priority);
    }

    public synchronized void unregister() {
        if (this.hook != null) {
            try {
                ShutdownHookManager.get().removeShutdownHook(this.hook);
            }
            catch (IllegalStateException e) {
                LOG.info("Failed to unregister shutdown hook: {}", (Object)e, (Object)e);
            }
            this.hook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Service service;
        ServiceShutdownHook serviceShutdownHook = this;
        synchronized (serviceShutdownHook) {
            service = (Service)this.serviceRef.get();
            this.serviceRef.clear();
        }
        if (service == null) {
            return;
        }
        try {
            service.stop();
        }
        catch (Throwable t) {
            LOG.info("Error stopping {}", (Object)service.getName(), (Object)t);
        }
    }
}

