/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.main;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.slider.core.main.ExitCodeProvider;
import org.apache.slider.core.main.IrqHandler;
import org.apache.slider.core.main.LauncherExitCodes;
import org.apache.slider.core.main.RunService;
import org.apache.slider.core.main.ServiceShutdownHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLauncher<S extends Service>
implements LauncherExitCodes,
IrqHandler.Interrupted,
Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLauncher.class);
    protected static final int PRIORITY = 30;
    public static final String NAME = "ServiceLauncher";
    public static final String ARG_CONF = "--conf";
    public static final String USAGE_MESSAGE = "Usage: ServiceLauncher classname [--conf<conf file>] <service arguments> | ";
    static final int SHUTDOWN_TIME_ON_INTERRUPT = 30000;
    private volatile S service;
    private int serviceExitCode;
    private final List<IrqHandler> interruptHandlers = new ArrayList<IrqHandler>(1);
    private Configuration configuration;
    private String serviceClassName;
    private static AtomicBoolean signalAlreadyReceived = new AtomicBoolean(false);

    public ServiceLauncher(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public S getService() {
        return this.service;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getServiceExitCode() {
        return this.serviceExitCode;
    }

    public String toString() {
        return "ServiceLauncher for " + this.serviceClassName;
    }

    public int launchService(Configuration conf, String[] processedArgs, boolean addProcessHooks) throws Throwable {
        this.instantiateService(conf);
        if (addProcessHooks) {
            ServiceShutdownHook shutdownHook = new ServiceShutdownHook((Service)this.service);
            ShutdownHookManager.get().addShutdownHook((Runnable)shutdownHook, 30);
        }
        RunService runService = null;
        if (this.service instanceof RunService) {
            runService = (RunService)this.service;
            this.configuration = runService.bindArgs(this.configuration, processedArgs);
            Preconditions.checkNotNull(this.configuration, "null configuration returned by bindArgs()");
        }
        if (!this.service.isInState(Service.STATE.INITED)) {
            this.service.init(this.configuration);
        }
        this.service.start();
        int exitCode = 0;
        if (runService != null) {
            exitCode = runService.runService();
            LOG.debug("Service exited with exit code {}", (Object)exitCode);
        } else {
            LOG.debug("waiting for service threads to terminate");
            this.service.waitForServiceToStop(0L);
        }
        this.serviceExitCode = exitCode;
        return this.serviceExitCode;
    }

    public Service instantiateService(Configuration conf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ExitUtil.ExitException, NoSuchMethodException, InvocationTargetException {
        Preconditions.checkArgument(conf != null, "null conf");
        this.configuration = conf;
        Class<?> serviceClass = this.getClass().getClassLoader().loadClass(this.serviceClassName);
        Object instance = serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (!(instance instanceof Service)) {
            throw new ExitUtil.ExitException(40, "Not a Service class: " + this.serviceClassName);
        }
        this.service = (Service)instance;
        return this.service;
    }

    protected void registerInterruptHandler() {
        try {
            this.interruptHandlers.add(new IrqHandler("INT", this));
            this.interruptHandlers.add(new IrqHandler("TERM", this));
        }
        catch (IOException e) {
            this.error("Signal handler setup failed : {}" + e, e);
        }
    }

    @Override
    public void interrupted(IrqHandler.InterruptData interruptData) {
        String message = "Service interrupted by " + interruptData.toString();
        this.warn(message);
        if (!signalAlreadyReceived.compareAndSet(false, true)) {
            this.warn("Repeated interrupt: escalating to a JVM halt");
            ExitUtil.halt((int)3, (String)message);
        }
        int shutdownTimeMillis = 30000;
        ServiceForcedShutdown forcedShutdown = new ServiceForcedShutdown(shutdownTimeMillis);
        Thread thread = new Thread(forcedShutdown);
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(shutdownTimeMillis);
        }
        catch (InterruptedException interruptedException) {}
        if (!forcedShutdown.isServiceStopped()) {
            this.warn("Service did not shut down in time");
        }
        this.exit(3, message);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (ShutdownHookManager.get().isShutdownInProgress()) {
            LOG.error("Thread {} threw an error during shutdown: {}.", thread.toString(), exception, exception);
        } else if (exception instanceof Error) {
            try {
                LOG.error("Thread {} threw an error: {}. Shutting down", thread.toString(), exception, exception);
            }
            catch (Throwable throwable) {}
            if (exception instanceof OutOfMemoryError) {
                try {
                    System.err.println("Halting due to Out Of Memory Error...");
                }
                catch (Throwable throwable) {}
                ExitUtil.halt((int)56);
            } else {
                this.exit(this.convertToExitException(exception));
            }
        } else {
            LOG.error("Thread {} threw an exception: {}", thread.toString(), exception, exception);
        }
    }

    protected void warn(String text) {
        System.err.println(text);
    }

    protected void error(String message, Throwable thrown) {
        String text = "Exception: " + message;
        this.warn(text);
        LOG.error(text, thrown);
    }

    protected void exit(int exitCode, String message) {
        ExitUtil.terminate((int)exitCode, (String)message);
    }

    protected void exit(ExitUtil.ExitException ee) {
        ExitUtil.terminate((int)ee.status, (Throwable)ee);
    }

    public String getServiceName() {
        S s = this.service;
        String name = null;
        if (s != null) {
            try {
                name = s.getName();
            }
            catch (Exception exception) {}
        }
        if (name != null) {
            return "service " + name;
        }
        return "service classname " + this.serviceClassName;
    }

    public void launchServiceAndExit(List<String> args) {
        this.registerInterruptHandler();
        Configuration conf = new Configuration();
        String[] processedArgs = ServiceLauncher.extractConfigurationArgs(conf, args);
        ExitUtil.ExitException ee = this.launchServiceRobustly(conf, processedArgs);
        System.out.flush();
        System.err.flush();
        this.exit(ee);
    }

    public static String[] extractConfigurationArgs(Configuration conf, List<String> args) {
        int argCount = args.size();
        if (argCount <= 1) {
            return new String[0];
        }
        ArrayList<String> argsList = new ArrayList<String>(argCount);
        ListIterator<String> arguments = args.listIterator();
        arguments.next();
        while (arguments.hasNext()) {
            String arg = arguments.next();
            if (arg.equals(ARG_CONF)) {
                File file;
                if (!arguments.hasNext()) {
                    ServiceLauncher.exitWithMessage(40, "--conf: missing configuration file after ");
                }
                if (!(file = new File(arguments.next())).exists()) {
                    ServiceLauncher.exitWithMessage(40, "--conf: configuration file not found: " + file);
                }
                try {
                    conf.addResource(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOG.debug("File {} cannot be converted to URL: {}", e);
                    ServiceLauncher.exitWithMessage(40, "--conf: configuration file path invalid: " + file);
                }
                continue;
            }
            argsList.add(arg);
        }
        String[] processedArgs = new String[argsList.size()];
        argsList.toArray(processedArgs);
        return processedArgs;
    }

    public ExitUtil.ExitException launchServiceRobustly(Configuration conf, String[] processedArgs) {
        ExitUtil.ExitException exitException;
        try {
            Throwable failure;
            int exitCode = this.launchService(conf, processedArgs, true);
            if (this.service != null && (failure = this.service.getFailureCause()) != null) {
                Service.STATE failureState = this.service.getFailureState();
                if (failureState == Service.STATE.STOPPED) {
                    LOG.debug("Failure during shutdown:{} ", (Object)failure, (Object)failure);
                } else {
                    throw failure;
                }
            }
            exitException = new ExitUtil.ExitException(exitCode, "In " + this.serviceClassName);
        }
        catch (ExitUtil.ExitException ee) {
            exitException = ee;
        }
        catch (Throwable thrown) {
            exitException = this.convertToExitException(thrown);
        }
        return exitException;
    }

    protected ExitUtil.ExitException convertToExitException(Throwable thrown) {
        int exitCode;
        String message = thrown.getMessage();
        if (message == null) {
            message = thrown.toString();
        }
        if (thrown instanceof ExitCodeProvider) {
            exitCode = ((ExitCodeProvider)((Object)thrown)).getExitCode();
            if (LOG.isDebugEnabled()) {
                LOG.debug("While running {}: {}", this.getServiceName(), message, thrown);
            }
            LOG.error(message);
        } else {
            this.error(message, thrown);
            exitCode = 56;
        }
        ExitUtil.ExitException exitException = new ExitUtil.ExitException(exitCode, message);
        exitException.initCause(thrown);
        return exitException;
    }

    public static String startupShutdownMessage(String classname, List<String> args) {
        String hostname = NetUtils.getHostname();
        return ServiceLauncher.toStartupShutdownString("STARTUP_MSG: ", new String[]{"Starting " + classname, "  host = " + hostname, "  args = " + args, "  version = " + VersionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision() + "; compiled by '" + VersionInfo.getUser() + "' on " + VersionInfo.getDate(), "  java = " + System.getProperty("java.version")});
    }

    private static void exitWithMessage(int status, String message) {
        System.err.println(message);
        ExitUtil.terminate((int)status);
    }

    private static String toStartupShutdownString(String prefix, String[] msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        String[] stringArray = msg;
        int n = msg.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            b.append("\n").append(prefix).append(s);
            ++n2;
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static void serviceMain(List<String> argsList) {
        if (argsList.isEmpty()) {
            ServiceLauncher.exitWithMessage(4, USAGE_MESSAGE);
        } else {
            String serviceClassName = argsList.get(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug(ServiceLauncher.startupShutdownMessage(serviceClassName, argsList));
                StringBuilder builder = new StringBuilder();
                for (String arg : argsList) {
                    builder.append('\"').append(arg).append("\" ");
                }
                LOG.debug(builder.toString());
            }
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            ServiceLauncher serviceLauncher = new ServiceLauncher(serviceClassName);
            serviceLauncher.launchServiceAndExit(argsList);
        }
    }

    public static void main(String[] args) {
        List<String> argsList = Arrays.asList(args);
        ServiceLauncher.serviceMain(argsList);
    }

    protected class ServiceForcedShutdown
    implements Runnable {
        private final int shutdownTimeMillis;
        private boolean serviceStopped;

        public ServiceForcedShutdown(int shutdownTimeoutMillis) {
            this.shutdownTimeMillis = shutdownTimeoutMillis;
        }

        @Override
        public void run() {
            if (ServiceLauncher.this.service != null) {
                ServiceLauncher.this.service.stop();
                this.serviceStopped = ServiceLauncher.this.service.waitForServiceToStop((long)this.shutdownTimeMillis);
            } else {
                this.serviceStopped = true;
            }
        }

        private boolean isServiceStopped() {
            return this.serviceStopped;
        }
    }
}

