/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client.ipc;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.slider.api.SliderApplicationApi;
import org.apache.slider.api.SliderClusterProtocol;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.api.types.PingInformation;
import org.apache.slider.client.ipc.SliderClusterOperations;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.NoSuchNodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderApplicationIpcClient
implements SliderApplicationApi {
    private static final Logger log = LoggerFactory.getLogger(SliderApplicationIpcClient.class);
    private final SliderClusterOperations operations;

    public SliderApplicationIpcClient(SliderClusterOperations operations) {
        Preconditions.checkArgument(operations != null, "null operations");
        this.operations = operations;
    }

    private IOException convert(IOException exception) {
        IOException result = exception;
        if (exception instanceof NoSuchNodeException) {
            result = new FileNotFoundException(exception.toString());
            result.initCause(exception);
        }
        return result;
    }

    public SliderApplicationIpcClient(SliderClusterProtocol proxy) {
        this(new SliderClusterOperations(proxy));
    }

    @Override
    public AggregateConf getDesiredModel() throws IOException {
        try {
            return this.operations.getModelDesired();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ConfTreeOperations getDesiredAppconf() throws IOException {
        try {
            return this.operations.getModelDesiredAppconf();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ConfTreeOperations getDesiredResources() throws IOException {
        try {
            return this.operations.getModelDesiredResources();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public void putDesiredResources(ConfTree updated) throws IOException {
        try {
            this.operations.flex(updated);
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public AggregateConf getResolvedModel() throws IOException {
        try {
            return this.operations.getModelResolved();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ConfTreeOperations getResolvedAppconf() throws IOException {
        try {
            return this.operations.getModelResolvedAppconf();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ConfTreeOperations getResolvedResources() throws IOException {
        try {
            return this.operations.getModelResolvedResources();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ConfTreeOperations getLiveResources() throws IOException {
        try {
            return this.operations.getLiveResources();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Map<String, ContainerInformation> enumContainers() throws IOException {
        try {
            return this.operations.enumContainers();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ContainerInformation getContainer(String containerId) throws IOException {
        try {
            return this.operations.getContainer(containerId);
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Map<String, ComponentInformation> enumComponents() throws IOException {
        try {
            return this.operations.enumComponents();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ComponentInformation getComponent(String componentName) throws IOException {
        try {
            return this.operations.getComponent(componentName);
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public NodeInformationList getLiveNodes() throws IOException {
        try {
            return this.operations.getLiveNodes();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public NodeInformation getLiveNode(String hostname) throws IOException {
        try {
            return this.operations.getLiveNode(hostname);
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public PingInformation ping(String text) throws IOException {
        return null;
    }

    @Override
    public void stop(String text) throws IOException {
        try {
            this.operations.stop(text);
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    @Override
    public ApplicationLivenessInformation getApplicationLiveness() throws IOException {
        try {
            return this.operations.getApplicationLiveness();
        }
        catch (IOException e) {
            throw this.convert(e);
        }
    }

    public String toString() {
        return "IPC implementation of SliderApplicationApi bonded to " + this.operations;
    }
}

