/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosDiags
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosDiags.class);
    public static final String KRB5_CCNAME = "KRB5CCNAME";
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String JAVA_SECURITY_KRB5_REALM = "java.security.krb5.realm";
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    public static final String SUN_SECURITY_SPNEGO_DEBUG = "sun.security.spnego.debug";
    private final Configuration conf;
    private final List<String> services;
    private final PrintWriter out;
    private final File keytab;
    private final String principal;

    public KerberosDiags(Configuration conf, PrintWriter out, List<String> services, File keytab, String principal) {
        this.conf = conf;
        this.services = services;
        this.keytab = keytab;
        this.principal = principal;
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    private void println(String format, Object ... args) {
        String msg = String.format(format, args);
        if (this.out != null) {
            this.out.println(msg);
            this.out.flush();
        } else {
            LOG.info(msg);
        }
    }

    private void title(String format, Object ... args) {
        this.println("", new Object[0]);
        this.println("", new Object[0]);
        this.println(format, args);
        this.println("", new Object[0]);
    }

    private void printSysprop(String key) {
        this.println("%s = \"%s\"", key, System.getProperty(key, "(unset)"));
    }

    private void printConfOpt(String key) {
        this.println("%s = \"%s\"", key, this.conf.get(key, "(unset)"));
    }

    private void printEnv(String key) {
        String env = System.getenv(key);
        this.println("%s = \"%s\"", key, env != null ? env : "(unset)");
    }

    private void dump(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(file);){
            for (String line : IOUtils.readLines((InputStream)in)) {
                this.println(line, new Object[0]);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.println("", new Object[0]);
    }

    public boolean execute() throws Exception {
        String prop;
        this.title("Kerberos Diagnostics scan at %s", new Date(System.currentTimeMillis()));
        boolean securityDisabled = SecurityUtil.getAuthenticationMethod((Configuration)this.conf).equals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE);
        if (securityDisabled) {
            this.println("security disabled", new Object[0]);
            return false;
        }
        this.title("System Properties", new Object[0]);
        String[] stringArray = new String[]{JAVA_SECURITY_KRB5_CONF, JAVA_SECURITY_KRB5_REALM, SUN_SECURITY_KRB5_DEBUG, SUN_SECURITY_SPNEGO_DEBUG};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            prop = stringArray[n2];
            this.printSysprop(prop);
            ++n2;
        }
        this.title("Environment Variables", new Object[0]);
        stringArray = new String[]{"HADOOP_JAAS_DEBUG", KRB5_CCNAME, "HADOOP_USER_NAME", "HADOOP_PROXY_USER", "HADOOP_TOKEN_FILE_LOCATION"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            this.printEnv(env);
            ++n2;
        }
        stringArray = new String[]{"hadoop.kerberos.kinit.command", "hadoop.security.authentication", "hadoop.security.authorization", "hadoop.security.dns.interface", "hadoop.security.dns.nameserver", "hadoop.ssl.enabled", "hadoop.rpc.protection", "hadoop.security.saslproperties.resolver.class", "hadoop.security.crypto.codec.classes", "hadoop.security.group.mapping"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            prop = stringArray[n2];
            this.printConfOpt(prop);
            ++n2;
        }
        System.setProperty(SUN_SECURITY_KRB5_DEBUG, "true");
        System.setProperty(SUN_SECURITY_SPNEGO_DEBUG, "true");
        this.title("Logging in", new Object[0]);
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        this.dumpUser("Log in user", loginUser);
        this.println("Ticket based login: %b", UserGroupInformation.isLoginTicketBased());
        this.println("Keytab based login: %b", UserGroupInformation.isLoginKeytabBased());
        this.validateUser("Login user", loginUser);
        if (!Shell.WINDOWS) {
            String krb5name;
            this.title("Locating Kerberos configuration file", new Object[0]);
            String krbPath = "/etc/krb5.conf";
            String jvmKrbPath = System.getProperty(JAVA_SECURITY_KRB5_CONF);
            if (jvmKrbPath != null) {
                this.println("Setting kerberos path from sysprop %s: %s", JAVA_SECURITY_KRB5_CONF, jvmKrbPath);
                krbPath = jvmKrbPath;
            }
            if ((krb5name = System.getenv(KRB5_CCNAME)) != null) {
                this.println("Setting kerberos path from environment variable %s: %s", KRB5_CCNAME, krb5name);
                krbPath = krb5name;
                if (jvmKrbPath != null) {
                    this.println("Warning - both %s and %s were set - %s takes priority", JAVA_SECURITY_KRB5_CONF, KRB5_CCNAME, KRB5_CCNAME);
                }
            }
            File krbFile = new File(krbPath);
            this.println("Kerberos configuration file = %s", krbFile);
            this.failif(!krbFile.exists(), "Kerberos configuration file %s not found", krbFile);
            this.dump(krbFile);
        }
        if (this.keytab != null) {
            File kt = this.keytab.getCanonicalFile();
            this.println("Using keytab %s principal %s", kt, this.principal);
            String identity = this.principal;
            this.failif(!kt.exists(), "Keytab not found: %s", kt);
            this.failif(!kt.isFile(), "Keytab is not a valid file: %s", kt);
            this.failif(StringUtils.isEmpty(this.principal), "No principal defined", new Object[0]);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal, (String)kt.getPath());
            this.dumpUser(identity, ugi);
            this.validateUser(this.principal, ugi);
            this.title("Attempting to log in from keytab again", new Object[0]);
            UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
            ugi.reloginFromKeytab();
        } else {
            this.println("No keytab: logging is as current user", new Object[0]);
        }
        return true;
    }

    private void dumpUser(String message, UserGroupInformation ugi) throws IOException {
        this.title(message, new Object[0]);
        this.println("UGI=%s", ugi);
        this.println("Has kerberos credentials: %b", ugi.hasKerberosCredentials());
        this.println("Authentication method: %s", ugi.getAuthenticationMethod());
        this.println("Real Authentication method: %s", ugi.getRealAuthenticationMethod());
        this.title("Group names", new Object[0]);
        String[] stringArray = ugi.getGroupNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.println(name, new Object[0]);
            ++n2;
        }
        this.title("Credentials", new Object[0]);
        Credentials credentials = ugi.getCredentials();
        List secretKeys = credentials.getAllSecretKeys();
        this.title("Secret keys", new Object[0]);
        if (!secretKeys.isEmpty()) {
            for (Text secret : secretKeys) {
                this.println("%s", secret);
            }
        } else {
            this.println("(none)", new Object[0]);
        }
        this.title("Tokens", new Object[0]);
        Collection tokens = credentials.getAllTokens();
        if (!tokens.isEmpty()) {
            for (Token token : tokens) {
                this.println("%s", token);
            }
        } else {
            this.println("(none)", new Object[0]);
        }
    }

    private void validateUser(String message, UserGroupInformation user) {
        this.failif(!user.hasKerberosCredentials(), "%s: No kerberos credentials for  %s", message, user);
        this.failif(user.getAuthenticationMethod() == null, "%s: Null AuthenticationMethod for %s", message, user);
    }

    private void fail(String message, Object ... args) throws KerberosDiagsFailure {
        throw new KerberosDiagsFailure(message, args);
    }

    private void failif(boolean condition, String message, Object ... args) throws KerberosDiagsFailure {
        if (condition) {
            this.fail(message, args);
        }
    }

    public static class KerberosDiagsFailure
    extends ExitUtil.ExitException {
        public KerberosDiagsFailure(String message) {
            super(41, message);
        }

        public KerberosDiagsFailure(String message, Object ... args) {
            this(String.format(message, args));
        }

        public KerberosDiagsFailure(Throwable throwable, String message, Object ... args) {
            this(message, args);
            this.initCause(throwable);
        }
    }
}

