/*
 * Copyright 2016 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.codec.smtp;

import org.apache.hadoop.hbase.shaded.io.netty.util.internal.UnstableApi;

import java.util.List;

/**
 * An SMTP request.
 */
@UnstableApi
public interface SmtpRequest {

    /**
     * Returns the {@link SmtpCommand} that belongs to the request.
     */
    SmtpCommand command();

    /**
     * Returns a {@link List} which holds all the parameters of a request, which may be an empty list.
     */
    List<CharSequence> parameters();
}
