/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.glassfish.jersey.server.wadl.internal;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Application;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Doc;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Method;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Param;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.ParamStyle;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Representation;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Request;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resources;
import org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Response;
import org.apache.hbase.thirdparty.org.glassfish.jersey.internal.Version;
import org.apache.hbase.thirdparty.org.glassfish.jersey.model.Parameter;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.internal.LocalizationMessages;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.model.Parameter;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.model.Resource;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.model.ResourceMethod;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.wadl.WadlGenerator;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.wadl.internal.WadlApplicationContextImpl;

public class WadlBuilder {
    private final WadlGenerator _wadlGenerator;
    private final UriInfo uriInfo;
    private final boolean detailedWadl;

    public WadlBuilder(WadlGenerator wadlGenerator, boolean detailedWadl, UriInfo uriInfo) {
        this.detailedWadl = detailedWadl;
        this._wadlGenerator = wadlGenerator;
        this.uriInfo = uriInfo;
    }

    public ApplicationDescription generate(List<Resource> resources) {
        Application wadlApplication = this._wadlGenerator.createApplication();
        Resources wadlResources = this._wadlGenerator.createResources();
        for (Resource r : resources) {
            org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resource wadlResource = this.generateResource(r, r.getPath());
            if (wadlResource == null) continue;
            wadlResources.getResource().add(wadlResource);
        }
        wadlApplication.getResources().add(wadlResources);
        this.addVersion(wadlApplication);
        this.addHint(wadlApplication);
        WadlGenerator.ExternalGrammarDefinition external = this._wadlGenerator.createExternalGrammar();
        ApplicationDescription description = new ApplicationDescription(wadlApplication, external);
        this._wadlGenerator.attachTypes(description);
        return description;
    }

    public Application generate(ApplicationDescription description, Resource resource) {
        try {
            Application wadlApplication = this._wadlGenerator.createApplication();
            Resources wadlResources = this._wadlGenerator.createResources();
            org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resource wadlResource = this.generateResource(resource, null);
            if (wadlResource == null) {
                return null;
            }
            wadlResources.getResource().add(wadlResource);
            wadlApplication.getResources().add(wadlResources);
            this.addVersion(wadlApplication);
            this._wadlGenerator.attachTypes(description);
            return wadlApplication;
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_RESOURCE(resource), (Throwable)e);
        }
    }

    private void addVersion(Application wadlApplication) {
        Doc d = new Doc();
        d.getOtherAttributes().put(new QName("http://jersey.java.net/", "generatedBy", "org.apache.hbase.thirdparty.jersery"), Version.getBuildId());
        wadlApplication.getDoc().add(d);
    }

    private void addHint(Application wadlApplication) {
        if (this.uriInfo != null) {
            String message;
            Doc d = new Doc();
            if (this.detailedWadl) {
                String uriWithoutQueryParam = UriBuilder.fromUri((URI)this.uriInfo.getRequestUri()).replaceQuery("").build(new Object[0]).toString();
                message = LocalizationMessages.WADL_DOC_EXTENDED_WADL("detail", uriWithoutQueryParam);
            } else {
                String uriWithQueryParam = UriBuilder.fromUri((URI)this.uriInfo.getRequestUri()).queryParam("detail", new Object[]{"true"}).build(new Object[0]).toString();
                message = LocalizationMessages.WADL_DOC_SIMPLE_WADL("detail", uriWithQueryParam);
            }
            d.getOtherAttributes().put(new QName("http://jersey.java.net/", "hint", "org.apache.hbase.thirdparty.jersery"), message);
            wadlApplication.getDoc().add(d);
        }
    }

    private Method generateMethod(Resource parentResource, Map<String, Param> wadlResourceParams, ResourceMethod resourceMethod) {
        try {
            List<Response> responses;
            if (!this.detailedWadl && resourceMethod.isExtended()) {
                return null;
            }
            Method wadlMethod = this._wadlGenerator.createMethod(parentResource, resourceMethod);
            Request wadlRequest = this.generateRequest(parentResource, resourceMethod, wadlResourceParams);
            if (wadlRequest != null) {
                wadlMethod.setRequest(wadlRequest);
            }
            if ((responses = this.generateResponses(parentResource, resourceMethod)) != null) {
                wadlMethod.getResponse().addAll(responses);
            }
            return wadlMethod;
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_METHOD(resourceMethod, parentResource), (Throwable)e);
        }
    }

    private Request generateRequest(Resource parentResource, ResourceMethod resourceMethod, Map<String, Param> wadlResourceParams) {
        try {
            LinkedList<Parameter> requestParams = new LinkedList<Parameter>(resourceMethod.getInvocable().getParameters());
            requestParams.addAll(resourceMethod.getInvocable().getHandler().getParameters());
            if (requestParams.isEmpty()) {
                return null;
            }
            Request wadlRequest = this._wadlGenerator.createRequest(parentResource, resourceMethod);
            this.processRequestParameters(parentResource, resourceMethod, wadlResourceParams, requestParams, wadlRequest);
            if (wadlRequest.getRepresentation().size() + wadlRequest.getParam().size() == 0) {
                return null;
            }
            return wadlRequest;
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_REQUEST(resourceMethod, parentResource), (Throwable)e);
        }
    }

    private void processRequestParameters(Resource parentResource, ResourceMethod resourceMethod, Map<String, Param> wadlResourceParams, Collection<Parameter> requestParameters, Request wadlRequest) {
        for (Parameter parameter : requestParameters) {
            Param wadlParam;
            Representation wadlRepresentation;
            List<MediaType> supportedInputTypes;
            if (parameter.getSource() == Parameter.Source.ENTITY || parameter.getSource() == Parameter.Source.UNKNOWN) {
                for (MediaType mediaType : resourceMethod.getConsumedTypes()) {
                    this.setRepresentationForMediaType(parentResource, resourceMethod, mediaType, wadlRequest);
                }
                continue;
            }
            if (parameter.getSourceAnnotation().annotationType() == FormParam.class) {
                supportedInputTypes = resourceMethod.getConsumedTypes();
                if (supportedInputTypes.isEmpty() || supportedInputTypes.size() == 1 && supportedInputTypes.get(0).isWildcardType()) {
                    supportedInputTypes = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
                }
                for (MediaType mediaType : supportedInputTypes) {
                    wadlRepresentation = this.setRepresentationForMediaType(parentResource, resourceMethod, mediaType, wadlRequest);
                    if (this.getParamByName(wadlRepresentation.getParam(), parameter.getSourceName()) != null || (wadlParam = this.generateParam(parentResource, resourceMethod, parameter)) == null) continue;
                    wadlRepresentation.getParam().add(wadlParam);
                }
                continue;
            }
            if ("org.apache.hbase.thirdparty.org.glassfish.jersey.media.multipart.FormDataParam".equals(parameter.getSourceAnnotation().annotationType().getName())) {
                supportedInputTypes = resourceMethod.getConsumedTypes();
                if (supportedInputTypes.isEmpty() || supportedInputTypes.size() == 1 && supportedInputTypes.get(0).isWildcardType()) {
                    supportedInputTypes = Collections.singletonList(MediaType.MULTIPART_FORM_DATA_TYPE);
                }
                for (MediaType mediaType : supportedInputTypes) {
                    wadlRepresentation = this.setRepresentationForMediaType(parentResource, resourceMethod, mediaType, wadlRequest);
                    if (this.getParamByName(wadlRepresentation.getParam(), parameter.getSourceName()) != null || (wadlParam = this.generateParam(parentResource, resourceMethod, parameter)) == null) continue;
                    wadlRepresentation.getParam().add(wadlParam);
                }
                continue;
            }
            if (parameter instanceof Parameter.BeanParameter) {
                this.processRequestParameters(parentResource, resourceMethod, wadlResourceParams, ((Parameter.BeanParameter)parameter).getParameters(), wadlRequest);
                continue;
            }
            Param wadlParam2 = this.generateParam(parentResource, resourceMethod, parameter);
            if (wadlParam2 == null) continue;
            if (wadlParam2.getStyle() == ParamStyle.TEMPLATE || wadlParam2.getStyle() == ParamStyle.MATRIX) {
                wadlResourceParams.put(wadlParam2.getName(), wadlParam2);
                continue;
            }
            wadlRequest.getParam().add(wadlParam2);
        }
    }

    private Param getParamByName(List<Param> params, String name) {
        for (Param param : params) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    private Representation setRepresentationForMediaType(Resource r, ResourceMethod m, MediaType mediaType, Request wadlRequest) {
        try {
            Representation wadlRepresentation = this.getRepresentationByMediaType(wadlRequest.getRepresentation(), mediaType);
            if (wadlRepresentation == null) {
                wadlRepresentation = this._wadlGenerator.createRequestRepresentation(r, m, mediaType);
                wadlRequest.getRepresentation().add(wadlRepresentation);
            }
            return wadlRepresentation;
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_REQUEST_MEDIA_TYPE(mediaType, m, r), (Throwable)e);
        }
    }

    private Representation getRepresentationByMediaType(List<Representation> representations, MediaType mediaType) {
        for (Representation representation : representations) {
            if (!mediaType.toString().equals(representation.getMediaType())) continue;
            return representation;
        }
        return null;
    }

    private Param generateParam(Resource resource, ResourceMethod method, Parameter param) {
        try {
            if (param.getSource() == Parameter.Source.ENTITY || param.getSource() == Parameter.Source.CONTEXT) {
                return null;
            }
            return this._wadlGenerator.createParam(resource, method, param);
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_PARAM(param, resource, method), (Throwable)e);
        }
    }

    private org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resource generateResource(Resource r, String path) {
        return this.generateResource(r, path, Collections.emptySet());
    }

    private org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resource generateResource(Resource resource, String path, Set<Resource> visitedResources) {
        try {
            if (!this.detailedWadl && resource.isExtended()) {
                return null;
            }
            org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resource wadlResource = this._wadlGenerator.createResource(resource, path);
            if (visitedResources.contains(resource)) {
                return wadlResource;
            }
            visitedResources = new HashSet<Resource>(visitedResources);
            visitedResources.add(resource);
            ResourceMethod locator = resource.getResourceLocator();
            if (locator != null) {
                try {
                    Resource subResource;
                    org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resource wadlSubResource;
                    Resource.Builder builder = Resource.builder(locator.getInvocable().getRawResponseType());
                    if (builder == null) {
                        builder = Resource.builder().path(resource.getPath());
                    }
                    if ((wadlSubResource = this.generateResource(subResource = builder.build(), resource.getPath(), visitedResources)) == null) {
                        return null;
                    }
                    if (locator.isExtended()) {
                        wadlSubResource.getAny().add(WadlApplicationContextImpl.EXTENDED_ELEMENT);
                    }
                    for (Parameter param : locator.getInvocable().getParameters()) {
                        Param wadlParam = this.generateParam(resource, locator, param);
                        if (wadlParam == null || wadlParam.getStyle() != ParamStyle.TEMPLATE) continue;
                        wadlSubResource.getParam().add(wadlParam);
                    }
                    return wadlSubResource;
                }
                catch (RuntimeException e) {
                    throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_RESOURCE_LOCATOR(locator, resource), (Throwable)e);
                }
            }
            HashMap<String, Param> wadlResourceParams = new HashMap<String, Param>();
            for (ResourceMethod method : resource.getResourceMethods()) {
                if (!this.detailedWadl && method.isExtended()) continue;
                Method wadlMethod = this.generateMethod(resource, wadlResourceParams, method);
                wadlResource.getMethodOrResource().add(wadlMethod);
            }
            for (Param wadlParam : wadlResourceParams.values()) {
                wadlResource.getParam().add(wadlParam);
            }
            HashMap wadlSubResources = new HashMap();
            HashMap wadlSubResourcesParams = new HashMap();
            for (Resource childResource : resource.getChildResources()) {
                org.apache.hbase.thirdparty.com.sun.research.ws.wadl.Resource childWadlResource = this.generateResource(childResource, childResource.getPath(), visitedResources);
                if (childWadlResource == null) continue;
                wadlResource.getMethodOrResource().add(childWadlResource);
            }
            return wadlResource;
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_RESOURCE_PATH(resource, path), (Throwable)e);
        }
    }

    private List<Response> generateResponses(Resource r, ResourceMethod m) {
        try {
            if (m.getInvocable().getRawResponseType() == Void.TYPE) {
                return null;
            }
            return this._wadlGenerator.createResponses(r, m);
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_BUILDER_GENERATION_RESPONSE(m, r), (Throwable)e);
        }
    }
}

