/*
 * Copyright (c) 2012, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.apache.hbase.thirdparty.org.jvnet.hk2.internal;

import java.util.LinkedList;
import java.util.List;

import org.apache.hbase.thirdparty.org.glassfish.hk2.api.ActiveDescriptor;

/**
 * This contains the local portion of the narrowed result
 * 
 * @author jwells
 *
 */
public class ImmediateResults {
    private final NarrowResults timelessResults;
    private final List<ActiveDescriptor<?>> validatedImmediateResults = new LinkedList<ActiveDescriptor<?>>();
    
    /* package */ ImmediateResults(NarrowResults cachedResults) {
        if (cachedResults == null) {
            timelessResults = new NarrowResults();
        }
        else {
            timelessResults = cachedResults;
        }
    }
    
    /* package */ NarrowResults getTimelessResults() {
        return timelessResults;
    }
    
    /* package */ List<ActiveDescriptor<?>> getImmediateResults() {
        return validatedImmediateResults;
    }
    
    /* package */ void addValidatedResult(ActiveDescriptor<?> addMe) {
        validatedImmediateResults.add(addMe);
    }
    
    @Override
    public String toString() {
        return "ImmediateResults(" + timelessResults + "," + validatedImmediateResults + "," + System.identityHashCode(this) + ")";
    }

}
