/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.PrintStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.diskbalancer.command.CancelCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ExecuteCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.HelpCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.PlanCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.QueryCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ReportCommand;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskBalancerCLI
extends Configured
implements Tool {
    public static final String PLAN = "plan";
    public static final String OUTFILE = "out";
    public static final String HELP = "help";
    public static final String THRESHOLD = "thresholdPercentage";
    public static final String BANDWIDTH = "bandwidth";
    public static final String MAXERROR = "maxerror";
    public static final String EXECUTE = "execute";
    public static final String REPORT = "report";
    public static final String TOP = "top";
    public static final int DEFAULT_TOP = 100;
    public static final String NODE = "node";
    public static final String VERBOSE = "v";
    public static final int PLAN_VERSION = 1;
    public static final String QUERY = "query";
    public static final String CANCEL = "cancel";
    public static final String BEFORE_TEMPLATE = "%s.before.json";
    public static final String PLAN_TEMPLATE = "%s.plan.json";
    private static final Logger LOG = LoggerFactory.getLogger(DiskBalancerCLI.class);
    private static final Options PLAN_OPTIONS = new Options();
    private static final Options EXECUTE_OPTIONS = new Options();
    private static final Options QUERY_OPTIONS = new Options();
    private static final Options HELP_OPTIONS = new Options();
    private static final Options CANCEL_OPTIONS = new Options();
    private static final Options REPORT_OPTIONS = new Options();
    private final PrintStream printStream;

    public DiskBalancerCLI(Configuration conf) {
        this(conf, System.out);
    }

    public DiskBalancerCLI(Configuration conf, PrintStream printStream) {
        super(conf);
        this.printStream = printStream;
    }

    public static void main(String[] argv) throws Exception {
        DiskBalancerCLI shell = new DiskBalancerCLI(new HdfsConfiguration());
        int res = 0;
        try {
            res = ToolRunner.run((Tool)shell, (String[])argv);
        }
        catch (Exception ex) {
            LOG.error(ex.toString());
            res = 1;
        }
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = this.getOpts();
        CommandLine cmd = this.parseArgs(args, opts);
        return this.dispatch(cmd, opts);
    }

    private Options getOpts() {
        Options opts = new Options();
        this.addPlanCommands(opts);
        this.addHelpCommands(opts);
        this.addExecuteCommands(opts);
        this.addQueryCommands(opts);
        this.addCancelCommands(opts);
        this.addReportCommands(opts);
        return opts;
    }

    public static Options getPlanOptions() {
        return PLAN_OPTIONS;
    }

    public static Options getHelpOptions() {
        return HELP_OPTIONS;
    }

    public static Options getExecuteOptions() {
        return EXECUTE_OPTIONS;
    }

    public static Options getQueryOptions() {
        return QUERY_OPTIONS;
    }

    public static Options getCancelOptions() {
        return CANCEL_OPTIONS;
    }

    public static Options getReportOptions() {
        return REPORT_OPTIONS;
    }

    private void addPlanCommands(Options opt) {
        OptionBuilder.withLongOpt((String)PLAN);
        OptionBuilder.withDescription((String)"Hostname, IP address or UUID of datanode for which a plan is created.");
        OptionBuilder.hasArg();
        Option plan = OptionBuilder.create();
        DiskBalancerCLI.getPlanOptions().addOption(plan);
        opt.addOption(plan);
        OptionBuilder.withLongOpt((String)OUTFILE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Local path of file to write output to, if not specified defaults will be used.");
        Option outFile = OptionBuilder.create();
        DiskBalancerCLI.getPlanOptions().addOption(outFile);
        opt.addOption(outFile);
        OptionBuilder.withLongOpt((String)BANDWIDTH);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum disk bandwidth (MB/s) in integer to be consumed by diskBalancer. e.g. 10 MB/s.");
        Option bandwidth = OptionBuilder.create();
        DiskBalancerCLI.getPlanOptions().addOption(bandwidth);
        opt.addOption(bandwidth);
        OptionBuilder.withLongOpt((String)THRESHOLD);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Percentage of data skew that is tolerated before disk balancer starts working. For example, if total data on a 2 disk node is 100 GB then disk balancer calculates the expected value on each disk, which is 50 GB. If the tolerance is 10% then data on a single disk needs to be more than 60 GB (50 GB + 10% tolerance value) for Disk balancer to balance the disks.");
        Option threshold = OptionBuilder.create();
        DiskBalancerCLI.getPlanOptions().addOption(threshold);
        opt.addOption(threshold);
        OptionBuilder.withLongOpt((String)MAXERROR);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Describes how many errors can be tolerated while copying between a pair of disks.");
        Option maxError = OptionBuilder.create();
        DiskBalancerCLI.getPlanOptions().addOption(maxError);
        opt.addOption(maxError);
        OptionBuilder.withLongOpt((String)VERBOSE);
        OptionBuilder.withDescription((String)"Print out the summary of the plan on console");
        Option verbose = OptionBuilder.create();
        DiskBalancerCLI.getPlanOptions().addOption(verbose);
        opt.addOption(verbose);
    }

    private void addHelpCommands(Options opt) {
        OptionBuilder.withLongOpt((String)HELP);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"valid commands are plan | execute | query | cancel | report");
        Option help = OptionBuilder.create();
        DiskBalancerCLI.getHelpOptions().addOption(help);
        opt.addOption(help);
    }

    private void addExecuteCommands(Options opt) {
        OptionBuilder.withLongOpt((String)EXECUTE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Takes a plan file and submits it for execution by the datanode.");
        Option execute = OptionBuilder.create();
        DiskBalancerCLI.getExecuteOptions().addOption(execute);
        opt.addOption(execute);
    }

    private void addQueryCommands(Options opt) {
        OptionBuilder.withLongOpt((String)QUERY);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Queries the disk balancer status of a given datanode.");
        Option query = OptionBuilder.create();
        DiskBalancerCLI.getQueryOptions().addOption(query);
        opt.addOption(query);
        OptionBuilder.withLongOpt((String)VERBOSE);
        OptionBuilder.withDescription((String)"Prints details of the plan that is being executed on the node.");
        Option verbose = OptionBuilder.create();
        DiskBalancerCLI.getQueryOptions().addOption(verbose);
    }

    private void addCancelCommands(Options opt) {
        OptionBuilder.withLongOpt((String)CANCEL);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Cancels a running plan using a plan file.");
        Option cancel = OptionBuilder.create();
        DiskBalancerCLI.getCancelOptions().addOption(cancel);
        opt.addOption(cancel);
        OptionBuilder.withLongOpt((String)NODE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Cancels a running plan using a plan ID and hostName");
        Option node = OptionBuilder.create();
        DiskBalancerCLI.getCancelOptions().addOption(node);
        opt.addOption(node);
    }

    private void addReportCommands(Options opt) {
        OptionBuilder.withLongOpt((String)REPORT);
        OptionBuilder.withDescription((String)"List nodes that will benefit from running DiskBalancer.");
        Option report = OptionBuilder.create();
        DiskBalancerCLI.getReportOptions().addOption(report);
        opt.addOption(report);
        Option top = new Option(TOP, true, "specify the number of nodes to be listed which has data imbalance.");
        DiskBalancerCLI.getReportOptions().addOption(top);
        opt.addOption(top);
        Option node = new Option(NODE, true, "Datanode address, it can be DataNodeID, IP or hostname.");
        DiskBalancerCLI.getReportOptions().addOption(node);
        opt.addOption(node);
    }

    private CommandLine parseArgs(String[] argv, Options opts) throws ParseException {
        BasicParser parser = new BasicParser();
        return parser.parse(opts, argv);
    }

    private int dispatch(CommandLine cmd, Options opts) throws Exception {
        Command currentCommand = null;
        if (cmd.hasOption(PLAN)) {
            currentCommand = new PlanCommand(this.getConf());
        }
        if (cmd.hasOption(EXECUTE)) {
            currentCommand = new ExecuteCommand(this.getConf());
        }
        if (cmd.hasOption(QUERY)) {
            currentCommand = new QueryCommand(this.getConf());
        }
        if (cmd.hasOption(CANCEL)) {
            currentCommand = new CancelCommand(this.getConf());
        }
        if (cmd.hasOption(REPORT)) {
            currentCommand = new ReportCommand(this.getConf(), this.printStream);
        }
        if (cmd.hasOption(HELP)) {
            currentCommand = new HelpCommand(this.getConf());
        }
        if (currentCommand == null) {
            new HelpCommand(this.getConf()).execute(null);
            return 1;
        }
        ((Command)currentCommand).execute(cmd);
        return 0;
    }
}

