/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command
extends Configured {
    static final Logger LOG = LoggerFactory.getLogger(Command.class);
    private Map<String, String> validArgs = new HashMap<String, String>();
    private URI clusterURI;
    private FileSystem fs = null;
    private DiskBalancerCluster cluster = null;
    private int topNodes;
    private static final Path DEFAULT_LOG_DIR = new Path("/system/diskbalancer");
    private Path diskBalancerLogs;

    public Command(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("help", "Help for this command");
        this.addValidCommandParameters("arg", "");
        this.topNodes = 0;
    }

    public abstract void execute(CommandLine var1) throws Exception;

    public abstract void printHelp();

    protected DiskBalancerCluster readClusterInfo(CommandLine cmd) throws Exception {
        Preconditions.checkNotNull((Object)cmd);
        this.setClusterURI(FileSystem.getDefaultUri((Configuration)this.getConf()));
        LOG.debug("using name node URI : {}", (Object)this.getClusterURI());
        ClusterConnector connector = ConnectorFactory.getCluster(this.clusterURI, this.getConf());
        this.cluster = new DiskBalancerCluster(connector);
        LOG.debug("Reading cluster info");
        this.cluster.readClusterInfo();
        return this.cluster;
    }

    protected void setOutputPath(String path) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MMM-dd-HH-mm-ss");
        Date now = new Date();
        this.fs = FileSystem.get((URI)this.getClusterURI(), (Configuration)this.getConf());
        this.diskBalancerLogs = path == null || path.isEmpty() ? (this.getClusterURI().getScheme().startsWith("file") ? new Path(System.getProperty("user.dir") + DEFAULT_LOG_DIR.toString() + "/" + format.format(now)) : new Path(DEFAULT_LOG_DIR.toString() + "/" + format.format(now))) : new Path(path);
        if (this.fs.exists(this.diskBalancerLogs)) {
            LOG.debug("Another Diskbalancer instance is running ? - Target Directory already exists. {}", (Object)this.diskBalancerLogs);
            throw new IOException("Another DiskBalancer files already exist at the target location. " + this.diskBalancerLogs.toString());
        }
        this.fs.mkdirs(this.diskBalancerLogs);
    }

    protected void setNodesToProcess(DiskBalancerDataNode node) {
        LinkedList<DiskBalancerDataNode> nodelist = new LinkedList<DiskBalancerDataNode>();
        nodelist.add(node);
        this.setNodesToProcess(nodelist);
    }

    protected void setNodesToProcess(List<DiskBalancerDataNode> nodes) {
        if (this.cluster == null) {
            throw new IllegalStateException("Set nodes to process invoked before initializing cluster. Illegal usage.");
        }
        this.cluster.setNodesToProcess(nodes);
    }

    DiskBalancerDataNode getNode(String nodeName) {
        DiskBalancerDataNode node = null;
        if (nodeName == null || nodeName.isEmpty()) {
            return node;
        }
        if (this.cluster.getNodes().size() == 0) {
            return node;
        }
        node = this.cluster.getNodeByName(nodeName);
        if (node != null) {
            return node;
        }
        node = this.cluster.getNodeByIPAddress(nodeName);
        if (node != null) {
            return node;
        }
        node = this.cluster.getNodeByUUID(nodeName);
        return node;
    }

    private Set<String> getNodeList(String listArg) throws IOException {
        String nodeData;
        TreeSet<String> resultSet = new TreeSet<String>();
        if (listArg == null || listArg.isEmpty()) {
            return resultSet;
        }
        if (listArg.startsWith("file://")) {
            URL listURL = new URL(listArg);
            byte[] data = Files.readAllBytes(Paths.get(listURL.getPath(), new String[0]));
            nodeData = new String(data, Charset.forName("UTF-8"));
        } else {
            nodeData = listArg;
        }
        String[] nodes = nodeData.split(",");
        Collections.addAll(resultSet, nodes);
        return resultSet;
    }

    protected void verifyCommandOptions(String commandName, CommandLine cmd) {
        for (Option opt : cmd) {
            if (this.validArgs.containsKey(opt.getArgName())) continue;
            String errMessage = String.format("%nInvalid argument found for command %s : %s%n", commandName, opt.getArgName());
            StringBuilder validArguments = new StringBuilder();
            validArguments.append("Valid arguments are : %n");
            for (Map.Entry<String, String> args : this.validArgs.entrySet()) {
                String key = args.getKey();
                String desc = args.getValue();
                String s = String.format("\t %s : %s %n", key, desc);
                validArguments.append(s);
            }
            LOG.error(errMessage + validArguments.toString());
            throw new IllegalArgumentException("Invalid Arguments found.");
        }
    }

    public URI getClusterURI() {
        return this.clusterURI;
    }

    public void setClusterURI(URI clusterURI) {
        this.clusterURI = clusterURI;
    }

    public ClientDatanodeProtocol getDataNodeProxy(String datanode) throws IOException {
        InetSocketAddress datanodeAddr = NetUtils.createSocketAddr((String)datanode);
        this.getConf().set("hadoop.security.service.user.name.key", this.getConf().get("dfs.datanode.kerberos.principal", ""));
        ClientDatanodeProtocol dnProtocol = DFSUtil.createClientDatanodeProtocolProxy(datanodeAddr, Command.getUGI(), this.getConf(), NetUtils.getSocketFactory((Configuration)this.getConf(), ClientDatanodeProtocol.class));
        return dnProtocol;
    }

    private static UserGroupInformation getUGI() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    protected FSDataOutputStream create(String fileName) throws IOException {
        Preconditions.checkNotNull((Object)fileName);
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
        return this.fs.create(new Path(this.diskBalancerLogs, fileName));
    }

    protected FSDataInputStream open(String fileName) throws IOException {
        Preconditions.checkNotNull((Object)fileName);
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
        return this.fs.open(new Path(fileName));
    }

    protected Path getOutputPath() {
        return this.diskBalancerLogs;
    }

    protected void addValidCommandParameters(String key, String desc) {
        this.validArgs.put(key, desc);
    }

    protected DiskBalancerCluster getCluster() {
        return this.cluster;
    }

    protected int getDefaultTop() {
        return 100;
    }

    protected void recordOutput(StrBuilder result, String outputLine) {
        LOG.info(outputLine);
        result.appendln(outputLine);
    }

    protected int parseTopNodes(CommandLine cmd, StrBuilder result) {
        String outputLine = "";
        int nodes = 0;
        String topVal = cmd.getOptionValue("top");
        if (StringUtils.isBlank((String)topVal)) {
            outputLine = String.format("No top limit specified, using default top value %d.", this.getDefaultTop());
            LOG.info(outputLine);
            result.appendln(outputLine);
            nodes = this.getDefaultTop();
        } else {
            try {
                nodes = Integer.parseInt(topVal);
            }
            catch (NumberFormatException nfe) {
                outputLine = String.format("Top limit input is not numeric, using default top value %d.", this.getDefaultTop());
                LOG.info(outputLine);
                result.appendln(outputLine);
                nodes = this.getDefaultTop();
            }
        }
        return Math.min(nodes, this.cluster.getNodes().size());
    }

    public void setTopNodes(int topNodes) {
        this.topNodes = topNodes;
    }

    public int getTopNodes() {
        return this.topNodes;
    }
}

