/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.VolumeFailureInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Time;

class FsVolumeList {
    private final CopyOnWriteArrayList<FsVolumeImpl> volumes = new CopyOnWriteArrayList();
    private final Map<String, VolumeFailureInfo> volumeFailureInfos = Collections.synchronizedMap(new TreeMap());
    private final ConcurrentLinkedQueue<FsVolumeImpl> volumesBeingRemoved = new ConcurrentLinkedQueue();
    private Object checkDirsMutex = new Object();
    private final VolumeChoosingPolicy<FsVolumeImpl> blockChooser;
    private final BlockScanner blockScanner;

    FsVolumeList(List<VolumeFailureInfo> initialVolumeFailureInfos, BlockScanner blockScanner, VolumeChoosingPolicy<FsVolumeImpl> blockChooser) {
        this.blockChooser = blockChooser;
        this.blockScanner = blockScanner;
        for (VolumeFailureInfo volumeFailureInfo : initialVolumeFailureInfos) {
            this.volumeFailureInfos.put(volumeFailureInfo.getFailedStorageLocation(), volumeFailureInfo);
        }
    }

    List<FsVolumeImpl> getVolumes() {
        return Collections.unmodifiableList(this.volumes);
    }

    private FsVolumeReference chooseVolume(List<FsVolumeImpl> list, long blockSize) throws IOException {
        while (true) {
            FsVolumeImpl volume = this.blockChooser.chooseVolume(list, blockSize);
            try {
                return volume.obtainReference();
            }
            catch (ClosedChannelException e) {
                FsDatasetImpl.LOG.warn((Object)("Chosen a closed volume: " + volume));
                list.remove(volume);
                continue;
            }
            break;
        }
    }

    FsVolumeReference getNextVolume(StorageType storageType, long blockSize) throws IOException {
        ArrayList<FsVolumeImpl> list = new ArrayList<FsVolumeImpl>(this.volumes.size());
        for (FsVolumeImpl v : this.volumes) {
            if (v.getStorageType() != storageType) continue;
            list.add(v);
        }
        return this.chooseVolume(list, blockSize);
    }

    FsVolumeReference getNextTransientVolume(long blockSize) throws IOException {
        List<FsVolumeImpl> curVolumes = this.getVolumes();
        ArrayList<FsVolumeImpl> list = new ArrayList<FsVolumeImpl>(curVolumes.size());
        for (FsVolumeImpl v : curVolumes) {
            if (!v.isTransientStorage()) continue;
            list.add(v);
        }
        return this.chooseVolume(list, blockSize);
    }

    long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            try {
                FsVolumeReference ref = v.obtainReference();
                Throwable throwable = null;
                try {
                    dfsUsed += v.getDfsUsed();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ref == null) continue;
                    if (throwable != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ref.close();
                }
            }
            catch (ClosedChannelException closedChannelException) {}
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            try {
                FsVolumeReference ref = v.obtainReference();
                Throwable throwable = null;
                try {
                    dfsUsed += v.getBlockPoolUsed(bpid);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ref == null) continue;
                    if (throwable != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ref.close();
                }
            }
            catch (ClosedChannelException closedChannelException) {}
        }
        return dfsUsed;
    }

    long getCapacity() {
        long capacity = 0L;
        for (FsVolumeImpl v : this.volumes) {
            try {
                FsVolumeReference ref = v.obtainReference();
                Throwable throwable = null;
                try {
                    capacity += v.getCapacity();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ref == null) continue;
                    if (throwable != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ref.close();
                }
            }
            catch (IOException iOException) {}
        }
        return capacity;
    }

    long getRemaining() throws IOException {
        long remaining = 0L;
        for (FsVolumeSpi fsVolumeSpi : this.volumes) {
            try {
                FsVolumeReference ref = fsVolumeSpi.obtainReference();
                Throwable throwable = null;
                try {
                    remaining += fsVolumeSpi.getAvailable();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ref == null) continue;
                    if (throwable != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ref.close();
                }
            }
            catch (ClosedChannelException closedChannelException) {}
        }
        return remaining;
    }

    void getAllVolumesMap(final String bpid, final ReplicaMap volumeMap, final RamDiskReplicaTracker ramDiskReplicaMap) throws IOException {
        long totalStartTime = Time.monotonicNow();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<1> replicaAddingThreads = new ArrayList<1>();
        for (final FsVolumeImpl fsVolumeImpl : this.volumes) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try (FsVolumeReference ref = fsVolumeImpl.obtainReference();){
                        FsDatasetImpl.LOG.info((Object)("Adding replicas to map for block pool " + bpid + " on volume " + fsVolumeImpl + "..."));
                        long startTime = Time.monotonicNow();
                        fsVolumeImpl.getVolumeMap(bpid, volumeMap, ramDiskReplicaMap);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info((Object)("Time to add replicas to map for block pool " + bpid + " on volume " + fsVolumeImpl + ": " + timeTaken + "ms"));
                    }
                    catch (ClosedChannelException e) {
                        FsDatasetImpl.LOG.info((Object)("The volume " + fsVolumeImpl + " is closed while " + "addng replicas, ignored."));
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info((Object)("Caught exception while adding replicas from " + fsVolumeImpl + ". Will throw later."), (Throwable)ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            replicaAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : replicaAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info((Object)("Total time to add all replicas to map: " + totalTimeTaken + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<File> checkDirs() {
        Object object = this.checkDirsMutex;
        synchronized (object) {
            HashSet<File> failedVols = null;
            List<FsVolumeImpl> volumeList = this.getVolumes();
            for (FsVolumeImpl fsv : volumeList) {
                try {
                    FsVolumeReference ref = fsv.obtainReference();
                    Throwable throwable = null;
                    try {
                        fsv.checkDirs();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ref == null) continue;
                        if (throwable != null) {
                            try {
                                ref.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        ref.close();
                    }
                }
                catch (DiskChecker.DiskErrorException e) {
                    FsDatasetImpl.LOG.warn((Object)("Removing failed volume " + fsv + ": "), (Throwable)e);
                    if (failedVols == null) {
                        failedVols = new HashSet<File>(1);
                    }
                    failedVols.add(new File(fsv.getBasePath()).getAbsoluteFile());
                    this.addVolumeFailureInfo(fsv);
                    this.removeVolume(fsv);
                }
                catch (ClosedChannelException e) {
                    FsDatasetImpl.LOG.debug((Object)"Caught exception when obtaining reference count on closed volume", (Throwable)e);
                }
                catch (IOException e) {
                    FsDatasetImpl.LOG.error((Object)"Unexpected IOException", (Throwable)e);
                }
            }
            if (failedVols != null && failedVols.size() > 0) {
                FsDatasetImpl.LOG.warn((Object)("Completed checkDirs. Found " + failedVols.size() + " failure volumes."));
            }
            this.waitVolumeRemoved(5000, this.checkDirsMutex);
            return failedVols;
        }
    }

    void waitVolumeRemoved(int sleepMillis, Object monitor) {
        while (!this.checkVolumesRemoved()) {
            if (FsDatasetImpl.LOG.isDebugEnabled()) {
                FsDatasetImpl.LOG.debug((Object)"Waiting for volume reference to be released.");
            }
            try {
                monitor.wait(sleepMillis);
            }
            catch (InterruptedException e) {
                FsDatasetImpl.LOG.info((Object)"Thread interrupted when waiting for volume reference to be released.");
                Thread.currentThread().interrupt();
            }
        }
        FsDatasetImpl.LOG.info((Object)"Volume reference is released.");
    }

    public String toString() {
        return this.volumes.toString();
    }

    void addVolume(FsVolumeReference ref) {
        FsVolumeImpl volume = (FsVolumeImpl)ref.getVolume();
        this.volumes.add(volume);
        if (this.blockScanner != null) {
            this.blockScanner.addVolumeScanner(ref);
        } else {
            IOUtils.cleanup((Log)FsDatasetImpl.LOG, (Closeable[])new Closeable[]{ref});
        }
        this.removeVolumeFailureInfo(new File(volume.getBasePath()));
        FsDatasetImpl.LOG.info((Object)("Added new volume: " + volume.getStorageID()));
    }

    private void removeVolume(FsVolumeImpl target) {
        if (this.volumes.remove(target)) {
            if (this.blockScanner != null) {
                this.blockScanner.removeVolumeScanner(target);
            }
            try {
                target.setClosed();
            }
            catch (IOException e) {
                FsDatasetImpl.LOG.warn((Object)("Error occurs when waiting volume to close: " + target), (Throwable)e);
            }
            target.shutdown();
            this.volumesBeingRemoved.add(target);
            FsDatasetImpl.LOG.info((Object)("Removed volume: " + target));
        } else if (FsDatasetImpl.LOG.isDebugEnabled()) {
            FsDatasetImpl.LOG.debug((Object)("Volume " + target + " does not exist or is removed by others."));
        }
    }

    void removeVolume(File volume, boolean clearFailure) {
        for (FsVolumeImpl fsVolume : this.volumes) {
            String targetPath;
            String basePath = new File(fsVolume.getBasePath()).getAbsolutePath();
            if (!basePath.equals(targetPath = volume.getAbsolutePath())) continue;
            this.removeVolume(fsVolume);
        }
        if (clearFailure) {
            this.removeVolumeFailureInfo(volume);
        }
    }

    VolumeFailureInfo[] getVolumeFailureInfos() {
        Collection<VolumeFailureInfo> infos = this.volumeFailureInfos.values();
        return infos.toArray(new VolumeFailureInfo[infos.size()]);
    }

    boolean checkVolumesRemoved() {
        Iterator<FsVolumeImpl> it = this.volumesBeingRemoved.iterator();
        while (it.hasNext()) {
            FsVolumeImpl volume = it.next();
            if (!volume.checkClosed()) {
                return false;
            }
            it.remove();
        }
        return true;
    }

    void addVolumeFailureInfo(VolumeFailureInfo volumeFailureInfo) {
        if (!this.volumeFailureInfos.containsKey(volumeFailureInfo.getFailedStorageLocation())) {
            this.volumeFailureInfos.put(volumeFailureInfo.getFailedStorageLocation(), volumeFailureInfo);
        }
    }

    private void addVolumeFailureInfo(FsVolumeImpl vol) {
        this.addVolumeFailureInfo(new VolumeFailureInfo(new File(vol.getBasePath()).getAbsolutePath(), Time.now(), vol.getCapacity()));
    }

    void removeVolumeFailureInfo(File vol) {
        this.volumeFailureInfos.remove(vol.getAbsolutePath());
    }

    void addBlockPool(final String bpid, final Configuration conf) throws IOException {
        long totalStartTime = Time.monotonicNow();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<2> blockPoolAddingThreads = new ArrayList<2>();
        for (final FsVolumeImpl fsVolumeImpl : this.volumes) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try (FsVolumeReference ref2 = fsVolumeImpl.obtainReference();){
                        FsDatasetImpl.LOG.info((Object)("Scanning block pool " + bpid + " on volume " + fsVolumeImpl + "..."));
                        long startTime = Time.monotonicNow();
                        fsVolumeImpl.addBlockPool(bpid, conf);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info((Object)("Time taken to scan block pool " + bpid + " on " + fsVolumeImpl + ": " + timeTaken + "ms"));
                    }
                    catch (ClosedChannelException ref2) {
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info((Object)("Caught exception while scanning " + fsVolumeImpl + ". Will throw later."), (Throwable)ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            blockPoolAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : blockPoolAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info((Object)("Total time to scan all replicas for block pool " + bpid + ": " + totalTimeTaken + "ms"));
    }

    void removeBlockPool(String bpid) {
        for (FsVolumeImpl v : this.volumes) {
            v.shutdownBlockPool(bpid);
        }
    }

    void shutdown() {
        for (FsVolumeImpl volume : this.volumes) {
            if (volume == null) continue;
            volume.shutdown();
        }
    }
}

