/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import com.cloudera.org.codehaus.jackson.JsonFactory;
import com.cloudera.org.codehaus.jackson.map.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.client.protocol.DatanodeAdminProperties;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileReader {
    private CombinedHostsFileReader() {
    }

    public static Set<DatanodeAdminProperties> readFile(String hostsFile) throws IOException {
        HashSet<DatanodeAdminProperties> allDNs = new HashSet<DatanodeAdminProperties>();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(hostsFile), "UTF-8");){
            Iterator iterator = mapper.readValues(new JsonFactory().createJsonParser(input), DatanodeAdminProperties.class);
            while (iterator.hasNext()) {
                DatanodeAdminProperties properties = (DatanodeAdminProperties)iterator.next();
                allDNs.add(properties);
            }
        }
        return allDNs;
    }
}

