/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.OptionsParser;
import org.apache.hadoop.tools.util.DistCpUtils;

public class DistCpOptions {
    private boolean atomicCommit = false;
    private boolean syncFolder = false;
    private boolean deleteMissing = false;
    private boolean ignoreFailures = false;
    private boolean overwrite = false;
    private boolean append = false;
    private boolean skipCRC = false;
    private boolean blocking = true;
    private boolean useDiff = false;
    private boolean useRdiff = false;
    public static final int maxNumListstatusThreads = 40;
    private int numListstatusThreads = 0;
    private int maxMaps = 20;
    private int mapBandwidth = 100;
    private String sslConfigurationFile;
    private String copyStrategy = "uniformsize";
    private EnumSet<FileAttribute> preserveStatus = EnumSet.noneOf(FileAttribute.class);
    private boolean preserveRawXattrs;
    private Path atomicWorkPath;
    private Path logPath;
    private Path sourceFileListing;
    private List<Path> sourcePaths;
    private String fromSnapshot;
    private String toSnapshot;
    private Path targetPath;
    private String filtersFile;
    private boolean targetPathExists = true;
    private int blocksPerChunk = 0;

    public DistCpOptions(List<Path> sourcePaths, Path targetPath) {
        assert (sourcePaths != null && !sourcePaths.isEmpty()) : "Invalid source paths";
        assert (targetPath != null) : "Invalid Target path";
        this.sourcePaths = sourcePaths;
        this.targetPath = targetPath;
    }

    public DistCpOptions(Path sourceFileListing, Path targetPath) {
        assert (sourceFileListing != null) : "Invalid source paths";
        assert (targetPath != null) : "Invalid Target path";
        this.sourceFileListing = sourceFileListing;
        this.targetPath = targetPath;
    }

    public DistCpOptions(DistCpOptions that) {
        if (this != that && that != null) {
            this.atomicCommit = that.atomicCommit;
            this.syncFolder = that.syncFolder;
            this.deleteMissing = that.deleteMissing;
            this.ignoreFailures = that.ignoreFailures;
            this.overwrite = that.overwrite;
            this.skipCRC = that.skipCRC;
            this.blocking = that.blocking;
            this.useDiff = that.useDiff;
            this.useRdiff = that.useRdiff;
            this.numListstatusThreads = that.numListstatusThreads;
            this.maxMaps = that.maxMaps;
            this.mapBandwidth = that.mapBandwidth;
            this.sslConfigurationFile = that.getSslConfigurationFile();
            this.copyStrategy = that.copyStrategy;
            this.preserveStatus = that.preserveStatus;
            this.preserveRawXattrs = that.preserveRawXattrs;
            this.atomicWorkPath = that.getAtomicWorkPath();
            this.logPath = that.getLogPath();
            this.sourceFileListing = that.getSourceFileListing();
            this.sourcePaths = that.getSourcePaths();
            this.targetPath = that.getTargetPath();
            this.targetPathExists = that.getTargetPathExists();
            this.filtersFile = that.getFiltersFile();
            this.blocksPerChunk = that.blocksPerChunk;
        }
    }

    public boolean shouldAtomicCommit() {
        return this.atomicCommit;
    }

    public void setAtomicCommit(boolean atomicCommit) {
        this.validate(DistCpOptionSwitch.ATOMIC_COMMIT, atomicCommit);
        this.atomicCommit = atomicCommit;
    }

    public boolean shouldSyncFolder() {
        return this.syncFolder;
    }

    public void setSyncFolder(boolean syncFolder) {
        this.validate(DistCpOptionSwitch.SYNC_FOLDERS, syncFolder);
        this.syncFolder = syncFolder;
    }

    public boolean shouldDeleteMissing() {
        return this.deleteMissing;
    }

    public void setDeleteMissing(boolean deleteMissing) {
        this.validate(DistCpOptionSwitch.DELETE_MISSING, deleteMissing);
        this.deleteMissing = deleteMissing;
        this.ignoreDeleteMissingIfUseSnapshotDiff();
    }

    private void ignoreDeleteMissingIfUseSnapshotDiff() {
        if (this.deleteMissing && (this.useDiff || this.useRdiff)) {
            OptionsParser.LOG.warn((Object)"-delete and -diff/-rdiff are mutually exclusive. The -delete option will be ignored.");
            this.deleteMissing = false;
        }
    }

    public boolean shouldIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public boolean shouldBlock() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean shouldOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.validate(DistCpOptionSwitch.OVERWRITE, overwrite);
        this.overwrite = overwrite;
    }

    public boolean shouldAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.validate(DistCpOptionSwitch.APPEND, append);
        this.append = append;
    }

    public boolean shouldUseDiff() {
        return this.useDiff;
    }

    public boolean shouldUseRdiff() {
        return this.useRdiff;
    }

    public boolean shouldUseSnapshotDiff() {
        return this.shouldUseDiff() || this.shouldUseRdiff();
    }

    public String getFromSnapshot() {
        return this.fromSnapshot;
    }

    public String getToSnapshot() {
        return this.toSnapshot;
    }

    public void setUseDiff(String fromSS, String toSS) {
        this.fromSnapshot = fromSS;
        this.toSnapshot = toSS;
        this.validate(DistCpOptionSwitch.DIFF, true);
        this.useDiff = true;
        this.ignoreDeleteMissingIfUseSnapshotDiff();
    }

    public void setUseRdiff(String fromSS, String toSS) {
        this.fromSnapshot = fromSS;
        this.toSnapshot = toSS;
        this.validate(DistCpOptionSwitch.RDIFF, true);
        this.useRdiff = true;
        this.ignoreDeleteMissingIfUseSnapshotDiff();
    }

    public boolean shouldSkipCRC() {
        return this.skipCRC;
    }

    public void setSkipCRC(boolean skipCRC) {
        this.validate(DistCpOptionSwitch.SKIP_CRC, skipCRC);
        this.skipCRC = skipCRC;
    }

    public int getNumListstatusThreads() {
        return this.numListstatusThreads;
    }

    public void setNumListstatusThreads(int numThreads) {
        this.numListstatusThreads = numThreads > 40 ? 40 : (numThreads > 0 ? numThreads : 0);
    }

    public int getMaxMaps() {
        return this.maxMaps;
    }

    public void setMaxMaps(int maxMaps) {
        this.maxMaps = Math.max(maxMaps, 1);
    }

    public int getMapBandwidth() {
        return this.mapBandwidth;
    }

    public void setMapBandwidth(int mapBandwidth) {
        assert (mapBandwidth > 0) : "Bandwidth " + mapBandwidth + " is invalid (should be > 0)";
        this.mapBandwidth = mapBandwidth;
    }

    public String getSslConfigurationFile() {
        return this.sslConfigurationFile;
    }

    public void setSslConfigurationFile(String sslConfigurationFile) {
        this.sslConfigurationFile = sslConfigurationFile;
    }

    public Iterator<FileAttribute> preserveAttributes() {
        return this.preserveStatus.iterator();
    }

    public boolean shouldPreserve(FileAttribute attribute) {
        return this.preserveStatus.contains((Object)attribute);
    }

    public void preserve(FileAttribute fileAttribute) {
        for (FileAttribute attribute : this.preserveStatus) {
            if (!attribute.equals((Object)fileAttribute)) continue;
            return;
        }
        this.preserveStatus.add(fileAttribute);
    }

    public boolean shouldPreserveRawXattrs() {
        return this.preserveRawXattrs;
    }

    public void preserveRawXattrs() {
        this.preserveRawXattrs = true;
    }

    public Path getAtomicWorkPath() {
        return this.atomicWorkPath;
    }

    public void setAtomicWorkPath(Path atomicWorkPath) {
        this.atomicWorkPath = atomicWorkPath;
    }

    public Path getLogPath() {
        return this.logPath;
    }

    public void setLogPath(Path logPath) {
        this.logPath = logPath;
    }

    public String getCopyStrategy() {
        return this.copyStrategy;
    }

    public void setCopyStrategy(String copyStrategy) {
        this.copyStrategy = copyStrategy;
    }

    public Path getSourceFileListing() {
        return this.sourceFileListing;
    }

    public List<Path> getSourcePaths() {
        return this.sourcePaths;
    }

    public void setSourcePaths(List<Path> sourcePaths) {
        assert (sourcePaths != null && sourcePaths.size() != 0);
        this.sourcePaths = sourcePaths;
    }

    public Path getTargetPath() {
        return this.targetPath;
    }

    public boolean getTargetPathExists() {
        return this.targetPathExists;
    }

    public boolean setTargetPathExists(boolean targetPathExists) {
        this.targetPathExists = targetPathExists;
        return this.targetPathExists;
    }

    public final String getFiltersFile() {
        return this.filtersFile;
    }

    public final void setFiltersFile(String filtersFilename) {
        this.filtersFile = filtersFilename;
    }

    public final void setBlocksPerChunk(int csize) {
        this.blocksPerChunk = csize;
    }

    public final int getBlocksPerChunk() {
        return this.blocksPerChunk;
    }

    public final boolean splitLargeFile() {
        return this.blocksPerChunk > 0;
    }

    public void validate(DistCpOptionSwitch option, boolean value) {
        boolean useRdiff;
        boolean syncFolder = option == DistCpOptionSwitch.SYNC_FOLDERS ? value : this.syncFolder;
        boolean overwrite = option == DistCpOptionSwitch.OVERWRITE ? value : this.overwrite;
        boolean deleteMissing = option == DistCpOptionSwitch.DELETE_MISSING ? value : this.deleteMissing;
        boolean atomicCommit = option == DistCpOptionSwitch.ATOMIC_COMMIT ? value : this.atomicCommit;
        boolean skipCRC = option == DistCpOptionSwitch.SKIP_CRC ? value : this.skipCRC;
        boolean append = option == DistCpOptionSwitch.APPEND ? value : this.append;
        boolean useDiff = option == DistCpOptionSwitch.DIFF ? value : this.useDiff;
        boolean bl = useRdiff = option == DistCpOptionSwitch.RDIFF ? value : this.useRdiff;
        if (syncFolder && atomicCommit) {
            throw new IllegalArgumentException("Atomic commit can't be used with sync folder or overwrite options");
        }
        if (deleteMissing && !overwrite && !syncFolder) {
            throw new IllegalArgumentException("Delete missing is applicable only with update or overwrite options");
        }
        if (overwrite && syncFolder) {
            throw new IllegalArgumentException("Overwrite and update options are mutually exclusive");
        }
        if (!syncFolder && skipCRC) {
            throw new IllegalArgumentException("Skip CRC is valid only with update options");
        }
        if (!syncFolder && append) {
            throw new IllegalArgumentException("Append is valid only with update options");
        }
        if (skipCRC && append) {
            throw new IllegalArgumentException("Append is disallowed when skipping CRC");
        }
        if (!syncFolder && (useDiff || useRdiff)) {
            throw new IllegalArgumentException("-diff/-rdiff is valid only with -update option");
        }
        if ((useDiff || useRdiff) && (StringUtils.isBlank((String)this.fromSnapshot) || StringUtils.isBlank((String)this.toSnapshot))) {
            throw new IllegalArgumentException("Must provide both the starting and ending snapshot names for -diff/-rdiff");
        }
        if (useDiff && useRdiff) {
            throw new IllegalArgumentException("-diff and -rdiff are mutually exclusive");
        }
    }

    public void appendToConf(Configuration conf) {
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.ATOMIC_COMMIT, String.valueOf(this.atomicCommit));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.IGNORE_FAILURES, String.valueOf(this.ignoreFailures));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.SYNC_FOLDERS, String.valueOf(this.syncFolder));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.DELETE_MISSING, String.valueOf(this.deleteMissing));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.OVERWRITE, String.valueOf(this.overwrite));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.APPEND, String.valueOf(this.append));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.DIFF, String.valueOf(this.useDiff));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.RDIFF, String.valueOf(this.useRdiff));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.SKIP_CRC, String.valueOf(this.skipCRC));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.BANDWIDTH, String.valueOf(this.mapBandwidth));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.PRESERVE_STATUS, DistCpUtils.packAttributes(this.preserveStatus));
        if (this.filtersFile != null) {
            DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.FILTERS, this.filtersFile);
        }
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.BLOCKS_PER_CHUNK, String.valueOf(this.blocksPerChunk));
    }

    public String toString() {
        return "DistCpOptions{atomicCommit=" + this.atomicCommit + ", syncFolder=" + this.syncFolder + ", deleteMissing=" + this.deleteMissing + ", ignoreFailures=" + this.ignoreFailures + ", overwrite=" + this.overwrite + ", append=" + this.append + ", useDiff=" + this.useDiff + ", useRdiff=" + this.useRdiff + ", fromSnapshot=" + this.fromSnapshot + ", toSnapshot=" + this.toSnapshot + ", skipCRC=" + this.skipCRC + ", blocking=" + this.blocking + ", numListstatusThreads=" + this.numListstatusThreads + ", maxMaps=" + this.maxMaps + ", mapBandwidth=" + this.mapBandwidth + ", sslConfigurationFile='" + this.sslConfigurationFile + '\'' + ", copyStrategy='" + this.copyStrategy + '\'' + ", preserveStatus=" + this.preserveStatus + ", preserveRawXattrs=" + this.preserveRawXattrs + ", atomicWorkPath=" + this.atomicWorkPath + ", logPath=" + this.logPath + ", sourceFileListing=" + this.sourceFileListing + ", sourcePaths=" + this.sourcePaths + ", targetPath=" + this.targetPath + ", targetPathExists=" + this.targetPathExists + ", filtersFile='" + this.filtersFile + '\'' + ", blocksPerChunk=" + this.blocksPerChunk + '}';
    }

    protected DistCpOptions clone() throws CloneNotSupportedException {
        return (DistCpOptions)super.clone();
    }

    public static enum FileAttribute {
        REPLICATION,
        BLOCKSIZE,
        USER,
        GROUP,
        PERMISSION,
        CHECKSUMTYPE,
        ACL,
        XATTR,
        TIMES;


        public static FileAttribute getAttribute(char symbol) {
            for (FileAttribute attribute : FileAttribute.values()) {
                if (attribute.name().charAt(0) != Character.toUpperCase(symbol)) continue;
                return attribute;
            }
            throw new NoSuchElementException("No attribute for " + symbol);
        }
    }
}

