/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.shaded.org.apache.kerby.util.Base64;

public class PublicKeyReader {
    public static PublicKey loadPublicKey(InputStream in) throws Exception {
        byte[] keyBytes = IOUtils.toByteArray(in);
        try {
            return PublicKeyReader.loadPublicKey(keyBytes);
        }
        catch (InvalidKeySpecException ex) {
            Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(keyBytes));
            return cert.getPublicKey();
        }
    }

    public static PublicKey loadPublicKey(byte[] publicKeyBytes) throws Exception {
        String pubKey = new String(publicKeyBytes, StandardCharsets.UTF_8);
        if (pubKey.startsWith("-----BEGIN PUBLIC KEY-----")) {
            pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
            pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
            Base64 base64 = new Base64();
            byte[] buffer = base64.decode(pubKey.trim());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return keyFactory.generatePublic(keySpec);
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        return keyFactory.generatePublic(keySpec);
    }
}

