/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.tukaani.xz;

import java.io.IOException;
import org.apache.hadoop.shaded.org.tukaani.xz.DeltaOptions;
import org.apache.hadoop.shaded.org.tukaani.xz.FinishableOutputStream;
import org.apache.hadoop.shaded.org.tukaani.xz.XZIOException;
import org.apache.hadoop.shaded.org.tukaani.xz.delta.DeltaEncoder;

class DeltaOutputStream
extends FinishableOutputStream {
    private static final int TMPBUF_SIZE = 4096;
    private FinishableOutputStream out;
    private final DeltaEncoder delta;
    private final byte[] tmpbuf = new byte[4096];
    private boolean finished = false;
    private IOException exception = null;

    static int getMemoryUsage() {
        return 5;
    }

    DeltaOutputStream(FinishableOutputStream finishableOutputStream, DeltaOptions deltaOptions) {
        this.out = finishableOutputStream;
        this.delta = new DeltaEncoder(deltaOptions.getDistance());
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished");
        }
        try {
            while (n2 > 4096) {
                this.delta.encode(byArray, n, 4096, this.tmpbuf);
                this.out.write(this.tmpbuf);
                n += 4096;
                n2 -= 4096;
            }
            this.delta.encode(byArray, n, n2, this.tmpbuf);
            this.out.write(this.tmpbuf, 0, n2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                this.out.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            block4: {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block4;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

