/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSSigner;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.ECDSA;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.ECDSAProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.ECKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDSASigner
extends ECDSAProvider
implements JWSSigner {
    private final PrivateKey privateKey;

    public ECDSASigner(ECPrivateKey privateKey) throws JOSEException {
        super(ECDSA.resolveAlgorithm(privateKey));
        this.privateKey = privateKey;
    }

    public ECDSASigner(PrivateKey privateKey, ECKey.Curve curve) throws JOSEException {
        super(ECDSA.resolveAlgorithm(curve));
        if (!"EC".equalsIgnoreCase(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("The private key algorithm must be EC");
        }
        this.privateKey = privateKey;
    }

    public ECDSASigner(ECKey ecJWK) throws JOSEException {
        super(ECDSA.resolveAlgorithm(ecJWK.getCurve()));
        if (!ecJWK.isPrivate()) {
            throw new JOSEException("The EC JWK doesn't contain a private part");
        }
        this.privateKey = ecJWK.toPrivateKey();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        byte[] jcaSignature;
        JWSAlgorithm alg = header.getAlgorithm();
        if (!this.supportedJWSAlgorithms().contains(alg)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(alg, this.supportedJWSAlgorithms()));
        }
        try {
            Signature dsa = ECDSA.getSignerAndVerifier(alg, this.getJCAContext().getProvider());
            dsa.initSign(this.privateKey, this.getJCAContext().getSecureRandom());
            dsa.update(signingInput);
            jcaSignature = dsa.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        int rsByteArrayLength = ECDSA.getSignatureByteArrayLength(header.getAlgorithm());
        byte[] jwsSignature = ECDSA.transcodeSignatureToConcat(jcaSignature, rsByteArrayLength);
        return Base64URL.encode(jwsSignature);
    }
}

