/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueStateManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.security.AppPriorityACLsManager;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CapacitySchedulerQueueManager
implements SchedulerQueueManager<CSQueue, CapacitySchedulerConfiguration> {
    private static final Log LOG = LogFactory.getLog(CapacitySchedulerQueueManager.class);
    static final Comparator<CSQueue> NON_PARTITIONED_QUEUE_COMPARATOR = new Comparator<CSQueue>(){

        @Override
        public int compare(CSQueue q1, CSQueue q2) {
            int result = Float.compare(q1.getUsedCapacity(), q2.getUsedCapacity());
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return q1.getQueuePath().compareTo(q2.getQueuePath());
        }
    };
    private static final QueueHook NOOP = new QueueHook();
    private CapacitySchedulerContext csContext;
    private final YarnAuthorizationProvider authorizer;
    private final Map<String, CSQueue> queues = new ConcurrentHashMap<String, CSQueue>();
    private CSQueue root;
    private final RMNodeLabelsManager labelManager;
    private AppPriorityACLsManager appPriorityACLManager;
    private QueueStateManager<CSQueue, CapacitySchedulerConfiguration> queueStateManager;

    public CapacitySchedulerQueueManager(Configuration conf, RMNodeLabelsManager labelManager, AppPriorityACLsManager appPriorityACLManager) {
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
        this.labelManager = labelManager;
        this.queueStateManager = new QueueStateManager();
        this.appPriorityACLManager = appPriorityACLManager;
    }

    @Override
    public CSQueue getRootQueue() {
        return this.root;
    }

    @Override
    public Map<String, CSQueue> getQueues() {
        return this.queues;
    }

    @Override
    public void removeQueue(String queueName) {
        this.queues.remove(queueName);
    }

    @Override
    public void addQueue(String queueName, CSQueue queue) {
        this.queues.put(queueName, queue);
    }

    @Override
    public CSQueue getQueue(String queueName) {
        return this.queues.get(queueName);
    }

    public void setCapacitySchedulerContext(CapacitySchedulerContext capacitySchedulerContext) {
        this.csContext = capacitySchedulerContext;
    }

    public void initializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        this.root = CapacitySchedulerQueueManager.parseQueue(this.csContext, conf, null, "root", this.queues, this.queues, NOOP);
        CapacitySchedulerQueueManager.setQueueAcls(this.authorizer, this.appPriorityACLManager, this.queues);
        this.labelManager.reinitializeQueueLabels(this.getQueueToLabels());
        this.queueStateManager.initialize(this);
        LOG.info((Object)("Initialized root queue " + this.root));
    }

    @Override
    public void reinitializeQueues(CapacitySchedulerConfiguration newConf) throws IOException {
        HashMap<String, CSQueue> newQueues = new HashMap<String, CSQueue>();
        CSQueue newRoot = CapacitySchedulerQueueManager.parseQueue(this.csContext, newConf, null, "root", newQueues, this.queues, NOOP);
        if (!this.csContext.isConfigurationMutable() || this.csContext.getRMContext().getHAServiceState() != HAServiceProtocol.HAServiceState.STANDBY) {
            this.validateQueueHierarchy(this.queues, newQueues);
        }
        this.updateQueues(this.queues, newQueues);
        this.root.reinitialize(newRoot, this.csContext.getClusterResource());
        CapacitySchedulerQueueManager.setQueueAcls(this.authorizer, this.appPriorityACLManager, this.queues);
        Resource clusterResource = this.csContext.getClusterResource();
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        this.labelManager.reinitializeQueueLabels(this.getQueueToLabels());
        this.queueStateManager.initialize(this);
    }

    static CSQueue parseQueue(CapacitySchedulerContext csContext, CapacitySchedulerConfiguration conf, CSQueue parent, String queueName, Map<String, CSQueue> queues, Map<String, CSQueue> oldQueues, QueueHook hook) throws IOException {
        CSQueue queue;
        String fullQueueName = parent == null ? queueName : parent.getQueuePath() + "." + queueName;
        String[] childQueueNames = conf.getQueues(fullQueueName);
        boolean isReservableQueue = conf.isReservable(fullQueueName);
        boolean isAutoCreateEnabled = conf.isAutoCreateChildQueueEnabled(fullQueueName);
        if (childQueueNames == null || childQueueNames.length == 0) {
            if (null == parent) {
                throw new IllegalStateException("Queue configuration missing child queue names for " + queueName);
            }
            if (isReservableQueue) {
                queue = new PlanQueue(csContext, queueName, parent, oldQueues.get(queueName));
                String defReservationId = queueName + "-default";
                ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
                ReservationQueue resQueue = new ReservationQueue(csContext, defReservationId, (PlanQueue)queue);
                try {
                    resQueue.setEntitlement(new QueueEntitlement(1.0f, 1.0f));
                }
                catch (SchedulerDynamicEditException e) {
                    throw new IllegalStateException((Throwable)((Object)e));
                }
                childQueues.add(resQueue);
                ((ParentQueue)queue).setChildQueues(childQueues);
                queues.put(defReservationId, resQueue);
            } else if (isAutoCreateEnabled) {
                queue = new ManagedParentQueue(csContext, queueName, parent, oldQueues.get(queueName));
            } else {
                queue = new LeafQueue(csContext, queueName, parent, oldQueues.get(queueName));
                queue = hook.hook(queue);
            }
        } else {
            if (isReservableQueue) {
                throw new IllegalStateException("Only Leaf Queues can be reservable for " + queueName);
            }
            ParentQueue parentQueue = isAutoCreateEnabled ? new ManagedParentQueue(csContext, queueName, parent, oldQueues.get(queueName)) : new ParentQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook(parentQueue);
            ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
            for (String childQueueName : childQueueNames) {
                CSQueue childQueue = CapacitySchedulerQueueManager.parseQueue(csContext, conf, queue, childQueueName, queues, oldQueues, hook);
                childQueues.add(childQueue);
            }
            parentQueue.setChildQueues(childQueues);
        }
        if (queue instanceof LeafQueue && queues.containsKey(queueName) && queues.get(queueName) instanceof LeafQueue) {
            throw new IOException("Two leaf queues were named " + queueName + ". Leaf queue names must be distinct");
        }
        queues.put(queueName, queue);
        LOG.info((Object)("Initialized queue: " + queue));
        return queue;
    }

    private void validateQueueHierarchy(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) throws IOException {
        for (Map.Entry<String, CSQueue> e : queues.entrySet()) {
            if (AbstractAutoCreatedLeafQueue.class.isAssignableFrom(e.getValue().getClass())) continue;
            String queueName = e.getKey();
            CSQueue oldQueue = e.getValue();
            CSQueue newQueue = newQueues.get(queueName);
            if (null == newQueue) {
                if (oldQueue.getState() == QueueState.STOPPED) {
                    LOG.info((Object)("Deleting Queue " + queueName + ", as it is not" + " present in the modified capacity configuration xml"));
                    continue;
                }
                throw new IOException(oldQueue.getQueuePath() + " is deleted from" + " the new capacity scheduler configuration, but the" + " queue is not yet in stopped state. " + "Current State : " + oldQueue.getState());
            }
            if (!oldQueue.getQueuePath().equals(newQueue.getQueuePath())) {
                throw new IOException(queueName + " is moved from:" + oldQueue.getQueuePath() + " to:" + newQueue.getQueuePath() + " after refresh, which is not allowed.");
            }
            if (oldQueue instanceof ParentQueue && !(oldQueue instanceof ManagedParentQueue) && newQueue instanceof ManagedParentQueue) {
                throw new IOException("Can not convert parent queue: " + oldQueue.getQueuePath() + " to auto create enabled parent queue since " + "it could have other pre-configured queues which is not " + "supported");
            }
            if (oldQueue instanceof ManagedParentQueue && !(newQueue instanceof ManagedParentQueue)) {
                throw new IOException("Cannot convert auto create enabled parent queue: " + oldQueue.getQueuePath() + " to leaf queue. Please check " + " parent queue's configuration " + "auto-create-child-queue.enabled" + " is set to true");
            }
            if (oldQueue instanceof LeafQueue && newQueue instanceof ParentQueue) {
                if (oldQueue.getState() == QueueState.STOPPED) {
                    LOG.info((Object)("Converting the leaf queue: " + oldQueue.getQueuePath() + " to parent queue."));
                    continue;
                }
                throw new IOException("Can not convert the leaf queue: " + oldQueue.getQueuePath() + " to parent queue since " + "it is not yet in stopped state. Current State : " + oldQueue.getState());
            }
            if (!(oldQueue instanceof ParentQueue) || !(newQueue instanceof LeafQueue)) continue;
            LOG.info((Object)("Converting the parent queue: " + oldQueue.getQueuePath() + " to leaf queue."));
        }
    }

    private void updateQueues(Map<String, CSQueue> existingQueues, Map<String, CSQueue> newQueues) {
        String queueName;
        CapacitySchedulerConfiguration conf = this.csContext.getConfiguration();
        for (Map.Entry<String, CSQueue> e : newQueues.entrySet()) {
            queueName = e.getKey();
            CSQueue queue = e.getValue();
            if (existingQueues.containsKey(queueName)) continue;
            existingQueues.put(queueName, queue);
        }
        Iterator<Map.Entry<String, CSQueue>> itr = existingQueues.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, CSQueue> e;
            e = itr.next();
            queueName = e.getKey();
            CSQueue existingQueue = e.getValue();
            if (newQueues.containsKey(queueName) || existingQueue instanceof AutoCreatedLeafQueue && conf.isAutoCreateChildQueueEnabled(existingQueue.getParent().getQueuePath())) continue;
            itr.remove();
        }
    }

    @VisibleForTesting
    public static void setQueueAcls(YarnAuthorizationProvider authorizer, AppPriorityACLsManager appPriorityACLManager, Map<String, CSQueue> queues) throws IOException {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (CSQueue queue : queues.values()) {
            AbstractCSQueue csQueue = (AbstractCSQueue)queue;
            permissions.add(new Permission(csQueue.getPrivilegedEntity(), csQueue.getACLs()));
            if (!(queue instanceof LeafQueue)) continue;
            LeafQueue lQueue = (LeafQueue)queue;
            appPriorityACLManager.clearPriorityACLs(lQueue.getQueueName());
            appPriorityACLManager.addPrioirityACLs(lQueue.getPriorityACLs(), lQueue.getQueueName());
        }
        authorizer.setPermission(permissions, UserGroupInformation.getCurrentUser());
    }

    public LeafQueue getAndCheckLeafQueue(String queue) throws YarnException {
        CSQueue ret = this.getQueue(queue);
        if (ret == null) {
            throw new YarnException("The specified Queue: " + queue + " doesn't exist");
        }
        if (!(ret instanceof LeafQueue)) {
            throw new YarnException("The specified Queue: " + queue + " is not a Leaf Queue.");
        }
        return (LeafQueue)ret;
    }

    public Priority getDefaultPriorityForQueue(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (null == queue || null == queue.getDefaultApplicationPriority()) {
            return Priority.newInstance((int)CapacitySchedulerConfiguration.DEFAULT_CONFIGURATION_APPLICATION_PRIORITY);
        }
        return Priority.newInstance((int)queue.getDefaultApplicationPriority().getPriority());
    }

    private Map<String, Set<String>> getQueueToLabels() {
        HashMap<String, Set<String>> queueToLabels = new HashMap<String, Set<String>>();
        for (CSQueue queue : this.getQueues().values()) {
            queueToLabels.put(queue.getQueueName(), queue.getAccessibleNodeLabels());
        }
        return queueToLabels;
    }

    @InterfaceAudience.Private
    public QueueStateManager<CSQueue, CapacitySchedulerConfiguration> getQueueStateManager() {
        return this.queueStateManager;
    }

    static class QueueHook {
        QueueHook() {
        }

        public CSQueue hook(CSQueue queue) {
            return queue;
        }
    }
}

