/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.PeriodicRLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryPlan
implements Plan {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryPlan.class);
    private static final Resource ZERO_RESOURCE = Resource.newInstance((int)0, (int)0);
    private final RMStateStore rmStateStore;
    private TreeMap<ReservationInterval, Set<InMemoryReservationAllocation>> currentReservations = new TreeMap();
    private RLESparseResourceAllocation rleSparseVector;
    private PeriodicRLESparseResourceAllocation periodicRle;
    private Map<String, RLESparseResourceAllocation> userResourceAlloc = new HashMap<String, RLESparseResourceAllocation>();
    private Map<String, RLESparseResourceAllocation> userPeriodicResourceAlloc = new HashMap<String, RLESparseResourceAllocation>();
    private Map<String, RLESparseResourceAllocation> userActiveReservationCount = new HashMap<String, RLESparseResourceAllocation>();
    private Map<ReservationId, InMemoryReservationAllocation> reservationTable = new HashMap<ReservationId, InMemoryReservationAllocation>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final SharingPolicy policy;
    private final ReservationAgent agent;
    private final long step;
    private final ResourceCalculator resCalc;
    private final Resource minAlloc;
    private final Resource maxAlloc;
    private final String queueName;
    private final QueueMetrics queueMetrics;
    private final Planner replanner;
    private final boolean getMoveOnExpiry;
    private final Clock clock;
    private final long maxPeriodicity;
    private Resource totalCapacity;

    public InMemoryPlan(QueueMetrics queueMetrics, SharingPolicy policy, ReservationAgent agent, Resource totalCapacity, long step, ResourceCalculator resCalc, Resource minAlloc, Resource maxAlloc, String queueName, Planner replanner, boolean getMoveOnExpiry, RMContext rmContext) {
        this(queueMetrics, policy, agent, totalCapacity, step, resCalc, minAlloc, maxAlloc, queueName, replanner, getMoveOnExpiry, 86400000L, rmContext);
    }

    public InMemoryPlan(QueueMetrics queueMetrics, SharingPolicy policy, ReservationAgent agent, Resource totalCapacity, long step, ResourceCalculator resCalc, Resource minAlloc, Resource maxAlloc, String queueName, Planner replanner, boolean getMoveOnExpiry, long maxPeriodicity, RMContext rmContext) {
        this(queueMetrics, policy, agent, totalCapacity, step, resCalc, minAlloc, maxAlloc, queueName, replanner, getMoveOnExpiry, maxPeriodicity, rmContext, (Clock)new UTCClock());
    }

    public InMemoryPlan(QueueMetrics queueMetrics, SharingPolicy policy, ReservationAgent agent, Resource totalCapacity, long step, ResourceCalculator resCalc, Resource minAlloc, Resource maxAlloc, String queueName, Planner replanner, boolean getMoveOnExpiry, long maxPeriodicty, RMContext rmContext, Clock clock) {
        this.queueMetrics = queueMetrics;
        this.policy = policy;
        this.agent = agent;
        this.step = step;
        this.totalCapacity = totalCapacity;
        this.resCalc = resCalc;
        this.minAlloc = minAlloc;
        this.maxAlloc = maxAlloc;
        this.rleSparseVector = new RLESparseResourceAllocation(resCalc);
        this.maxPeriodicity = maxPeriodicty;
        this.periodicRle = new PeriodicRLESparseResourceAllocation(resCalc, (Long)this.maxPeriodicity);
        this.queueName = queueName;
        this.replanner = replanner;
        this.getMoveOnExpiry = getMoveOnExpiry;
        this.clock = clock;
        this.rmStateStore = rmContext.getStateStore();
    }

    @Override
    public QueueMetrics getQueueMetrics() {
        return this.queueMetrics;
    }

    private RLESparseResourceAllocation getUserRLEResourceAllocation(String user, long period) {
        RLESparseResourceAllocation resAlloc = null;
        if (period > 0L) {
            if (this.userPeriodicResourceAlloc.containsKey(user)) {
                resAlloc = this.userPeriodicResourceAlloc.get(user);
            } else {
                resAlloc = new PeriodicRLESparseResourceAllocation(this.resCalc, (Long)this.periodicRle.getTimePeriod());
                this.userPeriodicResourceAlloc.put(user, resAlloc);
            }
        } else if (this.userResourceAlloc.containsKey(user)) {
            resAlloc = this.userResourceAlloc.get(user);
        } else {
            resAlloc = new RLESparseResourceAllocation(this.resCalc);
            this.userResourceAlloc.put(user, resAlloc);
        }
        return resAlloc;
    }

    private void gcUserRLEResourceAllocation(String user, long period) {
        if (period > 0L) {
            if (this.userPeriodicResourceAlloc.get(user).isEmpty()) {
                this.userPeriodicResourceAlloc.remove(user);
            }
        } else if (this.userResourceAlloc.get(user).isEmpty()) {
            this.userResourceAlloc.remove(user);
        }
    }

    private void incrementAllocation(ReservationAllocation reservation) {
        assert (this.readWriteLock.isWriteLockedByCurrentThread());
        Map<ReservationInterval, Resource> allocationRequests = reservation.getAllocationRequests();
        String user = reservation.getUser();
        long period = reservation.getPeriodicity();
        RLESparseResourceAllocation resAlloc = this.getUserRLEResourceAllocation(user, period);
        RLESparseResourceAllocation resCount = this.userActiveReservationCount.get(user);
        if (resCount == null) {
            resCount = new RLESparseResourceAllocation(this.resCalc);
            this.userActiveReservationCount.put(user, resCount);
        }
        long earliestActive = Long.MAX_VALUE;
        long latestActive = Long.MIN_VALUE;
        for (Map.Entry<ReservationInterval, Resource> r : allocationRequests.entrySet()) {
            if (period > 0L) {
                int i = 0;
                while ((long)i < this.periodicRle.getTimePeriod() / period) {
                    long rStart = r.getKey().getStartTime() + (long)i * period;
                    long rEnd = r.getKey().getEndTime() + (long)i * period;
                    if (rEnd > this.periodicRle.getTimePeriod()) {
                        long diff = rEnd - this.periodicRle.getTimePeriod();
                        rEnd = this.periodicRle.getTimePeriod();
                        ReservationInterval newInterval = new ReservationInterval(0L, diff);
                        this.periodicRle.addInterval(newInterval, r.getValue());
                        resAlloc.addInterval(newInterval, r.getValue());
                    }
                    ReservationInterval newInterval = new ReservationInterval(rStart, rEnd);
                    this.periodicRle.addInterval(newInterval, r.getValue());
                    resAlloc.addInterval(newInterval, r.getValue());
                    ++i;
                }
                continue;
            }
            this.rleSparseVector.addInterval(r.getKey(), r.getValue());
            resAlloc.addInterval(r.getKey(), r.getValue());
            if (!Resources.greaterThan((ResourceCalculator)this.resCalc, (Resource)this.totalCapacity, (Resource)r.getValue(), (Resource)ZERO_RESOURCE)) continue;
            earliestActive = Math.min(earliestActive, r.getKey().getStartTime());
            latestActive = Math.max(latestActive, r.getKey().getEndTime());
        }
        if (period > 0L) {
            earliestActive = reservation.getStartTime();
            latestActive = Long.MAX_VALUE;
        }
        resCount.addInterval(new ReservationInterval(earliestActive, latestActive), Resource.newInstance((int)1, (int)1));
    }

    private void decrementAllocation(ReservationAllocation reservation) {
        assert (this.readWriteLock.isWriteLockedByCurrentThread());
        Map<ReservationInterval, Resource> allocationRequests = reservation.getAllocationRequests();
        String user = reservation.getUser();
        long period = reservation.getPeriodicity();
        RLESparseResourceAllocation resAlloc = this.getUserRLEResourceAllocation(user, period);
        long earliestActive = Long.MAX_VALUE;
        long latestActive = Long.MIN_VALUE;
        for (Map.Entry<ReservationInterval, Resource> r : allocationRequests.entrySet()) {
            if (period > 0L) {
                int i = 0;
                while ((long)i < this.periodicRle.getTimePeriod() / period) {
                    long rStart = r.getKey().getStartTime() + (long)i * period;
                    long rEnd = r.getKey().getEndTime() + (long)i * period;
                    if (rEnd > this.periodicRle.getTimePeriod()) {
                        long diff = rEnd - this.periodicRle.getTimePeriod();
                        rEnd = this.periodicRle.getTimePeriod();
                        ReservationInterval newInterval = new ReservationInterval(0L, diff);
                        this.periodicRle.removeInterval(newInterval, r.getValue());
                        resAlloc.removeInterval(newInterval, r.getValue());
                    }
                    ReservationInterval newInterval = new ReservationInterval(rStart, rEnd);
                    this.periodicRle.removeInterval(newInterval, r.getValue());
                    resAlloc.removeInterval(newInterval, r.getValue());
                    ++i;
                }
                continue;
            }
            this.rleSparseVector.removeInterval(r.getKey(), r.getValue());
            resAlloc.removeInterval(r.getKey(), r.getValue());
            if (!Resources.greaterThan((ResourceCalculator)this.resCalc, (Resource)this.totalCapacity, (Resource)r.getValue(), (Resource)ZERO_RESOURCE)) continue;
            earliestActive = Math.min(earliestActive, r.getKey().getStartTime());
            latestActive = Math.max(latestActive, r.getKey().getEndTime());
        }
        this.gcUserRLEResourceAllocation(user, period);
        RLESparseResourceAllocation resCount = this.userActiveReservationCount.get(user);
        if (period > 0L) {
            earliestActive = reservation.getStartTime();
            latestActive = Long.MAX_VALUE;
        }
        resCount.removeInterval(new ReservationInterval(earliestActive, latestActive), Resource.newInstance((int)1, (int)1));
        if (resCount.isEmpty()) {
            this.userActiveReservationCount.remove(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ReservationAllocation> getAllReservations() {
        this.readLock.lock();
        try {
            if (this.currentReservations != null) {
                TreeSet<InMemoryReservationAllocation> flattenedReservations = new TreeSet<InMemoryReservationAllocation>();
                for (Set<InMemoryReservationAllocation> res : this.currentReservations.values()) {
                    flattenedReservations.addAll(res);
                }
                TreeSet<InMemoryReservationAllocation> treeSet = flattenedReservations;
                return treeSet;
            }
            Set<ReservationAllocation> set = null;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addReservation(ReservationAllocation reservation, boolean isRecovering) throws PlanningException {
        InMemoryReservationAllocation inMemReservation = (InMemoryReservationAllocation)reservation;
        if (inMemReservation.getUser() == null) {
            String errMsg = "The specified Reservation with ID " + inMemReservation.getReservationId() + " is not mapped to any user";
            LOG.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        this.writeLock.lock();
        try {
            ReservationInterval searchInterval;
            Set<InMemoryReservationAllocation> reservations;
            if (this.reservationTable.containsKey(inMemReservation.getReservationId())) {
                String errMsg = "The specified Reservation with ID " + inMemReservation.getReservationId() + " already exists";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            if (!isRecovering) {
                this.policy.validate(this, inMemReservation);
                reservation.setAcceptanceTimestamp(this.clock.getTime());
                if (this.rmStateStore != null) {
                    this.rmStateStore.storeNewReservation(ReservationSystemUtil.buildStateProto(inMemReservation), this.getQueueName(), inMemReservation.getReservationId().toString());
                }
            }
            if ((reservations = this.currentReservations.get(searchInterval = new ReservationInterval(inMemReservation.getStartTime(), inMemReservation.getEndTime()))) == null) {
                reservations = new HashSet<InMemoryReservationAllocation>();
            }
            if (!reservations.add(inMemReservation)) {
                LOG.error("Unable to add reservation: {} to plan.", (Object)inMemReservation.getReservationId());
                boolean bl = false;
                return bl;
            }
            this.currentReservations.put(searchInterval, reservations);
            this.reservationTable.put(inMemReservation.getReservationId(), inMemReservation);
            this.incrementAllocation(inMemReservation);
            LOG.info("Successfully added reservation: {} to plan.", (Object)inMemReservation.getReservationId());
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateReservation(ReservationAllocation reservation) throws PlanningException {
        this.writeLock.lock();
        boolean result = false;
        try {
            ReservationId resId = reservation.getReservationId();
            ReservationAllocation currReservation = this.getReservationById(resId);
            if (currReservation == null) {
                String errMsg = "The specified Reservation with ID " + resId + " does not exist in the plan";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            this.policy.validate(this, reservation);
            if (!this.removeReservation(currReservation)) {
                LOG.error("Unable to replace reservation: {} from plan.", (Object)reservation.getReservationId());
                boolean errMsg = result;
                return errMsg;
            }
            try {
                result = this.addReservation(reservation, false);
            }
            catch (PlanningException e) {
                LOG.error("Unable to update reservation: {} from plan due to {}.", (Object)reservation.getReservationId(), (Object)e.getMessage());
            }
            if (result) {
                LOG.info("Successfully updated reservation: {} in plan.", (Object)reservation.getReservationId());
                boolean bl = result;
                return bl;
            }
            this.addReservation(currReservation, false);
            LOG.info("Rollbacked update reservation: {} from plan.", (Object)reservation.getReservationId());
            boolean bl = result;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean removeReservation(ReservationAllocation reservation) {
        assert (this.readWriteLock.isWriteLockedByCurrentThread());
        ReservationInterval searchInterval = new ReservationInterval(reservation.getStartTime(), reservation.getEndTime());
        Set<InMemoryReservationAllocation> reservations = this.currentReservations.get(searchInterval);
        if (reservations != null) {
            if (this.rmStateStore != null) {
                this.rmStateStore.removeReservation(this.getQueueName(), reservation.getReservationId().toString());
            }
            if (!reservations.remove(reservation)) {
                LOG.error("Unable to remove reservation: {} from plan.", (Object)reservation.getReservationId());
                return false;
            }
            if (reservations.isEmpty()) {
                this.currentReservations.remove(searchInterval);
            }
        } else {
            String errMsg = "The specified Reservation with ID " + reservation.getReservationId() + " does not exist in the plan";
            LOG.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        this.reservationTable.remove(reservation.getReservationId());
        this.decrementAllocation(reservation);
        LOG.info("Sucessfully deleted reservation: {} in plan.", (Object)reservation.getReservationId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteReservation(ReservationId reservationID) {
        this.writeLock.lock();
        try {
            ReservationAllocation reservation = this.getReservationById(reservationID);
            if (reservation == null) {
                String errMsg = "The specified Reservation with ID " + reservationID + " does not exist in the plan";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            boolean bl = this.removeReservation(reservation);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveCompletedReservations(long tick) {
        LOG.debug("Running archival at time: {}", (Object)tick);
        ArrayList<InMemoryReservationAllocation> expiredReservations = new ArrayList<InMemoryReservationAllocation>();
        this.readLock.lock();
        try {
            long archivalTime = tick - this.policy.getValidWindow();
            ReservationInterval searchInterval = new ReservationInterval(archivalTime, archivalTime);
            NavigableMap<ReservationInterval, Set<InMemoryReservationAllocation>> reservations = this.currentReservations.headMap(searchInterval, true);
            if (!reservations.isEmpty()) {
                for (Set reservationEntries : reservations.values()) {
                    for (InMemoryReservationAllocation reservation : reservationEntries) {
                        if (reservation.getEndTime() > archivalTime) continue;
                        expiredReservations.add(reservation);
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (expiredReservations.isEmpty()) {
            return;
        }
        this.writeLock.lock();
        try {
            for (InMemoryReservationAllocation expiredReservation : expiredReservations) {
                this.removeReservation(expiredReservation);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<ReservationAllocation> getReservationsAtTime(long tick) {
        return this.getReservations(null, new ReservationInterval(tick, tick), "");
    }

    @Override
    public long getStep() {
        return this.step;
    }

    @Override
    public SharingPolicy getSharingPolicy() {
        return this.policy;
    }

    @Override
    public ReservationAgent getReservationAgent() {
        return this.agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RLESparseResourceAllocation getReservationCountForUserOverTime(String user, long start, long end) {
        this.readLock.lock();
        try {
            RLESparseResourceAllocation userResAlloc = this.userActiveReservationCount.get(user);
            if (userResAlloc != null) {
                RLESparseResourceAllocation rLESparseResourceAllocation = userResAlloc.getRangeOverlapping(start, end);
                return rLESparseResourceAllocation;
            }
            RLESparseResourceAllocation rLESparseResourceAllocation = new RLESparseResourceAllocation(this.resCalc);
            return rLESparseResourceAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RLESparseResourceAllocation getConsumptionForUserOverTime(String user, long start, long end) {
        this.readLock.lock();
        try {
            RLESparseResourceAllocation userResAlloc = this.userResourceAlloc.get(user);
            RLESparseResourceAllocation userPeriodicResAlloc = this.userPeriodicResourceAlloc.get(user);
            if (userResAlloc != null && userPeriodicResAlloc != null) {
                RLESparseResourceAllocation rLESparseResourceAllocation = RLESparseResourceAllocation.merge(this.resCalc, this.totalCapacity, userResAlloc, userPeriodicResAlloc, RLESparseResourceAllocation.RLEOperator.add, start, end);
                return rLESparseResourceAllocation;
            }
            if (userResAlloc != null) {
                RLESparseResourceAllocation rLESparseResourceAllocation = userResAlloc.getRangeOverlapping(start, end);
                return rLESparseResourceAllocation;
            }
            if (userPeriodicResAlloc != null) {
                RLESparseResourceAllocation rLESparseResourceAllocation = userPeriodicResAlloc.getRangeOverlapping(start, end);
                return rLESparseResourceAllocation;
            }
        }
        catch (PlanningException e) {
            LOG.warn("Exception while trying to merge periodic and non-periodic user allocations: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.readLock.unlock();
        }
        return new RLESparseResourceAllocation(this.resCalc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getTotalCommittedResources(long t) {
        this.readLock.lock();
        try {
            Resource resource = Resources.add((Resource)this.rleSparseVector.getCapacityAtTime(t), (Resource)this.periodicRle.getCapacityAtTime(t));
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<ReservationAllocation> getReservations(ReservationId reservationID, ReservationInterval interval) {
        return this.getReservations(reservationID, interval, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ReservationAllocation> getReservations(ReservationId reservationID, ReservationInterval interval, String user) {
        if (reservationID != null) {
            ReservationAllocation allocation = this.getReservationById(reservationID);
            if (allocation == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(allocation);
        }
        long startTime = interval == null ? 0L : interval.getStartTime();
        long endTime = interval == null ? Long.MAX_VALUE : interval.getEndTime();
        ReservationInterval searchInterval = new ReservationInterval(endTime, Long.MAX_VALUE);
        this.readLock.lock();
        try {
            NavigableMap<ReservationInterval, Set<InMemoryReservationAllocation>> res = this.currentReservations.headMap(searchInterval, true);
            if (!res.isEmpty()) {
                HashSet<InMemoryReservationAllocation> flattenedReservations = new HashSet<InMemoryReservationAllocation>();
                for (Set resEntries : res.values()) {
                    for (InMemoryReservationAllocation reservation : resEntries) {
                        if (user != null && !user.isEmpty() && !reservation.getUser().equals(user)) continue;
                        long period = reservation.getPeriodicity();
                        if (period > 0L) {
                            long shift = reservation.getStartTime() % period;
                            long periodicReservationEnd = (reservation.getEndTime() - shift) % period;
                            long periodicSearchStart = (startTime - shift) % period;
                            long periodicSearchEnd = (endTime - shift) % period;
                            long searchDuration = endTime - startTime;
                            if (searchDuration <= period && periodicSearchEnd >= periodicReservationEnd && periodicSearchStart >= periodicReservationEnd && periodicSearchStart <= periodicSearchEnd) continue;
                            flattenedReservations.add(reservation);
                            continue;
                        }
                        if (reservation.getEndTime() <= startTime) continue;
                        flattenedReservations.add(reservation);
                    }
                }
                Set set = Collections.unmodifiableSet(flattenedReservations);
                return set;
            }
            Set<ReservationAllocation> set = Collections.emptySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ReservationAllocation getReservationById(ReservationId reservationID) {
        if (reservationID == null) {
            return null;
        }
        this.readLock.lock();
        try {
            ReservationAllocation reservationAllocation = this.reservationTable.get(reservationID);
            return reservationAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getTotalCapacity() {
        this.readLock.lock();
        try {
            Resource resource = Resources.clone((Resource)this.totalCapacity);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RLESparseResourceAllocation getAvailableResourceOverTime(String user, ReservationId oldId, long start, long end, long period) throws PlanningException {
        this.readLock.lock();
        try {
            if (period == 0L) {
                TreeMap<Long, Resource> totAvailable = new TreeMap<Long, Resource>();
                totAvailable.put(start, Resources.clone((Resource)this.totalCapacity));
                RLESparseResourceAllocation totRLEAvail = new RLESparseResourceAllocation(totAvailable, this.resCalc);
                RLESparseResourceAllocation netAvailable = RLESparseResourceAllocation.merge(this.resCalc, Resources.clone((Resource)this.totalCapacity), totRLEAvail, this.rleSparseVector, RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, start, end);
                netAvailable = RLESparseResourceAllocation.merge(this.resCalc, Resources.clone((Resource)this.totalCapacity), netAvailable, this.periodicRle, RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, start, end);
                ReservationAllocation old = this.reservationTable.get(oldId);
                if (old != null) {
                    RLESparseResourceAllocation addBackPrevious = old.getResourcesOverTime(start, end);
                    netAvailable = RLESparseResourceAllocation.merge(this.resCalc, Resources.clone((Resource)this.totalCapacity), netAvailable, addBackPrevious, RLESparseResourceAllocation.RLEOperator.add, start, end);
                }
                RLESparseResourceAllocation rLESparseResourceAllocation = netAvailable = this.getSharingPolicy().availableResources(netAvailable, this, user, oldId, start, end);
                return rLESparseResourceAllocation;
            }
            if (this.periodicRle.getTimePeriod() % period != 0L) {
                throw new PlanningException("The reservation periodicity (" + period + ") must be" + " an exact divider of the system maxPeriod (" + this.periodicRle.getTimePeriod() + ")");
            }
            if (period < end - start) {
                throw new PlanningException("Invalid input: (end - start) = (" + end + " - " + start + ") = " + (end - start) + " > period = " + period);
            }
            long numInstInLCM = this.periodicRle.getTimePeriod() / period;
            RLESparseResourceAllocation minOverLCM = this.getAvailableResourceOverTime(user, oldId, start, end, 0L);
            int i = 1;
            while ((long)i < numInstInLCM) {
                long rStart = start + (long)i * period;
                long rEnd = end + (long)i * period;
                RLESparseResourceAllocation snapShot = this.getAvailableResourceOverTime(user, oldId, rStart, rEnd, 0L);
                snapShot.shift(-((long)i * period));
                minOverLCM = RLESparseResourceAllocation.merge(this.resCalc, this.getTotalCapacity(), minOverLCM, snapShot, RLESparseResourceAllocation.RLEOperator.min, start, end);
                ++i;
            }
            RLESparseResourceAllocation rLESparseResourceAllocation = minOverLCM;
            return rLESparseResourceAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getMinimumAllocation() {
        return Resources.clone((Resource)this.minAlloc);
    }

    @Override
    public void setTotalCapacity(Resource cap) {
        this.writeLock.lock();
        try {
            this.totalCapacity = Resources.clone((Resource)cap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getEarliestStartTime() {
        this.readLock.lock();
        try {
            long l = this.rleSparseVector.getEarliestStartTime();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getLastEndTime() {
        this.readLock.lock();
        try {
            long l = this.rleSparseVector.getLatestNonNullTime();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.resCalc;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public Resource getMaximumAllocation() {
        return Resources.clone((Resource)this.maxAlloc);
    }

    @Override
    public long getMaximumPeriodicity() {
        return this.maxPeriodicity;
    }

    public String toCumulativeString() {
        this.readLock.lock();
        try {
            String string = this.rleSparseVector.toString() + "\n" + this.periodicRle.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Planner getReplanner() {
        return this.replanner;
    }

    @Override
    public boolean getMoveOnExpiry() {
        return this.getMoveOnExpiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            StringBuffer planStr = new StringBuffer("In-memory Plan: ");
            planStr.append("Parent Queue: ").append(this.queueName).append("Total Capacity: ").append(this.totalCapacity).append("Step: ").append(this.step);
            for (ReservationAllocation reservation : this.getAllReservations()) {
                planStr.append(reservation);
            }
            String string = planStr.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ReservationAllocation> getReservationByUserAtTime(String user, long t) {
        this.readLock.lock();
        try {
            HashSet<ReservationAllocation> resSet = new HashSet<ReservationAllocation>();
            for (ReservationAllocation ra : this.getReservationsAtTime(t)) {
                String resUser = ra.getUser();
                if (resUser == null || !resUser.equals(user)) continue;
                resSet.add(ra);
            }
            HashSet<ReservationAllocation> hashSet = resSet;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RLESparseResourceAllocation getCumulativeLoadOverTime(long start, long end) throws PlanningException {
        this.readLock.lock();
        try {
            RLESparseResourceAllocation ret = this.rleSparseVector.getRangeOverlapping(start, end);
            RLESparseResourceAllocation rLESparseResourceAllocation = ret = RLESparseResourceAllocation.merge(this.resCalc, this.totalCapacity, ret, this.periodicRle.getRangeOverlapping(start, end), RLESparseResourceAllocation.RLEOperator.add, start, end);
            return rLESparseResourceAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

