/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMActiveServiceContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServiceContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMDelegatedNodeLabelsUpdater;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceProfilesManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.monitor.RMAppLifetimeMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class RMContextImpl
implements RMContext {
    private static final Log LOG = LogFactory.getLog(RMContextImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private RMServiceContext serviceContext = new RMServiceContext();
    private RMActiveServiceContext activeServiceContext = new RMActiveServiceContext();
    private String proxyHostAndPort = null;

    public RMContextImpl() {
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager, ResourceScheduler scheduler) {
        this();
        this.setDispatcher(rmDispatcher);
        this.setActiveServiceContext(new RMActiveServiceContext(rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, delegationTokenRenewer, appTokenSecretManager, containerTokenSecretManager, nmTokenSecretManager, clientToAMTokenSecretManager, scheduler));
        LocalConfigurationProvider provider = new LocalConfigurationProvider();
        this.setConfigurationProvider((ConfigurationProvider)provider);
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this(rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, delegationTokenRenewer, appTokenSecretManager, containerTokenSecretManager, nmTokenSecretManager, clientToAMTokenSecretManager, null);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMServiceContext getServiceContext() {
        return this.serviceContext;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setServiceContext(RMServiceContext context) {
        this.serviceContext = context;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.serviceContext.getResourceManager();
    }

    public void setResourceManager(ResourceManager rm) {
        this.serviceContext.setResourceManager(rm);
    }

    @Override
    public EmbeddedElector getLeaderElectorService() {
        return this.serviceContext.getLeaderElectorService();
    }

    @Override
    public void setLeaderElectorService(EmbeddedElector elector) {
        this.serviceContext.setLeaderElectorService(elector);
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.serviceContext.getDispatcher();
    }

    void setDispatcher(Dispatcher dispatcher) {
        this.serviceContext.setDispatcher(dispatcher);
    }

    @Override
    public AdminService getRMAdminService() {
        return this.serviceContext.getRMAdminService();
    }

    void setRMAdminService(AdminService adminService) {
        this.serviceContext.setRMAdminService(adminService);
    }

    @Override
    public boolean isHAEnabled() {
        return this.serviceContext.isHAEnabled();
    }

    void setHAEnabled(boolean isHAEnabled) {
        this.serviceContext.setHAEnabled(isHAEnabled);
    }

    @Override
    public HAServiceProtocol.HAServiceState getHAServiceState() {
        return this.serviceContext.getHAServiceState();
    }

    void setHAServiceState(HAServiceProtocol.HAServiceState serviceState) {
        this.serviceContext.setHAServiceState(serviceState);
    }

    @Override
    public RMApplicationHistoryWriter getRMApplicationHistoryWriter() {
        return this.serviceContext.getRMApplicationHistoryWriter();
    }

    @Override
    public void setRMApplicationHistoryWriter(RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        this.serviceContext.setRMApplicationHistoryWriter(rmApplicationHistoryWriter);
    }

    @Override
    public SystemMetricsPublisher getSystemMetricsPublisher() {
        return this.serviceContext.getSystemMetricsPublisher();
    }

    @Override
    public void setSystemMetricsPublisher(SystemMetricsPublisher metricsPublisher) {
        this.serviceContext.setSystemMetricsPublisher(metricsPublisher);
    }

    @Override
    public RMTimelineCollectorManager getRMTimelineCollectorManager() {
        return this.serviceContext.getRMTimelineCollectorManager();
    }

    @Override
    public void setRMTimelineCollectorManager(RMTimelineCollectorManager timelineCollectorManager) {
        this.serviceContext.setRMTimelineCollectorManager(timelineCollectorManager);
    }

    @Override
    public ConfigurationProvider getConfigurationProvider() {
        return this.serviceContext.getConfigurationProvider();
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.serviceContext.setConfigurationProvider(configurationProvider);
    }

    @Override
    public Configuration getYarnConfiguration() {
        return this.serviceContext.getYarnConfiguration();
    }

    public void setYarnConfiguration(Configuration yarnConfiguration) {
        this.serviceContext.setYarnConfiguration(yarnConfiguration);
    }

    @Override
    public String getHAZookeeperConnectionState() {
        return this.serviceContext.getHAZookeeperConnectionState();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMActiveServiceContext getActiveServiceContext() {
        return this.activeServiceContext;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setActiveServiceContext(RMActiveServiceContext activeServiceContext) {
        this.activeServiceContext = activeServiceContext;
    }

    @Override
    public RMStateStore getStateStore() {
        return this.activeServiceContext.getStateStore();
    }

    @Override
    public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
        return this.activeServiceContext.getRMApps();
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getRMNodes() {
        return this.activeServiceContext.getRMNodes();
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getInactiveRMNodes() {
        return this.activeServiceContext.getInactiveRMNodes();
    }

    @Override
    public ContainerAllocationExpirer getContainerAllocationExpirer() {
        return this.activeServiceContext.getContainerAllocationExpirer();
    }

    @Override
    public AMLivelinessMonitor getAMLivelinessMonitor() {
        return this.activeServiceContext.getAMLivelinessMonitor();
    }

    @Override
    public AMLivelinessMonitor getAMFinishingMonitor() {
        return this.activeServiceContext.getAMFinishingMonitor();
    }

    @Override
    public DelegationTokenRenewer getDelegationTokenRenewer() {
        return this.activeServiceContext.getDelegationTokenRenewer();
    }

    @Override
    public AMRMTokenSecretManager getAMRMTokenSecretManager() {
        return this.activeServiceContext.getAMRMTokenSecretManager();
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.activeServiceContext.getContainerTokenSecretManager();
    }

    @Override
    public NMTokenSecretManagerInRM getNMTokenSecretManager() {
        return this.activeServiceContext.getNMTokenSecretManager();
    }

    @Override
    public ResourceScheduler getScheduler() {
        return this.activeServiceContext.getScheduler();
    }

    @Override
    public ReservationSystem getReservationSystem() {
        return this.activeServiceContext.getReservationSystem();
    }

    @Override
    public NodesListManager getNodesListManager() {
        return this.activeServiceContext.getNodesListManager();
    }

    @Override
    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.activeServiceContext.getClientToAMTokenSecretManager();
    }

    @VisibleForTesting
    public void setStateStore(RMStateStore store) {
        this.activeServiceContext.setStateStore(store);
    }

    @Override
    public ClientRMService getClientRMService() {
        return this.activeServiceContext.getClientRMService();
    }

    @Override
    public ApplicationMasterService getApplicationMasterService() {
        return this.activeServiceContext.getApplicationMasterService();
    }

    @Override
    public ResourceTrackerService getResourceTrackerService() {
        return this.activeServiceContext.getResourceTrackerService();
    }

    @Override
    public void setClientRMService(ClientRMService clientRMService) {
        this.activeServiceContext.setClientRMService(clientRMService);
    }

    @Override
    public RMDelegationTokenSecretManager getRMDelegationTokenSecretManager() {
        return this.activeServiceContext.getRMDelegationTokenSecretManager();
    }

    @Override
    public void setRMDelegationTokenSecretManager(RMDelegationTokenSecretManager delegationTokenSecretManager) {
        this.activeServiceContext.setRMDelegationTokenSecretManager(delegationTokenSecretManager);
    }

    void setContainerAllocationExpirer(ContainerAllocationExpirer containerAllocationExpirer) {
        this.activeServiceContext.setContainerAllocationExpirer(containerAllocationExpirer);
    }

    void setAMLivelinessMonitor(AMLivelinessMonitor amLivelinessMonitor) {
        this.activeServiceContext.setAMLivelinessMonitor(amLivelinessMonitor);
    }

    void setAMFinishingMonitor(AMLivelinessMonitor amFinishingMonitor) {
        this.activeServiceContext.setAMFinishingMonitor(amFinishingMonitor);
    }

    void setContainerTokenSecretManager(RMContainerTokenSecretManager containerTokenSecretManager) {
        this.activeServiceContext.setContainerTokenSecretManager(containerTokenSecretManager);
    }

    void setNMTokenSecretManager(NMTokenSecretManagerInRM nmTokenSecretManager) {
        this.activeServiceContext.setNMTokenSecretManager(nmTokenSecretManager);
    }

    @VisibleForTesting
    public void setScheduler(ResourceScheduler scheduler) {
        this.activeServiceContext.setScheduler(scheduler);
    }

    void setReservationSystem(ReservationSystem reservationSystem) {
        this.activeServiceContext.setReservationSystem(reservationSystem);
    }

    void setDelegationTokenRenewer(DelegationTokenRenewer delegationTokenRenewer) {
        this.activeServiceContext.setDelegationTokenRenewer(delegationTokenRenewer);
    }

    void setClientToAMTokenSecretManager(ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this.activeServiceContext.setClientToAMTokenSecretManager(clientToAMTokenSecretManager);
    }

    void setAMRMTokenSecretManager(AMRMTokenSecretManager amRMTokenSecretManager) {
        this.activeServiceContext.setAMRMTokenSecretManager(amRMTokenSecretManager);
    }

    void setNodesListManager(NodesListManager nodesListManager) {
        this.activeServiceContext.setNodesListManager(nodesListManager);
    }

    void setApplicationMasterService(ApplicationMasterService applicationMasterService) {
        this.activeServiceContext.setApplicationMasterService(applicationMasterService);
    }

    void setResourceTrackerService(ResourceTrackerService resourceTrackerService) {
        this.activeServiceContext.setResourceTrackerService(resourceTrackerService);
    }

    public void setWorkPreservingRecoveryEnabled(boolean enabled) {
        this.activeServiceContext.setWorkPreservingRecoveryEnabled(enabled);
    }

    @Override
    public boolean isWorkPreservingRecoveryEnabled() {
        return this.activeServiceContext.isWorkPreservingRecoveryEnabled();
    }

    @Override
    public long getEpoch() {
        return this.activeServiceContext.getEpoch();
    }

    void setEpoch(long epoch) {
        this.activeServiceContext.setEpoch(epoch);
    }

    @Override
    public RMNodeLabelsManager getNodeLabelManager() {
        return this.activeServiceContext.getNodeLabelManager();
    }

    @Override
    public void setNodeLabelManager(RMNodeLabelsManager mgr) {
        this.activeServiceContext.setNodeLabelManager(mgr);
    }

    @Override
    public AllocationTagsManager getAllocationTagsManager() {
        return this.activeServiceContext.getAllocationTagsManager();
    }

    @Override
    public void setAllocationTagsManager(AllocationTagsManager allocationTagsManager) {
        this.activeServiceContext.setAllocationTagsManager(allocationTagsManager);
    }

    @Override
    public PlacementConstraintManager getPlacementConstraintManager() {
        return this.activeServiceContext.getPlacementConstraintManager();
    }

    @Override
    public void setPlacementConstraintManager(PlacementConstraintManager placementConstraintManager) {
        this.activeServiceContext.setPlacementConstraintManager(placementConstraintManager);
    }

    @Override
    public RMDelegatedNodeLabelsUpdater getRMDelegatedNodeLabelsUpdater() {
        return this.activeServiceContext.getRMDelegatedNodeLabelsUpdater();
    }

    @Override
    public void setRMDelegatedNodeLabelsUpdater(RMDelegatedNodeLabelsUpdater delegatedNodeLabelsUpdater) {
        this.activeServiceContext.setRMDelegatedNodeLabelsUpdater(delegatedNodeLabelsUpdater);
    }

    public void setSchedulerRecoveryStartAndWaitTime(long waitTime) {
        this.activeServiceContext.setSchedulerRecoveryStartAndWaitTime(waitTime);
    }

    @Override
    public boolean isSchedulerReadyForAllocatingContainers() {
        return this.activeServiceContext.isSchedulerReadyForAllocatingContainers();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setSystemClock(Clock clock) {
        this.activeServiceContext.setSystemClock(clock);
    }

    @Override
    public ConcurrentMap<ApplicationId, ByteBuffer> getSystemCredentialsForApps() {
        return this.activeServiceContext.getSystemCredentialsForApps();
    }

    @Override
    public PlacementManager getQueuePlacementManager() {
        return this.activeServiceContext.getQueuePlacementManager();
    }

    @Override
    public void setQueuePlacementManager(PlacementManager placementMgr) {
        this.activeServiceContext.setQueuePlacementManager(placementMgr);
    }

    @Override
    public QueueLimitCalculator getNodeManagerQueueLimitCalculator() {
        return this.activeServiceContext.getNodeManagerQueueLimitCalculator();
    }

    public void setContainerQueueLimitCalculator(QueueLimitCalculator limitCalculator) {
        this.activeServiceContext.setContainerQueueLimitCalculator(limitCalculator);
    }

    @Override
    public void setRMAppLifetimeMonitor(RMAppLifetimeMonitor rmAppLifetimeMonitor) {
        this.activeServiceContext.setRMAppLifetimeMonitor(rmAppLifetimeMonitor);
    }

    @Override
    public RMAppLifetimeMonitor getRMAppLifetimeMonitor() {
        return this.activeServiceContext.getRMAppLifetimeMonitor();
    }

    @Override
    public ResourceProfilesManager getResourceProfilesManager() {
        return this.activeServiceContext.getResourceProfilesManager();
    }

    String getProxyHostAndPort(Configuration conf) {
        if (this.proxyHostAndPort == null) {
            this.proxyHostAndPort = WebAppUtils.getProxyHostAndPort((Configuration)conf);
        }
        return this.proxyHostAndPort;
    }

    @Override
    public String getAppProxyUrl(Configuration conf, ApplicationId applicationId) {
        try {
            String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl(scheme, this.getProxyHostAndPort(conf));
            URI result = ProxyUriUtils.getProxyUri(null, proxyUri, applicationId);
            return result.toASCIIString();
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not generate default proxy tracking URL for " + applicationId));
            return UNAVAILABLE;
        }
    }

    @Override
    public void setResourceProfilesManager(ResourceProfilesManager mgr) {
        this.activeServiceContext.setResourceProfilesManager(mgr);
    }
}

