/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerLogsUtils;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLogsPage
extends NMView {
    public static final Logger LOG = LoggerFactory.getLogger(ContainerLogsPage.class);
    public static final String REDIRECT_URL = "redirect.url";
    public static final String LOG_AGGREGATION_TYPE = "log.aggregation.type";
    public static final String LOG_AGGREGATION_REMOTE_TYPE = "remote";
    public static final String LOG_AGGREGATION_LOCAL_TYPE = "local";

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        String redirectUrl = this.$(REDIRECT_URL);
        if (redirectUrl == null || redirectUrl.isEmpty()) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Logs for ", this.$("container.id")}));
        } else if (redirectUrl.equals("false")) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Failed redirect for ", this.$("container.id")}));
        }
        this.set("ui.accordion.id", "nav");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return ContainersLogsBlock.class;
    }

    public static class ContainersLogsBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;
        private final LogAggregationFileControllerFactory factory;

        @Inject
        public ContainersLogsBlock(Context context) {
            this.nmContext = context;
            this.factory = new LogAggregationFileControllerFactory(context.getConf());
        }

        protected void render(HtmlBlock.Block html) {
            block16: {
                ApplicationId appId;
                ContainerId containerId;
                String redirectUrl = this.$(ContainerLogsPage.REDIRECT_URL);
                if (redirectUrl != null && redirectUrl.equals("false")) {
                    html.h1("Failed while trying to construct the redirect url to the log server. Log Server url may not be configured");
                }
                try {
                    containerId = ContainerId.fromString((String)this.$("container.id"));
                    appId = containerId.getApplicationAttemptId().getApplicationId();
                }
                catch (IllegalArgumentException ex) {
                    html.h1("Invalid container ID: " + this.$("container.id"));
                    return;
                }
                LogAggregationFileController fileController = null;
                boolean foundAggregatedLogs = false;
                try {
                    fileController = this.factory.getFileControllerForRead(appId, this.$("app.owner"));
                    foundAggregatedLogs = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.$("log.type").isEmpty()) {
                        html.h2("Local Logs:");
                        List<File> logFiles = ContainerLogsUtils.getContainerLogDirs(containerId, this.request().getRemoteUser(), this.nmContext);
                        this.printLocalLogFileDirectory(html, logFiles);
                        if (!foundAggregatedLogs) break block16;
                        try {
                            ContainerLogsRequest logRequest = new ContainerLogsRequest();
                            logRequest.setAppId(appId);
                            logRequest.setAppOwner(this.$("app.owner"));
                            logRequest.setContainerId(this.$("container.id"));
                            logRequest.setNodeId(this.nmContext.getNodeId().toString());
                            List containersLogMeta = fileController.readAggregatedLogsMeta(logRequest);
                            if (containersLogMeta != null && !containersLogMeta.isEmpty()) {
                                html.h2("Aggregated Logs:");
                                this.printAggregatedLogFileDirectory(html, containersLogMeta);
                            }
                            break block16;
                        }
                        catch (Exception ex) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(ex.getMessage());
                            }
                            break block16;
                        }
                    }
                    String aggregationType = this.$(ContainerLogsPage.LOG_AGGREGATION_TYPE);
                    if (aggregationType == null || aggregationType.isEmpty() || aggregationType.trim().toLowerCase().equals(ContainerLogsPage.LOG_AGGREGATION_LOCAL_TYPE)) {
                        File logFile = ContainerLogsUtils.getContainerLogFile(containerId, this.$("log.type"), this.request().getRemoteUser(), this.nmContext);
                        this.printLocalLogFile(html, logFile);
                    } else if (!ContainerLogsPage.LOG_AGGREGATION_LOCAL_TYPE.trim().toLowerCase().equals(aggregationType) && !ContainerLogsPage.LOG_AGGREGATION_REMOTE_TYPE.trim().toLowerCase().equals(aggregationType)) {
                        html.h1("Invalid value for query parameter: log.aggregation.type. The valid value could be either local or remote.");
                    }
                }
                catch (YarnException ex) {
                    html.h1(ex.getMessage());
                }
                catch (NotFoundException ex) {
                    html.h1(ex.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printLocalLogFile(HtmlBlock.Block html, File logFile) {
            long start = this.$("start").isEmpty() ? -4096L : Long.parseLong(this.$("start"));
            start = start < 0L ? logFile.length() + start : start;
            start = start < 0L ? 0L : start;
            long end = this.$("end").isEmpty() ? logFile.length() : Long.parseLong(this.$("end"));
            end = end < 0L ? logFile.length() + end : end;
            long l = end = end < 0L ? logFile.length() : end;
            if (start > end) {
                html.h1("Invalid start and end values. Start: [" + start + "]" + ", end[" + end + "]");
                return;
            }
            FileInputStream logByteStream = null;
            try {
                logByteStream = ContainerLogsUtils.openLogFileForRead(this.$("container.id"), logFile, this.nmContext);
            }
            catch (IOException ex) {
                html.h1(ex.getMessage());
                return;
            }
            try {
                long toRead = end - start;
                if (toRead < logFile.length()) {
                    html.p().__(new Object[]{"Showing " + toRead + " bytes. Click "}).a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), logFile.getName(), "?start=0"}), "here").__(new Object[]{" for full log"}).__();
                }
                IOUtils.skipFully((InputStream)logByteStream, (long)start);
                InputStreamReader reader = new InputStreamReader((InputStream)logByteStream, Charset.forName("UTF-8"));
                int bufferSize = 65536;
                char[] cbuf = new char[bufferSize];
                int len = 0;
                int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
                Hamlet.PRE pre = html.pre();
                while ((len = reader.read(cbuf, 0, currentToRead)) > 0 && toRead > 0L) {
                    pre.__(new Object[]{new String(cbuf, 0, len)});
                    currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
                }
                pre.__();
                reader.close();
            }
            catch (IOException e) {
                LOG.error("Exception reading log file " + logFile.getAbsolutePath(), (Throwable)e);
                html.h1("Exception reading log file. It might be because log file was aggregated : " + logFile.getName());
            }
            finally {
                if (logByteStream != null) {
                    try {
                        logByteStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private void printLocalLogFileDirectory(HtmlBlock.Block html, List<File> containerLogsDirs) {
            Collections.sort(containerLogsDirs);
            boolean foundLogFile = false;
            for (File containerLogsDir : containerLogsDirs) {
                Object[] logFiles = containerLogsDir.listFiles();
                if (logFiles == null) continue;
                Arrays.sort(logFiles);
                for (Object logFile : logFiles) {
                    foundLogFile = true;
                    html.p().a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), ((File)logFile).getName(), "?start=-4096"}), ((File)logFile).getName() + " : Total file length is " + ((File)logFile).length() + " bytes.").__();
                }
            }
            if (!foundLogFile) {
                html.h1("No logs available for container " + this.$("container.id"));
                return;
            }
        }

        private void printAggregatedLogFileDirectory(HtmlBlock.Block html, List<ContainerLogMeta> containersLogMeta) throws ParseException {
            ArrayList filesInfo = new ArrayList();
            for (ContainerLogMeta logMeta : containersLogMeta) {
                filesInfo.addAll(logMeta.getContainerLogMeta());
            }
            Collections.sort(filesInfo, new Comparator<ContainerLogFileInfo>(){

                @Override
                public int compare(ContainerLogFileInfo o1, ContainerLogFileInfo o2) {
                    return this.createAggregatedLogFileName(o1.getFileName(), o1.getLastModifiedTime()).compareTo(this.createAggregatedLogFileName(o2.getFileName(), o2.getLastModifiedTime()));
                }
            });
            boolean foundLogFile = false;
            for (ContainerLogFileInfo fileInfo : filesInfo) {
                long timestamp = this.convertDateToTimeStamp(fileInfo.getLastModifiedTime());
                foundLogFile = true;
                String fileName = this.createAggregatedLogFileName(fileInfo.getFileName(), fileInfo.getLastModifiedTime());
                html.p().a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), fileInfo.getFileName(), "?start=-4096&log.aggregation.type=remote&start.time=" + (timestamp - 1000L) + "&end.time=" + (timestamp + 1000L)}), fileName + " : Total file length is " + fileInfo.getFileSize() + " bytes.").__();
            }
            if (!foundLogFile) {
                html.h4("No aggregated logs available for container " + this.$("container.id"));
                return;
            }
        }

        private String createAggregatedLogFileName(String fileName, String modificationTime) {
            return fileName + "_" + modificationTime;
        }

        private long convertDateToTimeStamp(String dateTime) throws ParseException {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy");
            Date d = sdf.parse(dateTime);
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            return c.getTimeInMillis();
        }
    }
}

