/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.util.Map;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerInspectCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerCommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DockerCommandExecutor.class);

    private DockerCommandExecutor() {
    }

    public static String executeDockerCommand(DockerCommand dockerCommand, String containerId, Map<String, String> env, PrivilegedOperationExecutor privilegedOperationExecutor, boolean disableFailureLogging, Context nmContext) throws ContainerExecutionException {
        PrivilegedOperation dockerOp = dockerCommand.preparePrivilegedOperation(dockerCommand, containerId, env, nmContext);
        if (disableFailureLogging) {
            dockerOp.disableFailureLogging();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running docker command: " + dockerCommand);
        }
        try {
            String result = privilegedOperationExecutor.executePrivilegedOperation(null, dockerOp, null, env, true, false);
            if (result != null && !result.isEmpty()) {
                result = result.trim();
            }
            return result;
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Docker operation failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    public static DockerContainerStatus getContainerStatus(String containerId, PrivilegedOperationExecutor privilegedOperationExecutor, Context nmContext) {
        try {
            String currentContainerStatus = DockerCommandExecutor.executeStatusCommand(containerId, privilegedOperationExecutor, nmContext);
            DockerContainerStatus dockerContainerStatus = currentContainerStatus == null ? DockerContainerStatus.UNKNOWN : (currentContainerStatus.equals(DockerContainerStatus.CREATED.getName()) ? DockerContainerStatus.CREATED : (currentContainerStatus.equals(DockerContainerStatus.RUNNING.getName()) ? DockerContainerStatus.RUNNING : (currentContainerStatus.equals(DockerContainerStatus.STOPPED.getName()) ? DockerContainerStatus.STOPPED : (currentContainerStatus.equals(DockerContainerStatus.RESTARTING.getName()) ? DockerContainerStatus.RESTARTING : (currentContainerStatus.equals(DockerContainerStatus.REMOVING.getName()) ? DockerContainerStatus.REMOVING : (currentContainerStatus.equals(DockerContainerStatus.DEAD.getName()) ? DockerContainerStatus.DEAD : (currentContainerStatus.equals(DockerContainerStatus.EXITED.getName()) ? DockerContainerStatus.EXITED : (currentContainerStatus.equals(DockerContainerStatus.NONEXISTENT.getName()) ? DockerContainerStatus.NONEXISTENT : DockerContainerStatus.UNKNOWN))))))));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Container Status: " + dockerContainerStatus.getName() + " ContainerId: " + containerId);
            }
            return dockerContainerStatus;
        }
        catch (ContainerExecutionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Container Status: " + DockerContainerStatus.NONEXISTENT.getName() + " ContainerId: " + containerId);
            }
            return DockerContainerStatus.NONEXISTENT;
        }
    }

    private static String executeStatusCommand(String containerId, PrivilegedOperationExecutor privilegedOperationExecutor, Context nmContext) throws ContainerExecutionException {
        DockerInspectCommand dockerInspectCommand = new DockerInspectCommand(containerId).getContainerStatus();
        try {
            return DockerCommandExecutor.executeDockerCommand(dockerInspectCommand, containerId, null, privilegedOperationExecutor, true, nmContext);
        }
        catch (ContainerExecutionException e) {
            throw new ContainerExecutionException((Throwable)((Object)e));
        }
    }

    public static boolean isStoppable(DockerContainerStatus containerStatus) {
        return containerStatus.equals((Object)DockerContainerStatus.RUNNING) || containerStatus.equals((Object)DockerContainerStatus.RESTARTING);
    }

    public static boolean isKillable(DockerContainerStatus containerStatus) {
        return DockerCommandExecutor.isStoppable(containerStatus);
    }

    public static boolean isRemovable(DockerContainerStatus containerStatus) {
        return !containerStatus.equals((Object)DockerContainerStatus.NONEXISTENT) && !containerStatus.equals((Object)DockerContainerStatus.UNKNOWN) && !containerStatus.equals((Object)DockerContainerStatus.REMOVING) && !containerStatus.equals((Object)DockerContainerStatus.RUNNING);
    }

    public static boolean isStartable(DockerContainerStatus containerStatus) {
        return containerStatus.equals((Object)DockerContainerStatus.EXITED) || containerStatus.equals((Object)DockerContainerStatus.STOPPED);
    }

    public static enum DockerContainerStatus {
        CREATED("created"),
        RUNNING("running"),
        STOPPED("stopped"),
        RESTARTING("restarting"),
        REMOVING("removing"),
        DEAD("dead"),
        EXITED("exited"),
        NONEXISTENT("nonexistent"),
        UNKNOWN("unknown");

        private final String name;

        private DockerContainerStatus(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

