/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.TextParseException;
import org.apache.hadoop.shaded.org.xbill.DNS.Tokenizer;

abstract class TXTBase
extends Record {
    private static final long serialVersionUID = -4319510507246305931L;
    protected List strings;

    protected TXTBase() {
    }

    protected TXTBase(Name name, int type, int dclass, long ttl) {
        super(name, type, dclass, ttl);
    }

    protected TXTBase(Name name, int type, int dclass, long ttl, List strings) {
        super(name, type, dclass, ttl);
        if (strings == null) {
            throw new IllegalArgumentException("strings must not be null");
        }
        this.strings = new ArrayList(strings.size());
        Iterator it = strings.iterator();
        try {
            while (it.hasNext()) {
                String s = (String)it.next();
                this.strings.add(TXTBase.byteArrayFromString(s));
            }
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected TXTBase(Name name, int type, int dclass, long ttl, String string) {
        this(name, type, dclass, ttl, Collections.singletonList(string));
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.strings = new ArrayList(2);
        while (in.remaining() > 0) {
            byte[] b = in.readCountedString();
            this.strings.add(b);
        }
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.strings = new ArrayList(2);
        while ((t = st.get()).isString()) {
            try {
                this.strings.add(TXTBase.byteArrayFromString(t.value));
            }
            catch (TextParseException e) {
                throw st.exception(e.getMessage());
            }
        }
        st.unget();
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            byte[] array = (byte[])it.next();
            sb.append(TXTBase.byteArrayToString(array, true));
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List getStrings() {
        ArrayList<String> list = new ArrayList<String>(this.strings.size());
        for (int i = 0; i < this.strings.size(); ++i) {
            list.add(TXTBase.byteArrayToString((byte[])this.strings.get(i), false));
        }
        return list;
    }

    public List getStringsAsByteArrays() {
        return this.strings;
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            byte[] b = (byte[])it.next();
            out.writeCountedString(b);
        }
    }
}

