/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.Attribute;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;

public class SSLUtils {
    public static final String SSL_ENGINE_ATTR_NAME = "SSLEngineAttr";
    public static final Attribute<SSLEngine> sslEngineAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLEngineAttr");
    private static final byte CHANGE_CIPHER_SPECT_CONTENT_TYPE = 20;
    private static final byte APPLICATION_DATA_CONTENT_TYPE = 23;
    private static final int SSLV3_RECORD_HEADER_SIZE = 5;
    private static final int SSL20_HELLO_VERSION = 2;
    private static final int MIN_VERSION = 768;
    private static final int MAX_MAJOR_VERSION = 3;

    public static SSLEngine getSSLEngine(AttributeStorage storage) {
        return sslEngineAttribute.get(storage);
    }

    public static void setSSLEngine(AttributeStorage storage, SSLEngine sslEngine) {
        sslEngineAttribute.set(storage, sslEngine);
    }

    public static int getSSLPacketSize(Buffer buf) throws SSLException {
        int len;
        if (buf.remaining() < 5) {
            return -1;
        }
        int pos = buf.position();
        byte byteZero = buf.get(pos);
        if (byteZero >= 20 && byteZero <= 23) {
            byte minor;
            byte major = buf.get(pos + 1);
            int v = major << 8 | (minor = buf.get(pos + 2)) & 0xFF;
            if (v < 768 || major > 3) {
                throw new SSLException("Unsupported record version major=" + major + " minor=" + minor);
            }
            len = ((buf.get(pos + 3) & 0xFF) << 8) + (buf.get(pos + 4) & 0xFF) + 5;
        } else {
            boolean isShort;
            boolean bl = isShort = (byteZero & 0x80) != 0;
            if (isShort && (buf.get(pos + 2) == 1 || buf.get(pos + 2) == 4)) {
                byte minor;
                byte major = buf.get(pos + 3);
                int v = major << 8 | (minor = buf.get(pos + 4)) & 0xFF;
                if ((v < 768 || major > 3) && v != 2) {
                    throw new SSLException("Unsupported record version major=" + major + " minor=" + minor);
                }
                int mask = 127;
                len = ((byteZero & mask) << 8) + (buf.get(pos + 1) & 0xFF) + 2;
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return len;
    }

    public static void executeDelegatedTask(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    public static boolean isHandshaking(SSLEngine sslEngine) {
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        return handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public static SSLEngineResult handshakeUnwrap(Connection connection, SSLEngine sslEngine, Buffer inputBuffer) throws SSLException {
        SSLEngineResult sslEngineResult;
        int expectedLength = SSLUtils.getSSLPacketSize(inputBuffer);
        if (expectedLength == -1 || inputBuffer.remaining() < expectedLength) {
            return null;
        }
        MemoryManager memoryManager = connection.getTransport().getMemoryManager();
        int pos = inputBuffer.position();
        int appBufferSize = sslEngine.getSession().getApplicationBufferSize();
        if (!inputBuffer.isComposite()) {
            ByteBuffer inputBB = inputBuffer.toByteBuffer();
            Object outputBuffer = memoryManager.allocate(appBufferSize);
            sslEngineResult = sslEngine.unwrap(inputBB, outputBuffer.toByteBuffer());
            outputBuffer.dispose();
            inputBuffer.position(pos + sslEngineResult.bytesConsumed());
            if (inputBuffer.hasRemaining()) {
                inputBuffer.compact();
                inputBuffer.trim();
            }
        } else {
            ByteBuffer inputByteBuffer = inputBuffer.toByteBuffer(pos, pos + expectedLength);
            Object outputBuffer = memoryManager.allocate(appBufferSize);
            sslEngineResult = sslEngine.unwrap(inputByteBuffer, outputBuffer.toByteBuffer());
            inputBuffer.position(pos + sslEngineResult.bytesConsumed());
            outputBuffer.dispose();
        }
        return sslEngineResult;
    }

    public static Buffer handshakeWrap(Connection connection, SSLEngine sslEngine) throws SSLException {
        MemoryManager memoryManager = connection.getTransport().getMemoryManager();
        Object buffer = memoryManager.allocate(sslEngine.getSession().getPacketBufferSize());
        buffer.allowBufferDispose(true);
        try {
            SSLEngineResult sslEngineResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, buffer.toByteBuffer());
            buffer.position(sslEngineResult.bytesProduced());
            buffer.trim();
            return buffer;
        }
        catch (SSLException e) {
            buffer.dispose();
            throw e;
        }
    }
}

