/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core.spi.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ServiceUtils {
    private ServiceUtils() {
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceUtils.findAmongst(clazz, instances.toArray());
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Object ... instances) {
        ArrayList<T> matches = new ArrayList<T>();
        for (Object instance : instances) {
            if (instance == null || !clazz.isAssignableFrom(instance.getClass())) continue;
            matches.add(clazz.cast(instance));
        }
        return Collections.unmodifiableCollection(matches);
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceUtils.findSingletonAmongst(clazz, instances.toArray());
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Object ... instances) {
        Collection<T> matches = ServiceUtils.findAmongst(clazz, instances);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return matches.iterator().next();
        }
        throw new IllegalArgumentException("More than one " + clazz.getName() + " found");
    }
}

